/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.tree;

import groove.grammar.model.GrammarModel;
import groove.gui.Icons;
import groove.gui.Options;
import groove.gui.SimulatorModel;
import groove.gui.display.DisplayKind;
import groove.gui.display.ResourceDisplay;
import groove.gui.tree.AbstractResourceTree;
import groove.gui.tree.DisplayTreeCellRenderer;
import groove.gui.tree.DisplayTreeNode;
import groove.gui.tree.ResourceTreeNode;
import groove.lts.GraphState;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ResourceTree
extends AbstractResourceTree {
    private final DefaultTreeModel tree;
    private final DisplayTreeNode root;
    private Color enabledBackground;
    private static final String SEPARATOR = ".";

    public ResourceTree(ResourceDisplay parent) {
        super(parent);
        this.setLargeModel(true);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setEnabled(false);
        this.setToggleClickCount(0);
        DisplayTreeCellRenderer renderer = new DisplayTreeCellRenderer(this);
        renderer.setLeafIcon(Icons.getListIcon(parent.getResourceKind()));
        this.setCellRenderer(renderer);
        this.getSelectionModel().setSelectionMode(4);
        this.root = new DisplayTreeNode();
        this.tree = new DefaultTreeModel(this.root, true);
        this.setModel(this.tree);
        ActionMap am = this.getActionMap();
        am.put("Step Back", this.getActions().getBackAction());
        am.put("Step Forward", this.getActions().getForwardAction());
        InputMap im = this.getInputMap();
        im.put(Options.BACK_KEY, "Step Back");
        im.put(Options.FORWARD_KEY, "Step Forward");
        this.installListeners();
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    MouseListener createMouseListener() {
        return new MyMouseListener();
    }

    private Set<DisplayTreeNode> loadGrammar(GrammarModel grammar) {
        HashSet<DisplayTreeNode> result = new HashSet<DisplayTreeNode>();
        FolderTree ftree = new FolderTree();
        for (String resource : grammar.getNames(this.getResourceKind())) {
            ftree.insert(resource);
        }
        ftree.store(this.root, "", result);
        return result;
    }

    @Override
    public void update(SimulatorModel source, SimulatorModel oldModel, Set<SimulatorModel.Change> changes) {
        this.suspendListeners();
        if (changes.contains((Object)SimulatorModel.Change.GRAMMAR)) {
            HashSet<String> visible = new HashSet<String>();
            Set<String> selected = this.getSimulatorModel().getSelectSet(this.getResourceKind());
            int i = 0;
            while (i < this.getRowCount()) {
                TreePath path = this.getPathForRow(i);
                TreeNode treeNode = (TreeNode)path.getLastPathComponent();
                if (treeNode instanceof ResourceTreeNode) {
                    ResourceTreeNode rnode = (ResourceTreeNode)treeNode;
                    visible.add(rnode.getName());
                } else if (treeNode instanceof PathNode) {
                    PathNode pnode = (PathNode)treeNode;
                    visible.add(pnode.getPathName());
                }
                ++i;
            }
            this.root.removeAllChildren();
            GrammarModel grammar = source.getGrammar();
            if (grammar != null) {
                Set<DisplayTreeNode> created = this.loadGrammar(grammar);
                this.tree.reload(this.root);
                for (DisplayTreeNode displayTreeNode : created) {
                    TreePath path;
                    String name;
                    if (displayTreeNode instanceof ResourceTreeNode) {
                        name = ((ResourceTreeNode)displayTreeNode).getName();
                        if (!visible.contains(name) && !selected.contains(name)) continue;
                        path = new TreePath(displayTreeNode.getPath());
                        this.expandPath(path.getParentPath());
                        if (this.getSimulatorModel().getSelectSet(this.getResourceKind()).contains(name)) {
                            this.addSelectionPath(path);
                        }
                        if (!selected.contains(name)) continue;
                        this.addSelectionPath(path);
                        continue;
                    }
                    if (!(displayTreeNode instanceof PathNode) || !visible.contains(name = ((PathNode)displayTreeNode).getPathName())) continue;
                    path = new TreePath(displayTreeNode.getPath());
                    this.expandPath(path.getParentPath());
                }
                this.refresh(source.getState());
            }
        }
        this.activateListeners();
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            if (!enabled) {
                this.enabledBackground = this.getBackground();
                this.setBackground(null);
            } else if (this.enabledBackground != null) {
                this.setBackground(this.enabledBackground);
            }
        }
        super.setEnabled(enabled);
    }

    private void refresh(GraphState state) {
        this.setEnabled(this.getGrammar() != null);
    }

    public void mouseClicked(TreeNode node, MouseEvent event) {
    }

    public void mousePressed(TreeNode node, MouseEvent event) {
    }

    private class FolderTree {
        private final TreeMap<String, FolderTree> folders = new TreeMap();
        private final TreeSet<String> resources = new TreeSet();

        public void insert(String resource) {
            String[] components = resource.split("\\.");
            this.insert(0, components, resource);
        }

        private void insert(int index, String[] components, String resource) {
            if (index == components.length - 1) {
                this.resources.add(components[index]);
            } else {
                FolderTree folder = this.folders.get(components[index]);
                if (folder == null) {
                    folder = new FolderTree();
                }
                folder.insert(index + 1, components, resource);
                this.folders.put(components[index], folder);
            }
        }

        public void store(DisplayTreeNode root, String path, Set<DisplayTreeNode> created) {
            for (Map.Entry<String, FolderTree> entry : this.folders.entrySet()) {
                String subpath = this.extendPath(path, entry.getKey());
                PathNode node = new PathNode(subpath, entry.getKey());
                entry.getValue().store(node, subpath, created);
                created.add(node);
                root.insertSorted(node);
            }
            for (String resource : this.resources) {
                String fullName = this.extendPath(path, resource);
                ResourceTreeNode leaf = new ResourceTreeNode(ResourceTree.this.getParentDisplay(), fullName);
                created.add(leaf);
                root.insertSorted(leaf);
            }
        }

        private String extendPath(String path, String child) {
            if (path.equals("")) {
                return child;
            }
            return String.valueOf(path) + ResourceTree.SEPARATOR + child;
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            TreeNode selected = this.getMousedNode(evt);
            if (evt.isPopupTrigger()) {
                this.showPopupMenu(selected, evt);
            }
            DisplayKind display = DisplayKind.toDisplay(ResourceTree.this.getResourceKind());
            if (selected instanceof ResourceTreeNode && display != null) {
                ResourceTree.this.getSimulatorModel().setDisplay(display);
            }
            if (selected instanceof ResourceTreeNode && evt.getClickCount() > 1) {
                ResourceTree.this.getActions().getEditAction(ResourceTree.this.getResourceKind()).execute();
            }
            ResourceTree.this.mousePressed(selected, evt);
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            TreeNode selected = this.getMousedNode(evt);
            if (evt.isPopupTrigger()) {
                this.showPopupMenu(selected, evt);
            }
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            ResourceTree.this.mouseClicked(this.getMousedNode(evt), evt);
        }

        private TreeNode getMousedNode(MouseEvent evt) {
            Object selected;
            TreePath path = ResourceTree.this.getPathForLocation(evt.getX(), evt.getY());
            if (path == null) {
                return null;
            }
            if (evt.isPopupTrigger()) {
                ResourceTree.this.setSelectionPath(path);
            }
            if ((selected = path.getLastPathComponent()) instanceof TreeNode) {
                return (TreeNode)selected;
            }
            return null;
        }

        public void showPopupMenu(TreeNode node, MouseEvent evt) {
            ResourceTree.this.requestFocus();
            JPopupMenu menu = ResourceTree.this.createPopupMenu(node);
            if (menu != null) {
                menu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }
    }

    class PathNode
    extends AbstractResourceTree.FolderTreeNode {
        private final String pathName;

        public PathNode(String fullName, String shortName) {
            super(shortName);
            this.pathName = fullName;
        }

        public String getPathName() {
            return this.pathName;
        }
    }
}

