/*
 * Decompiled with CFR 0.152.
 */
package groove.io;

import groove.gui.Options;
import groove.gui.look.Values;
import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;

public class HTMLConverter {
    private static final String HTML_UT;
    private static final String HTML_DT;
    private static final String HTML_RT;
    private static final String HTML_LT;
    public static final String NBSP = "&#160;";
    public static final String LINK_TAG_NAME = "a";
    public static final String SPAN_TAG_NAME = "span";
    public static final String DIV_TAG_NAME = "div";
    public static final String TABLE_TAG_NAME = "table";
    public static final String STYLE_ATTR_NAME = "style";
    public static final HTMLTag CENTER_TAG;
    public static final HTMLTag HTML_TAG;
    public static final HTMLTag ITALIC_TAG;
    public static final HTMLTag STRIKETHROUGH_TAG;
    public static final HTMLTag STRONG_TAG;
    public static final HTMLTag SUB_TAG;
    public static final HTMLTag SUPER_TAG;
    public static final HTMLTag UNDERLINE_TAG;
    public static final String HTML_LINEBREAK;
    public static final String HTML_HORIZONTAL_LINE;
    private static final Map<Color, HTMLTag> colorTagMap;
    private static final int MAX_ALPHA = 255;
    public static final HTMLTag ERASER_TAG;
    public static final HTMLTag CREATOR_TAG;
    public static final HTMLTag EMBARGO_TAG;
    public static final HTMLTag REMARK_TAG;

    static {
        HTMLTag symbolTag = null;
        if (Options.SYMBOL_FONT != null && Options.SYMBOL_FONT != Options.LABEL_FONT) {
            Font font = Options.SYMBOL_FONT;
            String face = font.getFamily();
            int size = font.getSize();
            String argument = String.format("font-family:%s; font-size:%dpx", face, size);
            symbolTag = HTMLConverter.createSpanTag(argument);
        }
        HTML_UT = HTMLConverter.tagOn(symbolTag, '\u25b4');
        HTML_DT = HTMLConverter.tagOn(symbolTag, '\u25be');
        HTML_LT = HTMLConverter.tagOn(symbolTag, '\u25c2');
        HTML_RT = HTMLConverter.tagOn(symbolTag, '\u25b8');
        CENTER_TAG = new HTMLTag("center");
        HTML_TAG = new HTMLTag("html");
        ITALIC_TAG = new HTMLTag("i");
        STRIKETHROUGH_TAG = new HTMLTag("s");
        STRONG_TAG = new HTMLTag("strong");
        SUB_TAG = new HTMLTag("sub");
        SUPER_TAG = new HTMLTag("sup");
        UNDERLINE_TAG = new HTMLTag("u");
        HTML_LINEBREAK = HTMLConverter.createHtmlTag((String)"br").tagBegin;
        HTML_HORIZONTAL_LINE = HTMLConverter.createHtmlTag((String)"hr").tagBegin;
        colorTagMap = new HashMap<Color, HTMLTag>();
        ERASER_TAG = HTMLConverter.createColorTag(Values.ERASER_FOREGROUND);
        CREATOR_TAG = HTMLConverter.createColorTag(Values.CREATOR_FOREGROUND);
        EMBARGO_TAG = HTMLConverter.createColorTag(Values.EMBARGO_FOREGROUND);
        REMARK_TAG = HTMLConverter.createColorTag(Values.REMARK_FOREGROUND);
    }

    public static String toHtml(char unicode) {
        return "&#" + unicode + ";";
    }

    public static String toHtml(Object text) {
        return HTMLConverter.toHtml(new StringBuilder(text.toString())).toString();
    }

    public static StringBuilder toHtml(StringBuilder text) {
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            String html = null;
            switch (c) {
                case '/': 
                case '<': 
                case '>': {
                    html = HTMLConverter.toHtml(c);
                    break;
                }
                case '\n': {
                    html = HTML_LINEBREAK;
                    break;
                }
                case '\u25be': {
                    html = HTML_DT;
                    break;
                }
                case '\u25b4': {
                    html = HTML_UT;
                    break;
                }
                case '\u25c2': {
                    html = HTML_LT;
                    break;
                }
                case '\u25b8': {
                    html = HTML_RT;
                    break;
                }
                default: {
                    if (c <= '\u00ff') break;
                    html = HTMLConverter.toHtml(c);
                }
            }
            if (html != null) {
                text.replace(i, i + 1, html);
                i += html.length() - 1;
            }
            ++i;
        }
        return text;
    }

    private static final String tagOn(HTMLTag tag, char c) {
        if (tag == null) {
            return HTMLConverter.toHtml(c);
        }
        return tag.on(HTMLConverter.toHtml(c));
    }

    public static HTMLTag createHyperlink(String url) {
        return new HTMLTag(LINK_TAG_NAME, "name", url);
    }

    public static HTMLTag createHtmlTag(String tag) {
        return new HTMLTag(tag);
    }

    public static HTMLTag createHtmlTag(String tag, String attribute, String arguments) {
        return new HTMLTag(tag, attribute, arguments);
    }

    public static HTMLTag createSpanTag(String arguments) {
        return new HTMLTag(SPAN_TAG_NAME, STYLE_ATTR_NAME, arguments);
    }

    public static HTMLTag createDivTag(String arguments) {
        return new HTMLTag(DIV_TAG_NAME, STYLE_ATTR_NAME, arguments);
    }

    public static HTMLTag createColorTag(Color color) {
        HTMLTag result = colorTagMap.get(color);
        if (result == null) {
            StringBuffer arg = new StringBuffer();
            int red = color.getRed();
            int blue = color.getBlue();
            int green = color.getGreen();
            int alpha = color.getAlpha();
            arg.append("color: rgb(");
            arg.append(red);
            arg.append(",");
            arg.append(green);
            arg.append(",");
            arg.append(blue);
            arg.append(");");
            if (alpha != 255) {
                double alphaFraction = (double)alpha / 255.0;
                arg.append("float:left;filter:alpha(opacity=");
                arg.append((int)(100.0 * alphaFraction));
                arg.append(");opacity:");
                arg.append(alphaFraction);
                arg.append(";");
            }
            result = HTMLConverter.createSpanTag(arg.toString());
            colorTagMap.put(color, result);
        }
        return result;
    }

    public static String toUppercase(String text, boolean upper) {
        return HTMLConverter.toUppercase(new StringBuilder(text), upper).toString();
    }

    public static StringBuilder toUppercase(StringBuilder text, boolean upper) {
        Character firstChar = Character.valueOf(text.charAt(0));
        firstChar = upper ? Character.valueOf(Character.toUpperCase(firstChar.charValue())) : Character.valueOf(Character.toLowerCase(firstChar.charValue()));
        text.replace(0, 1, firstChar.toString());
        return text;
    }

    public static int removeColorTags(StringBuilder htmlLine) {
        String originalLine = htmlLine.toString();
        int result = 0;
        if (!ERASER_TAG.off(htmlLine).equals(originalLine)) {
            result = 1;
        } else if (!CREATOR_TAG.off(htmlLine).equals(originalLine)) {
            result = 2;
        } else if (!EMBARGO_TAG.off(htmlLine).equals(originalLine)) {
            result = 3;
        } else if (!REMARK_TAG.off(htmlLine).equals(originalLine)) {
            result = 4;
        }
        return result;
    }

    public static int removeFontTags(StringBuilder htmlLine) {
        String originalLine = htmlLine.toString();
        int bold = 0;
        int italic = 0;
        if (!STRONG_TAG.off(htmlLine).equals(originalLine)) {
            bold = 1;
            originalLine = htmlLine.toString();
        }
        if (!ITALIC_TAG.off(htmlLine).equals(originalLine)) {
            italic = 2;
        }
        return bold + italic;
    }

    public static class HTMLTag {
        public final String tagBegin;
        public String tagEnd;

        public HTMLTag(String tag) {
            this.tagBegin = String.format("<%s>", tag);
            this.tagEnd = String.format("</%s>", tag);
        }

        public HTMLTag(String tag, String attrName, String attrValue) {
            this.tagBegin = String.format("<%s %s=\"%s\">", tag, attrName, HTMLConverter.toHtml(attrValue));
            this.tagEnd = String.format("</%s>", tag);
        }

        public String on(Object text) {
            return this.on(new StringBuilder(text.toString())).toString();
        }

        public StringBuilder on(StringBuilder text) {
            text.insert(0, this.tagBegin);
            text.append(this.tagEnd);
            return text;
        }

        public String on(Object text, boolean convert) {
            if (convert) {
                return this.on(HTMLConverter.toHtml(new StringBuilder(text.toString()))).toString();
            }
            return this.on(text);
        }

        public String[] on(Object[] text) {
            return this.on(text, false);
        }

        public String[] on(Object[] text, boolean convert) {
            String[] result = new String[text.length];
            int labelIndex = 0;
            while (labelIndex < text.length) {
                result[labelIndex] = this.on(text[labelIndex], convert);
                ++labelIndex;
            }
            return result;
        }

        public String off(StringBuilder text) {
            int tagEndStart = text.indexOf(this.tagEnd);
            int tagBeginStart = text.indexOf(this.tagBegin);
            if (tagEndStart > -1 && tagBeginStart > -1) {
                int end = tagEndStart + this.tagEnd.length();
                text.replace(tagEndStart, end, "");
                end = tagBeginStart + this.tagBegin.length();
                text.replace(tagBeginStart, end, "");
            }
            return text.toString();
        }

        public String off(String text) {
            int tagEndStart = text.indexOf(this.tagEnd);
            int tagBeginStart = text.indexOf(this.tagBegin);
            if (tagEndStart > -1 && tagBeginStart > -1) {
                int end = tagEndStart + this.tagEnd.length();
                text = String.valueOf(text.substring(0, tagEndStart)) + text.substring(end);
                end = tagBeginStart + this.tagBegin.length();
                text = String.valueOf(text.substring(0, tagBeginStart)) + text.substring(end);
            }
            return text;
        }
    }
}

