/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.configuration;

import groove.grammar.model.ResourceKind;
import groove.gui.Icons;
import groove.gui.Options;
import groove.gui.Simulator;
import groove.gui.action.SimulatorAction;
import groove.io.conceptual.configuration.ConfigDialog;
import javax.swing.Icon;

public class ConfigAction
extends SimulatorAction {
    private Type m_type;
    private ConfigDialog m_dlg;

    protected ConfigAction(Simulator simulator, Type type, ConfigDialog dlg) {
        super(simulator, type.getText(), type.getIcon(), null, ResourceKind.CONFIG);
        this.m_type = type;
        this.m_dlg = dlg;
    }

    @Override
    public void execute() {
        String modelName = null;
        switch (this.m_type) {
            case NEW: {
                String newName = this.askNewName(Options.getNewResourceName(this.getResourceKind()), true);
                if (newName == null) {
                    return;
                }
                modelName = newName;
                break;
            }
            case SAVE: {
                if (this.m_dlg.hasModels()) break;
                String saveName = this.askNewName(Options.getNewResourceName(this.getResourceKind()), true);
                if (saveName == null) {
                    return;
                }
                modelName = saveName;
                break;
            }
            case DELETE: {
                break;
            }
            case RENAME: {
                String oldName = "configuration";
                String renameName = this.askNewName(oldName, false);
                if (renameName == null) {
                    return;
                }
                modelName = renameName;
                break;
            }
            case COPY: {
                String copyName = this.askNewName(Options.getNewResourceName(this.getResourceKind()), true);
                if (copyName == null) {
                    return;
                }
                modelName = copyName;
            }
        }
        this.m_dlg.executeAction(this.m_type, modelName);
    }

    public static enum Type {
        NEW("New", Icons.NEW_ICON),
        SAVE("Save", Icons.SAVE_ICON),
        COPY("Copy", Icons.COPY_ICON),
        DELETE("Delete", Icons.DELETE_ICON),
        RENAME("Rename", Icons.RENAME_ICON);

        private String m_text;
        private Icon m_icon;

        private Type(String text, Icon icon) {
            this.m_text = text;
            this.m_icon = icon;
        }

        public String getText() {
            return this.m_text;
        }

        public Icon getIcon() {
            return this.m_icon;
        }
    }
}

