/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.configuration;

import com.jaxfront.core.dom.DOMBuilder;
import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.dom.DocumentCreationException;
import com.jaxfront.core.schema.SchemaCreationException;
import com.jaxfront.core.schema.ValidationException;
import com.jaxfront.swing.ui.editor.EditorPanel;
import com.jaxfront.swing.ui.editor.TypeWorkspace;
import com.jaxfront.swing.ui.wrapper.JAXJSplitPane;
import groove.gui.Simulator;
import groove.io.conceptual.configuration.ConfigDialog;
import groove.io.conceptual.configuration.ConfigurationException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.apache.xerces.xni.parser.XMLParseException;
import org.xml.sax.SAXException;

public class JaxFrontDialog
extends ConfigDialog {
    private JPanel m_panel;
    private EditorPanel m_editor;
    private Component m_panelComponent;
    private static Object s_tooltipObj = UIManager.get("ToolTipUI");

    public JaxFrontDialog(Simulator simulator) {
        super(simulator);
    }

    @Override
    public String getConfig() {
        String result = super.getConfig();
        UIManager.put("ToolTipUI", s_tooltipObj);
        return result;
    }

    @Override
    protected JPanel getXMLPanel() {
        this.m_panel = new JPanel();
        this.m_panel.setLayout(new BorderLayout());
        this.newModel();
        return this.m_panel;
    }

    private void setDocument(Document doc) {
        if (this.m_panelComponent != null) {
            this.m_panel.remove(this.m_panelComponent);
        }
        this.m_editor = new EditorPanel(doc.getRootType(), null);
        this.m_panelComponent = this.m_editor;
        try {
            JAXJSplitPane pane = (JAXJSplitPane)this.m_editor.getComponent(0);
            TypeWorkspace space = (TypeWorkspace)pane.getRightComponent();
            space.getButtonBar().setVisible(false);
            space.getHeaderPanel().setVisible(false);
            space.getMessageTablePanel().setVisible(false);
            this.m_panelComponent = pane.getRightComponent();
            this.m_panel.add(this.m_panelComponent);
        }
        catch (ClassCastException classCastException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        this.m_panel.add(this.m_panelComponent);
        this.m_panel.validate();
        this.m_panel.repaint();
    }

    @Override
    protected void newModel() {
        try {
            Document dom = DOMBuilder.getInstance().build(null, this.m_schemaURL, "configuration");
            this.setDocument(dom);
        }
        catch (SchemaCreationException schemaCreationException) {
        }
        catch (DocumentCreationException documentCreationException) {}
    }

    @Override
    protected void loadModel(String xmlString) throws ConfigurationException {
        try {
            org.w3c.dom.Document xmlDoc = DOMHelper.createDocument((String)xmlString);
            Document doc = DOMBuilder.getInstance().build(null, this.m_schemaURL, xmlDoc, null, "configuration");
            this.setDocument(doc);
        }
        catch (SAXException e) {
            throw new ConfigurationException(e);
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
        catch (SchemaCreationException e) {
            throw new ConfigurationException((Exception)((Object)e));
        }
        catch (DocumentCreationException e) {
            throw new ConfigurationException((Exception)((Object)e));
        }
    }

    @Override
    protected org.w3c.dom.Document getDocument() throws ConfigurationException {
        try {
            return this.m_editor.getDOM().serializeToW3CDocument();
        }
        catch (XMLParseException e) {
            throw new ConfigurationException((Exception)((Object)e));
        }
        catch (SAXException e) {
            throw new ConfigurationException(e);
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
        catch (ValidationException e) {
            throw new ConfigurationException((Exception)((Object)e));
        }
    }
}

