/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.graph;

import groove.grammar.aspect.AspectEdge;
import groove.grammar.aspect.AspectLabel;
import groove.grammar.aspect.AspectParser;
import groove.graph.GraphRole;
import groove.io.conceptual.graph.AbsNode;
import java.util.ArrayList;
import java.util.List;

public class AbsEdge {
    String m_name;
    AbsNode m_source;
    AbsNode m_target;
    List<AspectEdge> m_aspectEdges = new ArrayList<AspectEdge>();

    public AbsEdge(AbsNode source, AbsNode target, String name) {
        if (target == null) {
            throw new NullPointerException();
        }
        this.m_source = source;
        this.m_target = target;
        this.m_name = name;
        source.addEdge(this);
        target.addTargetEdge(this);
    }

    public AbsNode getSource() {
        return this.m_source;
    }

    public AbsNode getTarget() {
        return this.m_target;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String toString() {
        return this.m_name;
    }

    public void buildAspect(GraphRole role) {
        String[] labels;
        if (this.m_aspectEdges.size() != 0) {
            return;
        }
        this.m_source.buildAspect(role);
        this.m_target.buildAspect(role);
        String[] stringArray = labels = this.m_name.split("\n");
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            String sublabel = stringArray[n2];
            AspectLabel alabel = AspectParser.getInstance().parse(sublabel, role);
            if (alabel.isEdgeOnly()) {
                AspectEdge newEdge = new AspectEdge(this.m_source.getAspect(), alabel, this.m_target.getAspect());
                this.m_aspectEdges.add(newEdge);
            }
            ++n2;
        }
    }

    public List<AspectEdge> getAspect() {
        return this.m_aspectEdges;
    }
}

