/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.graph;

import groove.grammar.aspect.AspectEdge;
import groove.grammar.aspect.AspectLabel;
import groove.grammar.aspect.AspectNode;
import groove.grammar.aspect.AspectParser;
import groove.graph.GraphRole;
import groove.io.conceptual.graph.AbsEdge;
import groove.io.conceptual.graph.AbsGraph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AbsNode {
    private String[] m_names;
    private List<AbsEdge> m_edges = new ArrayList<AbsEdge>();
    private List<AbsEdge> m_targetEdges = new ArrayList<AbsEdge>();
    private AspectNode m_aspectNode;
    private List<AspectEdge> m_aspectEdges = new ArrayList<AspectEdge>();
    private AbsGraph m_parent = null;
    private int m_id = 0;

    public AbsNode(String ... names) {
        this.m_names = names;
    }

    public void addEdge(AbsEdge e) {
        this.m_edges.add(e);
    }

    public void addTargetEdge(AbsEdge e) {
        this.m_targetEdges.add(e);
    }

    public List<AbsEdge> getEdges() {
        return this.m_edges;
    }

    public List<AbsEdge> getTargetEdges() {
        return this.m_targetEdges;
    }

    public String toString() {
        return Arrays.toString(this.m_names);
    }

    public String[] getNames() {
        return this.m_names;
    }

    public void addName(String name) {
        String[] newNames = new String[this.m_names.length + 1];
        System.arraycopy(this.m_names, 0, newNames, 0, this.m_names.length);
        newNames[this.m_names.length] = name;
        this.m_names = newNames;
    }

    public void addToGraph(AbsGraph g, int id) {
        if (this.m_parent != null && this.m_parent != g) {
            throw new IllegalArgumentException("AbsNode already element of a graph");
        }
        this.m_parent = g;
        this.m_id = id;
    }

    public AbsGraph getParent() {
        return this.m_parent;
    }

    public int getId() {
        return this.m_id;
    }

    public void buildAspect(GraphRole role) {
        if (this.m_parent == null) {
            throw new IllegalArgumentException("Node not part of graph");
        }
        if (this.m_aspectNode != null) {
            return;
        }
        String[] labels = this.m_names;
        this.m_aspectNode = new AspectNode(this.m_id, role);
        String[] stringArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            String sublabel = stringArray[n2];
            AspectLabel alabel = AspectParser.getInstance().parse(sublabel, role);
            if (alabel.isEdgeOnly()) {
                AspectEdge newEdge = new AspectEdge(this.m_aspectNode, alabel, this.m_aspectNode);
                this.m_aspectEdges.add(newEdge);
            } else {
                this.m_aspectNode.setAspects(alabel);
            }
            ++n2;
        }
    }

    public AspectNode getAspect() {
        return this.m_aspectNode;
    }

    public List<AspectEdge> getAspectEdges() {
        return this.m_aspectEdges;
    }
}

