/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.lang.groove;

import groove.grammar.host.HostGraph;
import groove.grammar.model.CompositeTypeModel;
import groove.grammar.model.FormatException;
import groove.grammar.model.GrammarModel;
import groove.grammar.model.GraphBasedModel;
import groove.grammar.model.HostModel;
import groove.grammar.model.ResourceKind;
import groove.grammar.model.ResourceModel;
import groove.grammar.model.RuleModel;
import groove.grammar.type.TypeGraph;
import groove.io.conceptual.InstanceModel;
import groove.io.conceptual.Timer;
import groove.io.conceptual.TypeModel;
import groove.io.conceptual.configuration.Config;
import groove.io.conceptual.lang.ImportException;
import groove.io.conceptual.lang.groove.GrammarDialog;
import groove.io.conceptual.lang.groove.GraphNodeTypes;
import groove.io.conceptual.lang.groove.GrooveToConstraint;
import groove.io.conceptual.lang.groove.GrooveToInstance;
import groove.io.conceptual.lang.groove.GrooveToMeta;
import groove.io.conceptual.lang.groove.GrooveToType;
import groove.util.Pair;
import java.awt.Frame;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class GrammarVisitor {
    private GraphNodeTypes m_types;
    private Config m_cfg;
    private String m_namespace;
    private Map<String, groove.grammar.model.TypeModel> m_typeMap;
    private Map<String, HostModel> m_hostMap;
    private Map<String, RuleModel> m_ruleMap;
    private Map<String, groove.grammar.model.TypeModel> m_metaMap;
    private String m_fixedType;
    private String m_fixedMeta;
    private String m_fixedInstance;
    private boolean useMeta;
    private TypeModel m_typeModel;
    private InstanceModel m_instanceModel;

    public GrammarVisitor(Config cfg, String namespace) {
        this.m_cfg = cfg;
        this.m_namespace = namespace;
        this.m_types = new GraphNodeTypes();
        this.useMeta = this.m_cfg.getConfig().getTypeModel().isMetaSchema();
    }

    public void setFixedType(String fixedType) {
        this.m_fixedType = fixedType;
    }

    public void setFixedMeta(String fixedMeta) {
        this.m_fixedMeta = fixedMeta;
    }

    public void setFixedInstance(String fixedInstance) {
        this.m_fixedInstance = fixedInstance;
    }

    public boolean isAmbiguous() {
        return this.m_typeMap.size() > 1 || this.m_metaMap.size() > 1 || this.m_hostMap.size() > 1;
    }

    public boolean isParseable() {
        if (this.m_cfg.getConfig().getTypeModel().isMetaSchema()) {
            return this.m_typeMap.size() == 1 || this.m_metaMap.size() == 1;
        }
        return this.m_typeMap.size() == 1;
    }

    private boolean doDialog(Frame parent) {
        GrammarDialog dlg = new GrammarDialog(parent);
        dlg.setTypeModels(this.m_typeMap.keySet());
        if (this.useMeta) {
            dlg.setMetaModels(this.m_metaMap.keySet());
        }
        dlg.setInstanceModels(this.m_hostMap.keySet(), this.m_fixedInstance != null);
        if (!dlg.doDialog()) {
            return false;
        }
        if (dlg.getTypeModel() == null || dlg.getTypeModel().equals("")) {
            return false;
        }
        this.filterMap(this.m_typeMap, dlg.getTypeModel());
        if (this.m_cfg.getConfig().getTypeModel().isMetaSchema()) {
            if (dlg.getMetaModel() != null && !dlg.getMetaModel().equals("")) {
                this.filterMap(this.m_metaMap, dlg.getTypeModel());
            } else {
                return false;
            }
        }
        if (dlg.getInstanceModel() != null) {
            if (!dlg.getInstanceModel().equals("")) {
                this.filterMap(this.m_hostMap, dlg.getInstanceModel());
            } else {
                this.m_hostMap.clear();
            }
        } else {
            return false;
        }
        return true;
    }

    private void browseGraphs(String namespace) {
        GraphBasedModel keepModel;
        this.filterMap(this.m_typeMap, namespace);
        this.filterMap(this.m_hostMap, namespace);
        this.filterMap(this.m_ruleMap, namespace);
        if (this.useMeta) {
            Iterator<Map.Entry<String, groove.grammar.model.TypeModel>> it = this.m_typeMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, groove.grammar.model.TypeModel> entry = it.next();
                if (!entry.getKey().contains("meta")) continue;
                it.remove();
                this.m_metaMap.put(entry.getKey(), entry.getValue());
            }
        }
        if (this.m_fixedType != null && this.m_typeMap.containsKey(this.m_fixedType)) {
            keepModel = this.m_typeMap.get(this.m_fixedType);
            this.m_typeMap.clear();
            this.m_typeMap.put(this.m_fixedType, (groove.grammar.model.TypeModel)keepModel);
        }
        if (this.m_fixedMeta != null && this.m_metaMap.containsKey(this.m_fixedMeta)) {
            keepModel = this.m_metaMap.get(this.m_fixedMeta);
            this.m_metaMap.clear();
            this.m_metaMap.put(this.m_fixedMeta, (groove.grammar.model.TypeModel)keepModel);
        }
        if (this.m_fixedInstance != null && this.m_hostMap.containsKey(this.m_fixedInstance)) {
            keepModel = this.m_hostMap.get(this.m_fixedInstance);
            this.m_hostMap.clear();
            this.m_hostMap.put(this.m_fixedInstance, (HostModel)keepModel);
        } else if ("".equals(this.m_fixedInstance)) {
            this.m_hostMap.clear();
        }
    }

    private <M extends ResourceModel<?>> void filterMap(Map<String, M> map, String namespace) {
        Iterator<Map.Entry<String, M>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, M> entry = it.next();
            if (!entry.getKey().startsWith(namespace)) {
                it.remove();
                continue;
            }
            if (((ResourceModel)entry.getValue()).isEnabled() && !((ResourceModel)entry.getValue()).hasErrors()) continue;
        }
    }

    public boolean doVisit(Frame parent, GrammarModel grammar) throws ImportException {
        this.m_typeMap = new HashMap(grammar.getResourceMap(ResourceKind.TYPE));
        this.m_hostMap = new HashMap(grammar.getResourceMap(ResourceKind.HOST));
        this.m_ruleMap = new HashMap(grammar.getResourceMap(ResourceKind.RULE));
        this.m_metaMap = new HashMap<String, groove.grammar.model.TypeModel>();
        this.browseGraphs(this.m_namespace);
        if (this.isAmbiguous() && (parent == null || !this.doDialog(parent))) {
            return false;
        }
        if (!this.isParseable()) {
            throw new ImportException("Unable to translate graphs, some type information is missing");
        }
        int timer = Timer.start("Load GROOVE grammar");
        if (this.m_cfg.getConfig().getTypeModel().isMetaSchema()) {
            try {
                TypeGraph metaGraph = (TypeGraph)this.m_metaMap.values().iterator().next().toResource();
                Timer.stop(timer);
                this.setMetaGraph(metaGraph);
                Timer.cont(timer);
            }
            catch (FormatException e) {
                throw new ImportException(e);
            }
        }
        HashSet<String> typeGraphSet = new HashSet<String>(this.m_typeMap.keySet());
        HashSet<String> hostGraphSet = new HashSet<String>(this.m_hostMap.keySet());
        Pair<TypeGraph, HostGraph> graphs = this.computeCompositeGraphs(grammar, typeGraphSet, hostGraphSet);
        Timer.stop(timer);
        this.setTypeGraph(graphs.one());
        this.setRuleGraphs(this.m_ruleMap.values());
        this.m_typeModel.resolve();
        Timer.cont(timer);
        if (!hostGraphSet.isEmpty()) {
            Timer.stop(timer);
            this.setInstanceGraph(graphs.two());
            Timer.cont(timer);
        }
        Timer.stop(timer);
        return true;
    }

    private void setMetaGraph(TypeGraph typeGraph) throws ImportException {
        new GrooveToMeta(typeGraph, this.m_types, this.m_cfg);
    }

    private void setTypeGraph(TypeGraph typeGraph) throws ImportException {
        GrooveToType gtt = new GrooveToType(typeGraph, this.m_types, this.m_cfg);
        this.m_typeModel = gtt.getTypeModel();
    }

    private void setRuleGraphs(Collection<RuleModel> ruleModels) throws ImportException {
        new GrooveToConstraint(ruleModels, this.m_types, this.m_cfg, this.m_typeModel);
    }

    private void setInstanceGraph(HostGraph hostGraph) throws ImportException {
        GrooveToInstance gti = new GrooveToInstance(hostGraph, this.m_types, this.m_cfg, this.m_typeModel);
        this.m_instanceModel = gti.getInstanceModel();
    }

    public TypeModel getTypeModel() {
        return this.m_typeModel;
    }

    public InstanceModel getInstanceModel() {
        return this.m_instanceModel;
    }

    private Pair<TypeGraph, HostGraph> computeCompositeGraphs(GrammarModel grammar, Set<String> typeModels, Set<String> hostModels) throws ImportException {
        Pair<TypeGraph, HostGraph> result;
        Set<String> localHostNames;
        Set<String> localTypeNames = grammar.getLocalActiveNames(ResourceKind.TYPE);
        if (localTypeNames == null) {
            localTypeNames = grammar.getActiveNames(ResourceKind.TYPE);
        }
        if ((localHostNames = grammar.getLocalActiveNames(ResourceKind.HOST)) == null) {
            localHostNames = grammar.getActiveNames(ResourceKind.HOST);
        }
        grammar.setLocalActiveNames(ResourceKind.TYPE, typeModels);
        grammar.setLocalActiveNames(ResourceKind.HOST, hostModels);
        try {
            try {
                CompositeTypeModel tm = grammar.getTypeModel();
                HostModel hm = grammar.getStartGraphModel();
                TypeGraph tg = tm.getTypeGraph();
                HostGraph hg = hm != null ? hm.toHost() : null;
                result = new Pair<TypeGraph, HostGraph>(tg, hg);
            }
            catch (FormatException e) {
                throw new ImportException(e);
            }
        }
        finally {
            grammar.setLocalActiveNames(ResourceKind.HOST, localHostNames);
            grammar.setLocalActiveNames(ResourceKind.TYPE, localTypeNames);
        }
        return result;
    }
}

