/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.lang.groove;

import groove.io.conceptual.Id;
import groove.io.conceptual.Name;

public class GrooveUtil {
    private static final String s_invalidRegex = "[^A-Za-z0-9_-]";
    private static final String s_reservedRegex = "[A-Za-z][0-9]*";
    private static final String s_invalidResourceStartRegex = "[^A-Za-z_].*";
    private static final String s_safeString = "_";

    public static Id getSafeId(Id id) {
        if (id == Id.ROOT) {
            return id;
        }
        Id ns = GrooveUtil.getSafeId(id.getNamespace());
        Name name = GrooveUtil.getSafeName(id.getName());
        return Id.getId(ns, name);
    }

    public static Name getSafeName(Name name) {
        String safeString = name.toString().replaceAll(s_invalidRegex, s_safeString);
        return Name.getName(safeString);
    }

    public static String getSafeNodeName(String name) {
        if (name.matches(s_reservedRegex)) {
            name = s_safeString + name;
        }
        name = name.replaceAll(s_invalidRegex, s_safeString);
        return name;
    }

    public static String getSafeId(String idString) {
        String safeString = idString.replaceAll(s_invalidRegex, s_safeString);
        if (safeString.matches(s_reservedRegex)) {
            return s_safeString + safeString;
        }
        return safeString;
    }

    public static String getSafeResource(String resourceString) {
        String[] parts = resourceString.split("\\Q.\\E");
        int i = 0;
        while (i < parts.length) {
            parts[i] = parts[i].replaceAll(s_invalidRegex, s_safeString);
            if (parts[i].matches(s_invalidResourceStartRegex)) {
                parts[i] = s_safeString + parts[i];
            }
            ++i;
        }
        StringBuilder buffer = new StringBuilder(resourceString.length());
        int i2 = 0;
        while (i2 < parts.length) {
            if (i2 > 0) {
                buffer.append(".");
            }
            buffer.append(parts[i2]);
            ++i2;
        }
        return buffer.toString();
    }
}

