/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.lang.groove;

import groove.graph.GraphRole;
import groove.io.conceptual.Acceptor;
import groove.io.conceptual.Field;
import groove.io.conceptual.InstanceModel;
import groove.io.conceptual.Timer;
import groove.io.conceptual.TypeModel;
import groove.io.conceptual.configuration.Config;
import groove.io.conceptual.configuration.schema.EnumModeType;
import groove.io.conceptual.configuration.schema.NullableType;
import groove.io.conceptual.configuration.schema.OrderType;
import groove.io.conceptual.graph.AbsEdge;
import groove.io.conceptual.graph.AbsNode;
import groove.io.conceptual.lang.InstanceExporter;
import groove.io.conceptual.lang.groove.GrammarGraph;
import groove.io.conceptual.lang.groove.GrooveResource;
import groove.io.conceptual.lang.groove.GrooveUtil;
import groove.io.conceptual.property.DefaultValueProperty;
import groove.io.conceptual.property.OppositeProperty;
import groove.io.conceptual.property.Property;
import groove.io.conceptual.type.Class;
import groove.io.conceptual.type.Container;
import groove.io.conceptual.type.Enum;
import groove.io.conceptual.type.Tuple;
import groove.io.conceptual.value.BoolValue;
import groove.io.conceptual.value.ContainerValue;
import groove.io.conceptual.value.CustomDataValue;
import groove.io.conceptual.value.EnumValue;
import groove.io.conceptual.value.IntValue;
import groove.io.conceptual.value.RealValue;
import groove.io.conceptual.value.StringValue;
import groove.io.conceptual.value.TupleValue;
import groove.io.conceptual.value.Value;
import groove.io.ecore2groove.Triple;
import groove.io.external.PortException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class InstanceToGroove
extends InstanceExporter<Object> {
    private GrammarGraph m_currentGraph;
    private GrooveResource m_grooveResource;
    private Config m_cfg;
    private TypeModel m_currentTypeModel;
    private Collection<Property> m_properties;
    private Map<Triple<groove.io.conceptual.value.Object, Field, groove.io.conceptual.value.Object>, AbsNode> m_objectNodes = new HashMap<Triple<groove.io.conceptual.value.Object, Field, groove.io.conceptual.value.Object>, AbsNode>();

    public InstanceToGroove(GrooveResource grooveResource) {
        this.m_grooveResource = grooveResource;
        this.m_cfg = this.m_grooveResource.getConfig();
    }

    @Override
    public void addInstanceModel(InstanceModel instanceModel) throws PortException {
        int timer = Timer.start("IM to GROOVE");
        this.m_properties = instanceModel.getTypeModel().getProperties();
        this.m_currentGraph = this.m_grooveResource.getGraph(instanceModel.getName(), GraphRole.HOST);
        this.m_currentTypeModel = instanceModel.getTypeModel();
        this.visitInstanceModel(instanceModel, this.m_cfg);
        this.m_currentGraph.getGraph().toAspectGraph(this.m_currentGraph.getGraphName(), this.m_currentGraph.getGraphRole());
        Timer.stop(timer);
    }

    @Override
    protected void visitInstanceModel(InstanceModel instanceModel) {
        for (groove.io.conceptual.value.Object o : instanceModel.getObjects()) {
            this.getElement(o);
        }
        this.addOpposites();
    }

    @Override
    private void setElement(Acceptor o, AbsNode n) {
        this.m_currentGraph.m_nodes.put(o, n);
        super.setElement(o, n);
    }

    private void setElements(Acceptor o, AbsNode[] n) {
        this.m_currentGraph.m_multiNodes.put(o, n);
        super.setElement(o, n);
    }

    private AbsNode getNode(Acceptor o) {
        return this.getNode(o, null);
    }

    private AbsNode getNode(Acceptor o, Object param) {
        return (AbsNode)super.getElement(o, param);
    }

    private AbsNode[] getNodes(Acceptor o, Object param) {
        return (AbsNode[])super.getElement(o, param);
    }

    @Override
    public void visit(groove.io.conceptual.value.Object object, Object param) {
        if (this.hasElement(object)) {
            return;
        }
        if (object == groove.io.conceptual.value.Object.NIL) {
            if (this.m_cfg.getConfig().getGlobal().getNullable() != NullableType.NONE) {
                String name = this.m_cfg.getStrings().getNilName();
                AbsNode nilNode = new AbsNode("type:" + name);
                this.setElement((Acceptor)object, nilNode);
            } else {
                this.setElement((Acceptor)object, null);
            }
            return;
        }
        AbsNode objectNode = new AbsNode(this.m_cfg.getName(object.getType()));
        if (this.m_cfg.getConfig().getInstanceModel().getObjects().isUseIdentifier() && object.getName() != null) {
            String name = object.getName();
            if ((name = name.replaceAll("[^A-Za-z0-9_]", "_")).matches("[0-9].*")) {
                name = "_" + name;
            }
            objectNode.addName("id:" + GrooveUtil.getSafeId(name));
        }
        this.setElement((Acceptor)object, objectNode);
        HashSet<Field> defaultFields = new HashSet<Field>();
        if (this.m_cfg.getConfig().getTypeModel().getFields().getDefaults().isSetValue()) {
            for (Property property : this.m_currentTypeModel.getProperties()) {
                if (!(property instanceof DefaultValueProperty)) continue;
                DefaultValueProperty dp = (DefaultValueProperty)property;
                if (!((Class)object.getType()).getAllSuperClasses().contains(dp.getField().getDefiningClass()) || object.getValue().containsKey(dp.getField())) continue;
                object.setFieldValue(dp.getField(), dp.getDefaultValue());
                defaultFields.add(dp.getField());
            }
        }
        for (Map.Entry entry : object.getValue().entrySet()) {
            Field f = (Field)entry.getKey();
            Value v = (Value)entry.getValue();
            assert (v != null);
            if (v == groove.io.conceptual.value.Object.NIL && this.m_cfg.getConfig().getGlobal().getNullable() == NullableType.NONE) continue;
            if (f.getType() instanceof Container) {
                AbsNode[] valNodes = this.getNodes(v, this.m_cfg.getName(f));
                ContainerValue cv = (ContainerValue)v;
                int i = 0;
                AbsNode[] absNodeArray = valNodes;
                int n = valNodes.length;
                int n2 = 0;
                while (n2 < n) {
                    AbsNode valNode = absNodeArray[n2];
                    new AbsEdge(objectNode, valNode, f.getName().toString());
                    if (cv.getValue().get(i) instanceof groove.io.conceptual.value.Object) {
                        this.m_objectNodes.put(new Triple<groove.io.conceptual.value.Object, Field, groove.io.conceptual.value.Object>(object, f, (groove.io.conceptual.value.Object)cv.getValue().get(i)), valNode);
                    }
                    ++i;
                    ++n2;
                }
                continue;
            }
            AbsNode valNode = this.getNode(v);
            if (this.m_cfg.useIntermediate(f)) {
                String valName = this.m_cfg.getStrings().getValueEdge();
                AbsNode interNode = new AbsNode(this.m_cfg.getName(f));
                new AbsEdge(interNode, valNode, valName);
                valNode = interNode;
            }
            if (v instanceof groove.io.conceptual.value.Object) {
                this.m_objectNodes.put(new Triple<groove.io.conceptual.value.Object, Field, groove.io.conceptual.value.Object>(object, f, (groove.io.conceptual.value.Object)v), valNode);
            }
            new AbsEdge(objectNode, valNode, f.getName().toString());
        }
        if (this.m_cfg.getConfig().getTypeModel().getFields().getDefaults().isSetValue()) {
            for (Field field : defaultFields) {
                object.getValue().remove(field);
            }
        }
    }

    private void addOpposites() {
        if (!this.m_cfg.getConfig().getTypeModel().getFields().isOpposites()) {
            return;
        }
        String oppositeName = this.m_cfg.getStrings().getOppositeEdge();
        for (Map.Entry<Triple<groove.io.conceptual.value.Object, Field, groove.io.conceptual.value.Object>, AbsNode> tripleEntry : this.m_objectNodes.entrySet()) {
            Triple<groove.io.conceptual.value.Object, Field, groove.io.conceptual.value.Object> triple = tripleEntry.getKey();
            Field f = triple.getMiddle();
            for (Property p : this.m_properties) {
                Triple<groove.io.conceptual.value.Object, Field, groove.io.conceptual.value.Object> opTriple;
                OppositeProperty op;
                if (!(p instanceof OppositeProperty) || (op = (OppositeProperty)p).getField1() != f || !this.m_objectNodes.containsKey(opTriple = new Triple<groove.io.conceptual.value.Object, Field, groove.io.conceptual.value.Object>(triple.getRight(), op.getField2(), triple.getLeft()))) continue;
                new AbsEdge(tripleEntry.getValue(), this.m_objectNodes.get(opTriple), oppositeName);
            }
        }
    }

    @Override
    public void visit(RealValue realval, Object param) {
        if (this.hasElement(realval)) {
            return;
        }
        AbsNode realNode = new AbsNode("real:" + realval.getValue());
        this.setElement((Acceptor)realval, realNode);
    }

    @Override
    public void visit(StringValue stringval, Object param) {
        if (this.hasElement(stringval)) {
            return;
        }
        AbsNode stringNode = new AbsNode("string:\"" + stringval.toEscapedString() + "\"");
        this.setElement((Acceptor)stringval, stringNode);
    }

    @Override
    public void visit(IntValue intval, Object param) {
        if (this.hasElement(intval)) {
            return;
        }
        AbsNode intNode = new AbsNode("int:" + intval.getValue());
        this.setElement((Acceptor)intval, intNode);
    }

    @Override
    public void visit(BoolValue boolval, Object param) {
        if (this.hasElement(boolval)) {
            return;
        }
        AbsNode boolNode = new AbsNode("bool:" + boolval.getValue());
        this.setElement((Acceptor)boolval, boolNode);
    }

    @Override
    public void visit(EnumValue enumval, Object param) {
        if (this.hasElement(enumval)) {
            return;
        }
        if (this.m_cfg.getConfig().getTypeModel().getEnumMode() == EnumModeType.NODE) {
            String sep = this.m_cfg.getConfig().getGlobal().getIdSeparator();
            String litName = "type:" + this.m_cfg.idToName(((Enum)enumval.getType()).getId()) + sep + enumval.getValue();
            AbsNode enumNode = new AbsNode(litName);
            this.setElement((Acceptor)enumval, enumNode);
        } else {
            AbsNode enumNode = new AbsNode(this.m_cfg.getName(enumval.getType()));
            enumNode.addName("flag:" + enumval.getValue().toString());
            this.setElement((Acceptor)enumval, enumNode);
        }
    }

    @Override
    public void visit(CustomDataValue dataval, Object param) {
        if (this.hasElement(dataval)) {
            return;
        }
        String valueName = this.m_cfg.getStrings().getDataValue();
        AbsNode dataNode = new AbsNode(this.m_cfg.getName(dataval.getType()), "let:" + valueName + "=string:\"" + dataval.getValue() + "\"");
        this.setElement((Acceptor)dataval, dataNode);
    }

    @Override
    public void visit(ContainerValue containerVal, Object param) {
        if (this.hasElement(containerVal)) {
            return;
        }
        if (param == null || !(param instanceof String)) {
            throw new IllegalArgumentException("Container value visitor requires String argument");
        }
        String containerId = (String)param;
        Container containerType = (Container)containerVal.getType();
        boolean useIntermediate = this.m_cfg.useIntermediate(containerType);
        boolean subContainer = containerType.getType() instanceof Container;
        boolean useIndex = this.m_cfg.useIndex(containerType);
        boolean useEdge = this.m_cfg.getConfig().getTypeModel().getFields().getContainers().getOrdering().getType() == OrderType.EDGE;
        AbsNode[] containerNodes = new AbsNode[containerVal.getValue().size()];
        int i = 0;
        int index = 1;
        AbsNode prevValNode = null;
        Iterator iterator = containerVal.getValue().iterator();
        while (iterator.hasNext()) {
            Value subValue = (Value)iterator.next();
            if (subValue == groove.io.conceptual.value.Object.NIL && this.m_cfg.getConfig().getGlobal().getNullable() == NullableType.NONE) continue;
            AbsNode valueNode = null;
            String valName = this.m_cfg.getStrings().getValueEdge();
            if (!useIntermediate) {
                AbsNode subNode;
                valueNode = subNode = this.getNode(subValue);
            } else {
                AbsNode intermediateNode = new AbsNode(String.valueOf(containerId) + this.m_cfg.getContainerPostfix(containerType));
                if (subContainer) {
                    AbsNode[] subNodes;
                    ContainerValue cVal = (ContainerValue)subValue;
                    AbsNode[] absNodeArray = subNodes = this.getNodes(cVal, this.m_cfg.getContainerName(containerId, (Container)cVal.getType()));
                    int n = subNodes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AbsNode subNode = absNodeArray[n2];
                        new AbsEdge(intermediateNode, subNode, valName);
                        ++n2;
                    }
                } else {
                    AbsNode subNode = this.getNode(subValue);
                    new AbsEdge(intermediateNode, subNode, valName);
                }
                valueNode = intermediateNode;
            }
            if (useIndex) {
                if (useEdge) {
                    if (prevValNode != null) {
                        String nextName = this.m_cfg.getStrings().getNextEdge();
                        new AbsEdge(prevValNode, valueNode, nextName);
                        if (this.m_cfg.getConfig().getTypeModel().getFields().getContainers().getOrdering().isUsePrevEdge()) {
                            String prevName = this.m_cfg.getStrings().getPrevEdge();
                            new AbsEdge(valueNode, prevValNode, prevName);
                        }
                    }
                    prevValNode = valueNode;
                } else {
                    String indexName = this.m_cfg.getStrings().getIndexEdge();
                    valueNode.addName("let:" + indexName + "=" + index);
                    ++index;
                }
            }
            containerNodes[i] = valueNode;
            ++i;
        }
        this.setElements(containerVal, containerNodes);
    }

    @Override
    public void visit(TupleValue tupleval, Object param) {
        if (this.hasElement(tupleval)) {
            return;
        }
        Tuple tup = (Tuple)tupleval.getType();
        AbsNode tupleNode = new AbsNode(this.m_cfg.getName(tup));
        this.setElement((Acceptor)tupleval, tupleNode);
        for (Integer i : tupleval.getValue().keySet()) {
            Value v = (Value)tupleval.getValue().get(i);
            AbsNode valNode = this.getNode(v);
            if (valNode == null) continue;
            new AbsEdge(tupleNode, valNode, "_" + i);
        }
    }
}

