/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.lang.groove;

import groove.graph.GraphRole;
import groove.io.conceptual.Acceptor;
import groove.io.conceptual.Field;
import groove.io.conceptual.Name;
import groove.io.conceptual.Timer;
import groove.io.conceptual.TypeModel;
import groove.io.conceptual.configuration.Config;
import groove.io.conceptual.configuration.schema.EnumModeType;
import groove.io.conceptual.configuration.schema.NullableType;
import groove.io.conceptual.configuration.schema.OrderType;
import groove.io.conceptual.graph.AbsEdge;
import groove.io.conceptual.graph.AbsNode;
import groove.io.conceptual.lang.ExportableResource;
import groove.io.conceptual.lang.TypeExporter;
import groove.io.conceptual.lang.groove.GrammarGraph;
import groove.io.conceptual.lang.groove.GrooveResource;
import groove.io.conceptual.lang.groove.GrooveUtil;
import groove.io.conceptual.property.AbstractProperty;
import groove.io.conceptual.property.ContainmentProperty;
import groove.io.conceptual.property.DefaultValueProperty;
import groove.io.conceptual.property.IdentityProperty;
import groove.io.conceptual.property.KeysetProperty;
import groove.io.conceptual.property.OppositeProperty;
import groove.io.conceptual.property.Property;
import groove.io.conceptual.type.Class;
import groove.io.conceptual.type.Container;
import groove.io.conceptual.type.CustomDataType;
import groove.io.conceptual.type.DataType;
import groove.io.conceptual.type.Enum;
import groove.io.conceptual.type.Tuple;
import groove.io.conceptual.type.Type;
import groove.io.external.PortException;
import java.util.HashSet;
import java.util.Set;

public class TypeToGroove
extends TypeExporter<AbsNode> {
    private GrooveResource m_grooveResource;
    private Config m_cfg;
    private GrammarGraph m_currentGraph;
    private Set<Property> m_properties = new HashSet<Property>();

    public TypeToGroove(GrooveResource grooveResource) {
        this.m_grooveResource = grooveResource;
        this.m_cfg = this.m_grooveResource.getConfig();
    }

    @Override
    public void addTypeModel(TypeModel typeModel) throws PortException {
        int timer = Timer.start("TM to GROOVE");
        this.m_currentGraph = this.m_grooveResource.getGraph(GrooveUtil.getSafeId(typeModel.getName()), GraphRole.TYPE);
        this.m_properties.clear();
        this.visitTypeModel(typeModel, this.m_cfg);
        this.m_currentGraph.getGraph().toAspectGraph(this.m_currentGraph.getGraphName(), this.m_currentGraph.getGraphRole());
        Timer.stop(timer);
    }

    @Override
    public ExportableResource getResource() {
        return this.m_grooveResource;
    }

    @Override
    protected void setElement(Acceptor o, AbsNode n) {
        super.setElement(o, n);
        this.m_currentGraph.m_nodes.put(o, n);
    }

    private void setPropertyVisited(Property o) {
        this.m_properties.add(o);
    }

    private boolean propertyVisited(Property o) {
        return this.m_properties.contains(o);
    }

    @Override
    public void visit(Class c, Object param) {
        if (this.hasElement(c)) {
            return;
        }
        if (this.m_cfg.getConfig().getGlobal().getNullable() == NullableType.NONE && !c.isProper()) {
            AbsNode classNode = (AbsNode)this.getElement(c.getProperClass());
            if (!this.hasElement(c)) {
                this.setElement((Acceptor)c, classNode);
            }
            return;
        }
        AbsNode classNode = new AbsNode(this.m_cfg.getName(c));
        this.setElement((Acceptor)c, classNode);
        if (!c.isProper()) {
            classNode.addName("abs:");
            AbsNode nilNode = (AbsNode)this.getElement(groove.io.conceptual.value.Object.NIL);
            new AbsEdge(nilNode, classNode, "sub:");
            AbsNode properNode = (AbsNode)this.getElement(c.getProperClass());
            new AbsEdge(properNode, classNode, "sub:");
            return;
        }
        for (Class clazz : c.getSuperClasses()) {
            AbsNode superClassNode = (AbsNode)this.getElement(clazz.getProperClass());
            new AbsEdge(classNode, superClassNode, "sub:");
        }
        for (Field f : c.getFields()) {
            AbsNode fieldNode = (AbsNode)this.getElement(f);
            String edgeLabel = "";
            int lowerBound = f.getLowerBound();
            if (lowerBound == 0 && f.getUpperBound() == 1 && f.getType() instanceof Class && this.m_cfg.getConfig().getGlobal().getNullable() != NullableType.NONE) {
                lowerBound = 1;
            }
            if (this.m_cfg.useIntermediate(f) && f.getType() instanceof Container && this.m_cfg.useIntermediate((Container)f.getType())) {
                edgeLabel = String.valueOf(edgeLabel) + "in=1:";
            }
            if (f.getUpperBound() != -1 || lowerBound != 0) {
                edgeLabel = String.valueOf(edgeLabel) + "out=";
                edgeLabel = lowerBound != f.getUpperBound() ? String.valueOf(edgeLabel) + lowerBound + ".." + (f.getUpperBound() == -1 ? "*" : Integer.valueOf(f.getUpperBound())) : String.valueOf(edgeLabel) + lowerBound;
                edgeLabel = String.valueOf(edgeLabel) + ":";
            }
            new AbsEdge(classNode, fieldNode, String.valueOf(edgeLabel) + f.getName().toString());
        }
        if (this.m_cfg.getConfig().getGlobal().getNullable() == NullableType.ALL) {
            this.getElement(c.getNullableClass());
        }
    }

    @Override
    public void visit(Field field, Object param) {
        if (this.hasElement(field)) {
            return;
        }
        AbsNode fieldNode = null;
        if (field.getType() instanceof Container) {
            fieldNode = (AbsNode)this.getElement(field.getType(), this.m_cfg.getName(field));
        } else {
            boolean isNullable = false;
            if (this.m_cfg.useIntermediate(field) && field.getType() instanceof Class) {
                isNullable = !((Class)field.getType()).isProper();
                fieldNode = (AbsNode)this.getElement(((Class)field.getType()).getProperClass());
            } else {
                fieldNode = (AbsNode)this.getElement(field.getType());
            }
            if (this.m_cfg.useIntermediate(field)) {
                String valName = this.m_cfg.getStrings().getValueEdge();
                AbsNode interNode = new AbsNode(this.m_cfg.getName(field));
                interNode.addName("edge:\"" + field.getName() + "\"");
                String out = isNullable ? "out=0..1:" : "out=1:";
                new AbsEdge(interNode, fieldNode, String.valueOf(out) + valName);
                fieldNode = interNode;
            }
        }
        this.setElement((Acceptor)field, fieldNode);
    }

    @Override
    public void visit(DataType dt, Object param) {
        if (this.hasElement(dt)) {
            return;
        }
        if (dt instanceof CustomDataType) {
            String valueName = this.m_cfg.getStrings().getDataValue();
            AbsNode dataNode = new AbsNode(this.m_cfg.getName(dt), "string:" + valueName);
            this.setElement((Acceptor)dt, dataNode);
        } else {
            AbsNode typeNode = new AbsNode(this.m_cfg.getName(dt));
            this.setElement((Acceptor)dt, typeNode);
        }
    }

    @Override
    public void visit(Enum e, Object param) {
        if (this.hasElement(e)) {
            return;
        }
        if (this.m_cfg.getConfig().getTypeModel().getEnumMode() == EnumModeType.NODE) {
            String sep = this.m_cfg.getConfig().getGlobal().getIdSeparator();
            AbsNode enumNode = new AbsNode(this.m_cfg.getName(e), "abs:");
            this.setElement((Acceptor)e, enumNode);
            for (Name n : e.getLiterals()) {
                String litName = "type:" + this.m_cfg.idToName(e.getId()) + sep + n.toString();
                AbsNode valNode = new AbsNode(litName);
                new AbsEdge(valNode, enumNode, "sub:");
            }
        } else {
            AbsNode enumNode = new AbsNode(this.m_cfg.getName(e));
            this.setElement((Acceptor)e, enumNode);
            for (Name n : e.getLiterals()) {
                enumNode.addName("flag:" + n.toString());
            }
        }
    }

    @Override
    public void visit(Container c, Object param) {
        if (this.hasElement(c)) {
            return;
        }
        if (param == null || !(param instanceof String)) {
            throw new IllegalArgumentException("Container visitor requires String argument");
        }
        String containerId = (String)param;
        AbsNode typeNode = null;
        typeNode = !(c.getType() instanceof Container) ? (AbsNode)this.getElement(c.getType()) : (AbsNode)this.getElement(c.getType(), this.m_cfg.getContainerName(containerId, c));
        boolean useIndex = this.m_cfg.useIndex(c);
        boolean indexValue = this.m_cfg.getConfig().getTypeModel().getFields().getContainers().getOrdering().getType() == OrderType.INDEX;
        AbsNode containerNode = null;
        if (this.m_cfg.useIntermediate(c)) {
            containerNode = new AbsNode(String.valueOf(containerId) + this.m_cfg.getContainerPostfix(c));
            int lastIndex = containerId.lastIndexOf(this.m_cfg.getConfig().getGlobal().getIdSeparator());
            String edgeName = containerId;
            if (lastIndex != -1) {
                edgeName = containerId.substring(lastIndex + 1);
            }
            if (useIndex && indexValue) {
                String indexName = this.m_cfg.getStrings().getIndexEdge();
                containerNode.addName("edge:\"" + edgeName + " %s\"," + indexName);
            } else {
                containerNode.addName("edge:\"" + edgeName + "\"");
            }
            String valName = this.m_cfg.getStrings().getValueEdge();
            valName = c.getType() instanceof Container ? "out=1..*:" + valName : "out=1:" + valName;
            new AbsEdge(containerNode, typeNode, valName);
        } else {
            containerNode = typeNode;
        }
        if (useIndex) {
            if (indexValue) {
                String indexName = this.m_cfg.getStrings().getIndexEdge();
                containerNode.addName("out=1:int:" + indexName);
            } else {
                String nextName = this.m_cfg.getStrings().getNextEdge();
                new AbsEdge(containerNode, containerNode, "out=0..1:" + nextName);
                if (this.m_cfg.getConfig().getTypeModel().getFields().getContainers().getOrdering().isUsePrevEdge()) {
                    String prevName = this.m_cfg.getStrings().getPrevEdge();
                    new AbsEdge(containerNode, containerNode, "out=0..1:" + prevName);
                }
            }
        }
        this.setElement((Acceptor)c, containerNode);
    }

    @Override
    public void visit(Tuple tuple, Object param) {
        if (this.hasElement(tuple)) {
            return;
        }
        AbsNode tupleNode = new AbsNode(this.m_cfg.getName(tuple));
        this.setElement((Acceptor)tuple, tupleNode);
        int index = 1;
        for (Type t : tuple.getTypes()) {
            AbsNode typeNode = (AbsNode)this.getElement(t);
            new AbsEdge(tupleNode, typeNode, "_" + index++);
        }
    }

    @Override
    public void visit(groove.io.conceptual.value.Object object, Object param) {
        if (this.hasElement(object)) {
            return;
        }
        if (object != groove.io.conceptual.value.Object.NIL) {
            throw new IllegalArgumentException("Cannot create object node in type model");
        }
        String name = this.m_cfg.getStrings().getNilName();
        AbsNode nilNode = new AbsNode("type:" + name);
        this.setElement((Acceptor)object, nilNode);
    }

    @Override
    public void visit(AbstractProperty abstractProperty, Object param) {
        if (this.propertyVisited(abstractProperty)) {
            return;
        }
        this.setPropertyVisited(abstractProperty);
        if (!this.m_cfg.getConfig().getTypeModel().getProperties().isUseAbstract()) {
            return;
        }
        AbsNode classNode = (AbsNode)this.getElement(abstractProperty.getAbstractClass().getProperClass());
        classNode.addName("abs:");
    }

    @Override
    public void visit(ContainmentProperty containmentProperty, Object param) {
        if (this.propertyVisited(containmentProperty)) {
            return;
        }
        this.setPropertyVisited(containmentProperty);
        if (!this.m_cfg.getConfig().getTypeModel().getProperties().isUseContainment()) {
            return;
        }
        String edgeName = containmentProperty.getField().getName().toString();
        AbsNode containmentNode = (AbsNode)this.getElement(containmentProperty.getContainerClass());
        for (AbsEdge edge : containmentNode.getEdges()) {
            if (!edge.getName().endsWith(edgeName)) continue;
            edge.setName("part:" + edge.getName());
        }
        if (this.m_cfg.useIntermediate(containmentProperty.getField())) {
            edgeName = this.m_cfg.getStrings().getValueEdge();
            containmentNode = (AbsNode)this.getElement(containmentProperty.getField());
            for (AbsEdge edge : containmentNode.getEdges()) {
                if (!edge.getName().endsWith(edgeName)) continue;
                edge.setName("part:" + edge.getName());
            }
        }
    }

    @Override
    public void visit(IdentityProperty identityProperty, Object param) {
        if (this.propertyVisited(identityProperty)) {
            return;
        }
        this.setPropertyVisited(identityProperty);
    }

    @Override
    public void visit(KeysetProperty keysetProperty, Object param) {
        if (this.propertyVisited(keysetProperty)) {
            return;
        }
        this.setPropertyVisited(keysetProperty);
    }

    @Override
    public void visit(OppositeProperty oppositeProperty, Object param) {
        if (this.propertyVisited(oppositeProperty)) {
            return;
        }
        this.setPropertyVisited(oppositeProperty);
        if (!this.m_cfg.getConfig().getTypeModel().getProperties().isUseOpposite()) {
            return;
        }
        boolean useOpposites = this.m_cfg.getConfig().getTypeModel().getFields().isOpposites();
        if (!useOpposites) {
            return;
        }
        AbsNode class1Node = (AbsNode)this.getElement(oppositeProperty.getClass1());
        AbsNode class2Node = (AbsNode)this.getElement(oppositeProperty.getClass2());
        AbsNode field1Node = (AbsNode)this.getElement(oppositeProperty.getField1());
        AbsNode field2Node = (AbsNode)this.getElement(oppositeProperty.getField2());
        AbsNode source = this.m_cfg.useIntermediate(oppositeProperty.getField1()) ? field1Node : class1Node;
        AbsNode target = this.m_cfg.useIntermediate(oppositeProperty.getField2()) ? field2Node : class2Node;
        String oppositeName = this.m_cfg.getStrings().getOppositeEdge();
        new AbsEdge(source, target, "out=1:" + oppositeName);
    }

    @Override
    public void visit(DefaultValueProperty defaultValueProperty, Object param) {
        if (this.propertyVisited(defaultValueProperty)) {
            return;
        }
        this.setPropertyVisited(defaultValueProperty);
    }
}

