/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.lang.gxl;

import de.gupro.gxl.gxl_1_0.EdgeType;
import de.gupro.gxl.gxl_1_0.GraphElementType;
import de.gupro.gxl.gxl_1_0.GraphType;
import de.gupro.gxl.gxl_1_0.GxlType;
import de.gupro.gxl.gxl_1_0.NodeType;
import de.gupro.gxl.gxl_1_0.TupType;
import de.gupro.gxl.gxl_1_0.TypedElementType;
import groove.io.conceptual.Field;
import groove.io.conceptual.Id;
import groove.io.conceptual.Name;
import groove.io.conceptual.Timer;
import groove.io.conceptual.TypeModel;
import groove.io.conceptual.lang.ImportException;
import groove.io.conceptual.lang.Message;
import groove.io.conceptual.lang.TypeImporter;
import groove.io.conceptual.lang.gxl.GxlUtil;
import groove.io.conceptual.property.AbstractProperty;
import groove.io.conceptual.property.ContainmentProperty;
import groove.io.conceptual.property.DefaultValueProperty;
import groove.io.conceptual.type.BoolType;
import groove.io.conceptual.type.Class;
import groove.io.conceptual.type.Container;
import groove.io.conceptual.type.Enum;
import groove.io.conceptual.type.IntType;
import groove.io.conceptual.type.RealType;
import groove.io.conceptual.type.StringType;
import groove.io.conceptual.type.Tuple;
import groove.io.conceptual.type.Type;
import groove.io.conceptual.value.ContainerValue;
import groove.io.conceptual.value.EnumValue;
import groove.io.conceptual.value.IntValue;
import groove.io.conceptual.value.RealValue;
import groove.io.conceptual.value.StringValue;
import groove.io.conceptual.value.TupleValue;
import groove.io.conceptual.value.Value;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;

public class GxlToType
extends TypeImporter {
    private List<GraphType> m_gxlTypeGraphs = new ArrayList<GraphType>();
    private Map<NodeType, Object> m_nodeValues = new HashMap<NodeType, Object>();
    private Map<String, Type> m_idToType = new HashMap<String, Type>();
    private Map<String, Field> m_idToField = new HashMap<String, Field>();
    private Set<String> m_complexEdgeIds = new HashSet<String>();
    private Map<String, Id> m_graphNamespaces = new HashMap<String, Id>();
    private boolean m_useComplex;
    private static final Map<String, Type> g_simpleTypeMap = new HashMap<String, Type>();
    private static final Set<String> g_complexTypeSet;
    private static final Set<String> g_edgeTypes;

    static {
        g_simpleTypeMap.put("Locator", StringType.instance());
        g_simpleTypeMap.put("Bool", BoolType.instance());
        g_simpleTypeMap.put("Float", RealType.instance());
        g_simpleTypeMap.put("Int", IntType.instance());
        g_simpleTypeMap.put("String", StringType.instance());
        g_complexTypeSet = new HashSet<String>();
        g_complexTypeSet.add("Bag");
        g_complexTypeSet.add("Set");
        g_complexTypeSet.add("Seq");
        g_complexTypeSet.add("Tup");
        g_edgeTypes = new HashSet<String>();
        g_edgeTypes.add("EdgeClass");
        g_edgeTypes.add("AggregationClass");
        g_edgeTypes.add("CompositionClass");
    }

    public GxlToType(String typeModel, boolean useComplex) throws ImportException {
        this.m_useComplex = useComplex;
        try {
            FileInputStream in = new FileInputStream(typeModel);
            try {
                int timer = Timer.start("Load GXL");
                JAXBElement doc = (JAXBElement)GxlUtil.g_unmarshaller.unmarshal((InputStream)in);
                in.close();
                for (GraphType g : ((GxlType)doc.getValue()).getGraph()) {
                    String type = GxlUtil.getElemType((TypedElementType)g);
                    if (!"gxl-1.0".equals(type)) continue;
                    this.m_gxlTypeGraphs.add(g);
                    break;
                }
                Timer.stop(timer);
            }
            finally {
                in.close();
            }
        }
        catch (JAXBException e) {
            throw new ImportException(e);
        }
        catch (FileNotFoundException e) {
            throw new ImportException(e);
        }
        catch (IOException e) {
            throw new ImportException(e);
        }
        int timer = Timer.start("GXL to TM");
        this.buildTypeModels();
        Timer.stop(timer);
    }

    private void buildTypeModels() {
        for (GraphType graph : this.m_gxlTypeGraphs) {
            Map<NodeType, GxlUtil.NodeWrapper> nodes = GxlUtil.wrapGraph(graph);
            TypeModel typeModel = new TypeModel(graph.getId());
            HashMap graphElements = new HashMap();
            for (GraphElementType elem : graph.getNodeOrEdgeOrRel()) {
                if (!(elem instanceof NodeType) || !"GraphClass".equals(GxlUtil.getElemType((TypedElementType)elem))) continue;
                graphElements.put((NodeType)elem, new HashSet());
                for (GxlUtil.EdgeWrapper ew : nodes.get(elem).getEdges()) {
                    if (!ew.getType().equals("contains")) continue;
                    ((Set)graphElements.get(elem)).add(ew.getTarget());
                }
            }
            HashMap<NodeType, NodeType> graphHierachy = new HashMap<NodeType, NodeType>();
            for (NodeType graphNode : graphElements.keySet()) {
                Iterator nwIt = ((Set)graphElements.get(graphNode)).iterator();
                while (nwIt.hasNext()) {
                    GxlUtil.NodeWrapper nw = (GxlUtil.NodeWrapper)nwIt.next();
                    String type = GxlUtil.getElemType((TypedElementType)nw.getNode());
                    if (type == null || !type.equals("NodeClass")) continue;
                    for (GxlUtil.EdgeWrapper ew : nw.getEdges()) {
                        if (!ew.getType().equals("hasAsComponentGraph")) continue;
                        if (graphHierachy.containsKey(ew.getTarget().getNode())) {
                            this.addMessage(new Message("Graph may only be contained by one other graph"));
                        }
                        graphHierachy.put(ew.getTarget().getNode(), nw.getNode());
                        nwIt.remove();
                    }
                }
            }
            for (NodeType graphClassNode : graphElements.keySet()) {
                this.getGraphId(graphClassNode, graphHierachy, this.m_graphNamespaces);
            }
            for (NodeType graphNode : graphElements.keySet()) {
                Id graphNamespace = this.m_graphNamespaces.get(graphNode.getId());
                for (GxlUtil.NodeWrapper nw : (Set)graphElements.get(graphNode)) {
                    String type = GxlUtil.getElemType((TypedElementType)nw.getNode());
                    if (type == null) continue;
                    if (type.equals("NodeClass")) {
                        this.visitClass(typeModel, nw, graphNamespace);
                        continue;
                    }
                    if (!g_edgeTypes.contains(type)) continue;
                    this.visitEdge(typeModel, nw, graphNamespace);
                }
                typeModel.resolve();
                this.m_typeModels.put(graphNode.getId(), typeModel);
            }
        }
    }

    private void getGraphId(NodeType graphClassNode, Map<NodeType, NodeType> graphHierachy, Map<String, Id> graphNamespaces) {
        if (graphHierachy.containsKey(graphClassNode)) {
            this.getGraphId(graphHierachy.get(graphClassNode), graphHierachy, graphNamespaces);
            Id parentId = graphNamespaces.get(graphHierachy.get(graphClassNode).getId());
            String graphName = (String)GxlUtil.getAttribute((TypedElementType)graphClassNode, "name", GxlUtil.AttrTypeEnum.STRING);
            graphNamespaces.put(graphClassNode.getId(), Id.getId(parentId, Name.getName(graphName)));
        } else {
            String graphName = (String)GxlUtil.getAttribute((TypedElementType)graphClassNode, "name", GxlUtil.AttrTypeEnum.STRING);
            graphNamespaces.put(graphClassNode.getId(), Id.getId(Id.ROOT, Name.getName(graphName)));
        }
    }

    @Override
    public TypeModel getTypeModel(String model) {
        if (this.m_typeModels.containsKey(model)) {
            return (TypeModel)this.m_typeModels.get(model);
        }
        return null;
    }

    private Class visitClass(TypeModel mm, GxlUtil.NodeWrapper nodeWrapper, Id graphNamespace) {
        if (g_edgeTypes.contains(nodeWrapper.getType())) {
            return (Class)this.visitEdge(mm, nodeWrapper, graphNamespace);
        }
        NodeType node = nodeWrapper.getNode();
        if (this.m_nodeValues.containsKey(node)) {
            Object val = this.m_nodeValues.get(node);
            assert (val instanceof Class);
            return (Class)val;
        }
        String name = (String)GxlUtil.getAttribute((TypedElementType)node, "name", GxlUtil.AttrTypeEnum.STRING);
        if (name == null) {
            this.addMessage(new Message("Class without name " + node.getId()));
            name = node.getId();
        }
        Name clsName = Name.getName(name);
        Id clsID = Id.getId(graphNamespace, clsName);
        Class cmClass = mm.getClass(clsID, true);
        this.m_nodeValues.put(node, cmClass);
        this.m_idToType.put(node.getId(), cmClass);
        for (GxlUtil.EdgeWrapper edge : nodeWrapper.getEdges()) {
            if (edge.getType().equals("hasAttribute")) {
                Field cmField = this.visitAttribute(mm, cmClass, edge.getTarget(), graphNamespace);
                cmClass.addField(cmField);
                continue;
            }
            if (!edge.getType().equals("isA")) continue;
            Class superClass = this.visitClass(mm, edge.getTarget(), graphNamespace);
            cmClass.addSuperClass(superClass);
        }
        Boolean isAbstract = (Boolean)GxlUtil.getAttribute((TypedElementType)node, "isabstract", GxlUtil.AttrTypeEnum.BOOL);
        if (isAbstract != null && isAbstract.booleanValue()) {
            mm.addProperty(new AbstractProperty(cmClass));
        }
        return cmClass;
    }

    private Field visitAttribute(TypeModel tm, Class c, GxlUtil.NodeWrapper nodeWrapper, Id graphNamespace) {
        assert ("AttributeClass".equals(nodeWrapper.getType()));
        NodeType node = nodeWrapper.getNode();
        if (this.m_nodeValues.containsKey(node)) {
            Object val = this.m_nodeValues.get(node);
            assert (val instanceof Field);
            return (Field)val;
        }
        String name = (String)GxlUtil.getAttribute((TypedElementType)nodeWrapper.getNode(), "name", GxlUtil.AttrTypeEnum.STRING);
        Type t = null;
        for (GxlUtil.EdgeWrapper ew : nodeWrapper.getEdges()) {
            if (!ew.getType().equals("hasDomain")) continue;
            t = this.visitType(tm, ew.getTarget(), graphNamespace);
        }
        assert (t != null);
        int lowerBound = 1;
        int upperBound = 1;
        if (t instanceof Container) {
            lowerBound = 0;
            upperBound = -1;
        }
        Field f = new Field(Name.getName(name), t, lowerBound, upperBound);
        this.m_idToField.put(node.getId(), f);
        this.m_nodeValues.put(node, f);
        this.m_idToType.put(node.getId(), t);
        for (GxlUtil.EdgeWrapper ew : nodeWrapper.getEdges()) {
            if (!ew.getType().equals("hasDefaultValue")) continue;
            Value v = this.visitValue(tm, ew.getTarget(), t, graphNamespace);
            DefaultValueProperty p = new DefaultValueProperty(c, f.getName(), v);
            tm.addProperty(p);
        }
        return f;
    }

    private Object visitEdge(TypeModel tm, GxlUtil.NodeWrapper nodeWrapper, Id graphNamespace) {
        NodeType node = nodeWrapper.getNode();
        if (this.m_nodeValues.containsKey(node)) {
            Object val = this.m_nodeValues.get(node);
            return val;
        }
        String name = (String)GxlUtil.getAttribute((TypedElementType)nodeWrapper.getNode(), "name", GxlUtil.AttrTypeEnum.STRING);
        Class sourceClass = null;
        Class targetClass = null;
        Limits fromLimits = new Limits();
        Limits toLimits = new Limits();
        boolean fromOrdered = false;
        boolean toOrdered = false;
        boolean isComplex = false;
        for (GxlUtil.EdgeWrapper ew : nodeWrapper.getEdges()) {
            if (ew.getType().equals("from")) {
                sourceClass = this.visitClass(tm, ew.getTarget(), graphNamespace);
                fromLimits = this.getLimits(ew.getEdge());
                if (!fromLimits.isDefault()) {
                    isComplex = true;
                }
                fromOrdered = (Boolean)GxlUtil.getAttribute((TypedElementType)ew.getEdge(), "isordered", GxlUtil.AttrTypeEnum.BOOL);
                continue;
            }
            if (!ew.getType().equals("to")) continue;
            targetClass = this.visitClass(tm, ew.getTarget(), graphNamespace);
            toLimits = this.getLimits(ew.getEdge());
            toOrdered = (Boolean)GxlUtil.getAttribute((TypedElementType)ew.getEdge(), "isordered", GxlUtil.AttrTypeEnum.BOOL);
        }
        for (GxlUtil.EdgeWrapper ew : nodeWrapper.getIncomingEdges()) {
            if (!ew.getType().equals("isA") && !ew.getType().equals("to") && !ew.getType().equals("from")) continue;
            isComplex = true;
            break;
        }
        assert (sourceClass != null && targetClass != null);
        ArrayList<Class> superClasses = new ArrayList<Class>();
        Boolean isAbstract = (Boolean)GxlUtil.getAttribute((TypedElementType)nodeWrapper.getNode(), "isabstract", GxlUtil.AttrTypeEnum.BOOL);
        boolean hasAttributes = false;
        for (GxlUtil.EdgeWrapper ew : nodeWrapper.getEdges()) {
            if (ew.getType().equals("isA")) {
                if (!this.m_useComplex) continue;
                superClasses.add(this.visitClass(tm, ew.getTarget(), graphNamespace));
                continue;
            }
            if (!ew.getType().equals("hasAttribute")) continue;
            hasAttributes = true;
        }
        boolean isAggregate = false;
        boolean reverseAggregate = false;
        if (!nodeWrapper.getType().equals("EdgeClass")) {
            isAggregate = true;
            String eVal = (String)GxlUtil.getAttribute((TypedElementType)nodeWrapper.getNode(), "aggregate", GxlUtil.AttrTypeEnum.ENUM);
            if (eVal != null && eVal.equals("to")) {
                reverseAggregate = true;
            }
        }
        boolean bl = isComplex = isComplex || isAbstract != null && isAbstract != false || hasAttributes || reverseAggregate || superClasses.size() != 0;
        if (this.m_useComplex && isComplex) {
            String edgeName = sourceClass.getId().getName() + "_" + name;
            Class edgeClass = tm.getClass(Id.getId(graphNamespace, Name.getName(edgeName)), true);
            Type fromType = sourceClass;
            Type toType = targetClass;
            if (fromLimits.upper > 1 || toLimits.upper == -1) {
                fromType = fromOrdered ? new Container(Container.Kind.ORD, fromType) : new Container(Container.Kind.SET, fromType);
            }
            if (toLimits.upper > 1 || toLimits.upper == -1) {
                toType = toOrdered ? new Container(Container.Kind.ORD, toType) : new Container(Container.Kind.SET, toType);
            }
            Field fromField = new Field(Name.getName("from"), fromType, 1, 1);
            Field toField = new Field(Name.getName("to"), toType, 1, 1);
            edgeClass.addField(fromField);
            edgeClass.addField(toField);
            if (isAbstract != null && isAbstract.booleanValue()) {
                tm.addProperty(new AbstractProperty(edgeClass));
            }
            for (Class superClass : superClasses) {
                edgeClass.addSuperClass(superClass);
            }
            if (hasAttributes) {
                for (GxlUtil.EdgeWrapper ew : nodeWrapper.getEdges()) {
                    if (!ew.getType().equals("hasAttribute")) continue;
                    Field attribField = this.visitAttribute(tm, edgeClass, ew.getTarget(), graphNamespace);
                    edgeClass.addField(attribField);
                }
            }
            if (isAggregate) {
                tm.addProperty(new ContainmentProperty(edgeClass, Name.getName(reverseAggregate ? "from" : "to")));
            }
            this.m_nodeValues.put(node, edgeClass);
            this.m_idToType.put(node.getId(), edgeClass);
            this.m_complexEdgeIds.add(node.getId());
            return edgeClass;
        }
        if (isAggregate) {
            tm.addProperty(new ContainmentProperty(sourceClass, Name.getName(name)));
        }
        Type targetType = targetClass;
        if ((toLimits.upper > 1 || toLimits.upper == -1) && toOrdered) {
            targetType = new Container(Container.Kind.ORD, targetType);
        }
        Field f = new Field(Name.getName(name), targetType, toLimits.lower, toLimits.upper);
        this.m_nodeValues.put(node, f);
        this.m_idToField.put(node.getId(), f);
        sourceClass.addField(f);
        return f;
    }

    private Type visitType(TypeModel tm, GxlUtil.NodeWrapper nodeWrapper, Id graphNamespace) {
        NodeType node = nodeWrapper.getNode();
        if (this.m_nodeValues.containsKey(node)) {
            Object val = this.m_nodeValues.get(node);
            assert (val instanceof Type);
            return (Type)val;
        }
        String type = nodeWrapper.getType();
        if (g_simpleTypeMap.containsKey(type)) {
            this.m_nodeValues.put(node, g_simpleTypeMap.get(type));
            this.m_idToType.put(node.getId(), g_simpleTypeMap.get(type));
            return g_simpleTypeMap.get(type);
        }
        if (g_complexTypeSet.contains(type)) {
            ArrayList<Type> components = new ArrayList<Type>();
            nodeWrapper.sortEdges();
            for (GxlUtil.EdgeWrapper edge : nodeWrapper.getEdges()) {
                if (!edge.getType().equals("hasComponent")) continue;
                components.add(this.visitType(tm, edge.getTarget(), graphNamespace));
            }
            Type t = null;
            assert (components.size() > 0);
            if (type.equals("Tup")) {
                t = new Tuple(components.toArray(new Type[components.size()]));
            } else {
                assert (components.size() == 1);
                if (type.equals("Set")) {
                    t = new Container(Container.Kind.SET, (Type)components.get(0));
                } else if (type.equals("Bag")) {
                    t = new Container(Container.Kind.BAG, (Type)components.get(0));
                } else if (type.equals("Seq")) {
                    t = new Container(Container.Kind.SEQ, (Type)components.get(0));
                }
            }
            this.m_nodeValues.put(node, t);
            this.m_idToType.put(node.getId(), t);
            return t;
        }
        if ("Enum".equals(type)) {
            Enum e = this.visitEnum(tm, nodeWrapper, graphNamespace);
            return e;
        }
        assert (false);
        return null;
    }

    private Enum visitEnum(TypeModel tm, GxlUtil.NodeWrapper nodeWrapper, Id graphNamespace) {
        NodeType node = nodeWrapper.getNode();
        if (this.m_nodeValues.containsKey(node)) {
            Object val = this.m_nodeValues.get(node);
            assert (val instanceof Enum);
            return (Enum)val;
        }
        String name = nodeWrapper.getNode().getId();
        Id enumId = Id.getId(graphNamespace, Name.getName(name));
        ArrayList<Name> values = new ArrayList<Name>();
        for (GxlUtil.EdgeWrapper ew : nodeWrapper.getEdges()) {
            if (!ew.getType().equals("containsValue")) continue;
            GxlUtil.NodeWrapper valueNode = ew.getTarget();
            assert ("EnumVal".equals(valueNode.getType()));
            String value = (String)GxlUtil.getAttribute((TypedElementType)valueNode.getNode(), "value", GxlUtil.AttrTypeEnum.STRING);
            values.add(Name.getName(value));
        }
        Enum cmEnum = tm.getEnum(enumId, true);
        for (Name litName : values) {
            cmEnum.addLiteral(litName);
        }
        this.m_nodeValues.put(node, cmEnum);
        this.m_idToType.put(node.getId(), cmEnum);
        return cmEnum;
    }

    private Value visitValue(TypeModel tm, GxlUtil.NodeWrapper nodeWrapper, Type type, Id graphNamespace) {
        String nodeType = nodeWrapper.getType();
        NodeType valueNode = nodeWrapper.getNode();
        if (nodeType.equals("LocatorVal")) {
            String value = (String)GxlUtil.getAttribute((TypedElementType)valueNode, "uri", GxlUtil.AttrTypeEnum.STRING);
            if (type instanceof StringType) {
                return new StringValue(value);
            }
            this.addMessage(new Message("Trying to parse locator value " + value + " while expected type is " + type, Message.MessageType.ERROR));
            return null;
        }
        if (type.equals("BoolVal")) {
            String valueString = (String)GxlUtil.getAttribute((TypedElementType)valueNode, "value", GxlUtil.AttrTypeEnum.STRING);
            if (type instanceof BoolType) {
                return BoolType.instance().valueFromString(valueString);
            }
            this.addMessage(new Message("Trying to parse bool value " + valueString + " while expected type is " + type, Message.MessageType.ERROR));
            return null;
        }
        if (nodeType.equals("FloatVal")) {
            String value = (String)GxlUtil.getAttribute((TypedElementType)valueNode, "value", GxlUtil.AttrTypeEnum.STRING);
            try {
                if (type instanceof RealType) {
                    return new RealValue(Float.parseFloat(value));
                }
                this.addMessage(new Message("Trying to parse real value " + value + " while expected type is " + type, Message.MessageType.ERROR));
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                this.addMessage(new Message("Unable to parse value " + value + " as float", Message.MessageType.ERROR));
                return null;
            }
        }
        if (nodeType.equals("IntVal")) {
            String value = (String)GxlUtil.getAttribute((TypedElementType)valueNode, "value", GxlUtil.AttrTypeEnum.STRING);
            try {
                if (type instanceof IntType) {
                    return new IntValue(Integer.parseInt(value));
                }
                this.addMessage(new Message("Trying to parse int value " + value + " while expected type is " + type, Message.MessageType.ERROR));
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                this.addMessage(new Message("Unable to parse value " + value + " as integer", Message.MessageType.ERROR));
                return null;
            }
        }
        if (nodeType.equals("StringVal")) {
            String value = (String)GxlUtil.getAttribute((TypedElementType)valueNode, "value", GxlUtil.AttrTypeEnum.STRING);
            if (type instanceof StringType) {
                return new StringValue(value);
            }
            this.addMessage(new Message("Trying to parse string value " + value + " while expected type is " + type, Message.MessageType.ERROR));
            return null;
        }
        if (nodeType.equals("EnumVal")) {
            String value = (String)GxlUtil.getAttribute((TypedElementType)valueNode, "value", GxlUtil.AttrTypeEnum.STRING);
            if (type instanceof Enum) {
                return new EnumValue((Enum)type, Name.getName(value));
            }
            this.addMessage(new Message("Trying to parse enum value " + value + " while expected type is " + type, Message.MessageType.ERROR));
            return null;
        }
        if (nodeType.equals("BagVal") || nodeType.equals("SetVal") || nodeType.equals("SeqVal")) {
            Container.Kind ct = Container.Kind.BAG;
            if (nodeType.equals("BagVal")) {
                ct = Container.Kind.BAG;
            } else if (nodeType.equals("SetVal")) {
                ct = Container.Kind.SET;
            } else if (nodeType.equals("SeqVal")) {
                ct = Container.Kind.SEQ;
            }
            if (type instanceof Container && ((Container)type).getContainerType() == ct) {
                ContainerValue cv = new ContainerValue((Container)type);
                for (GxlUtil.EdgeWrapper ew : nodeWrapper.getEdges()) {
                    if (!ew.getType().equals("hasComponentValue")) continue;
                    Value v = this.visitValue(tm, ew.getTarget(), ((Container)type).getType(), graphNamespace);
                    cv.addValue(v);
                }
                return cv;
            }
            this.addMessage(new Message("Trying to parse " + nodeType + " container value, while expected type is " + type, Message.MessageType.ERROR));
            return null;
        }
        if (nodeType.equals("TupVal")) {
            if (type instanceof Tuple) {
                ArrayList<Value> values = new ArrayList<Value>();
                for (GxlUtil.EdgeWrapper ew : nodeWrapper.getEdges()) {
                    if (!ew.getType().equals("hasComponentValue")) continue;
                    Value v = this.visitValue(tm, ew.getTarget(), ((Container)type).getType(), graphNamespace);
                    values.add(v);
                }
                TupleValue tv = new TupleValue((Tuple)type, values.toArray(new Value[values.size()]));
                return tv;
            }
            this.addMessage(new Message("Trying to parse tuple value while expected type is " + type, Message.MessageType.ERROR));
            return null;
        }
        this.addMessage(new Message("Unable to parse value node " + nodeType, Message.MessageType.ERROR));
        return null;
    }

    private Limits getLimits(EdgeType edge) {
        TupType limits = (TupType)GxlUtil.getAttribute((TypedElementType)edge, "limits", GxlUtil.AttrTypeEnum.TUP);
        if (limits == null || limits.getBagOrSetOrSeq().size() != 2) {
            return new Limits();
        }
        BigInteger lower = (BigInteger)((JAXBElement)limits.getBagOrSetOrSeq().get(0)).getValue();
        BigInteger upper = (BigInteger)((JAXBElement)limits.getBagOrSetOrSeq().get(1)).getValue();
        return new Limits(lower, upper);
    }

    public Type getIdType(String id) {
        return this.m_idToType.get(id);
    }

    public Field getIdField(String id) {
        return this.m_idToField.get(id);
    }

    public Id getGraphId(String graphId) {
        return this.m_graphNamespaces.get(graphId);
    }

    public boolean isComplex(String edgeId) {
        return this.m_complexEdgeIds.contains(edgeId);
    }

    private class Limits {
        public int lower;
        public int upper;

        public Limits() {
            this.lower = 0;
            this.upper = -1;
        }

        public Limits(BigInteger lowerLimit, BigInteger upperLimit) {
            this.lower = lowerLimit.intValue();
            this.upper = upperLimit.intValue();
        }

        public boolean isDefault() {
            return this.lower == 0 && this.upper == -1;
        }
    }
}

