/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.lang.gxl;

import de.gupro.gxl.gxl_1_0.EdgeType;
import de.gupro.gxl.gxl_1_0.GraphType;
import de.gupro.gxl.gxl_1_0.NodeType;
import de.gupro.gxl.gxl_1_0.TupType;
import de.gupro.gxl.gxl_1_0.TypedElementType;
import groove.io.conceptual.Field;
import groove.io.conceptual.Id;
import groove.io.conceptual.Identifiable;
import groove.io.conceptual.Name;
import groove.io.conceptual.Timer;
import groove.io.conceptual.TypeModel;
import groove.io.conceptual.lang.ExportableResource;
import groove.io.conceptual.lang.TypeExporter;
import groove.io.conceptual.lang.gxl.GxlResource;
import groove.io.conceptual.lang.gxl.GxlUtil;
import groove.io.conceptual.property.AbstractProperty;
import groove.io.conceptual.property.ContainmentProperty;
import groove.io.conceptual.property.DefaultValueProperty;
import groove.io.conceptual.property.IdentityProperty;
import groove.io.conceptual.property.KeysetProperty;
import groove.io.conceptual.property.OppositeProperty;
import groove.io.conceptual.type.BoolType;
import groove.io.conceptual.type.Class;
import groove.io.conceptual.type.Container;
import groove.io.conceptual.type.CustomDataType;
import groove.io.conceptual.type.DataType;
import groove.io.conceptual.type.Enum;
import groove.io.conceptual.type.IntType;
import groove.io.conceptual.type.RealType;
import groove.io.conceptual.type.StringType;
import groove.io.conceptual.type.Tuple;
import groove.io.conceptual.type.Type;
import groove.io.conceptual.value.BoolValue;
import groove.io.conceptual.value.ContainerValue;
import groove.io.conceptual.value.CustomDataValue;
import groove.io.conceptual.value.EnumValue;
import groove.io.conceptual.value.IntValue;
import groove.io.conceptual.value.RealValue;
import groove.io.conceptual.value.StringValue;
import groove.io.conceptual.value.TupleValue;
import groove.io.conceptual.value.Value;
import groove.io.external.PortException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.bind.JAXBElement;

public class TypeToGxl
extends TypeExporter<NodeType> {
    private GxlResource m_gxlResource;
    private GraphType m_typeGraph;
    private Map<Id, NodeType> m_packageNodes = new HashMap<Id, NodeType>();
    private Map<Id, NodeType> m_packageIntermediateNodes = new HashMap<Id, NodeType>();
    private String m_currentTypeName;
    private Map<Object, String> m_objectIDs = new HashMap<Object, String>();
    private Map<Tuple, Class> m_tupleClasses = new HashMap<Tuple, Class>();
    private int m_nextType = 1;
    private int m_nextEdge = 1;
    private int m_nextValue = 1;

    public TypeToGxl(GxlResource gxlResource) {
        this.m_gxlResource = gxlResource;
    }

    @Override
    public void addTypeModel(TypeModel typeModel) throws PortException {
        if (this.m_typeGraph == null) {
            this.m_typeGraph = this.m_gxlResource.getTypeGraph(typeModel.getName());
        }
        int timer = Timer.start("TM to GXL");
        this.m_currentTypeName = typeModel.getName();
        this.visitTypeModel(typeModel);
        Timer.stop(timer);
    }

    @Override
    public ExportableResource getResource() {
        return this.m_gxlResource;
    }

    @Override
    public void visit(DataType t, Object param) {
        if (this.hasElement(t)) {
            return;
        }
        NodeType typeNode = null;
        if (t instanceof StringType) {
            typeNode = this.createNode(this.getId(t), String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#String", Id.ROOT);
        } else if (t instanceof IntType) {
            typeNode = this.createNode(this.getId(t), String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#Int", Id.ROOT);
        } else if (t instanceof RealType) {
            typeNode = this.createNode(this.getId(t), String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#Float", Id.ROOT);
        } else if (t instanceof BoolType) {
            typeNode = this.createNode(this.getId(t), String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#Bool", Id.ROOT);
        } else if (t instanceof CustomDataType) {
            typeNode = this.createNode(this.getId(t), String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#String", t.getId().getNamespace());
        }
        this.setElement(t, typeNode);
    }

    @Override
    public void visit(Class cmClass, Object param) {
        if (this.hasElement(cmClass)) {
            return;
        }
        if (!cmClass.isProper()) {
            this.setElement(cmClass, (NodeType)this.getElement(cmClass.getProperClass()));
            return;
        }
        NodeType classNode = this.createNode(this.getId(cmClass), String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#NodeClass", cmClass.getId().getNamespace());
        this.setElement(cmClass, classNode);
        GxlUtil.setAttribute((TypedElementType)classNode, "name", this.idToName(cmClass.getId()), GxlUtil.AttrTypeEnum.STRING);
        GxlUtil.setAttribute((TypedElementType)classNode, "isabstract", false, GxlUtil.AttrTypeEnum.BOOL);
        for (Class superClass : cmClass.getSuperClasses()) {
            NodeType superNode = (NodeType)this.getElement(superClass);
            this.createEdge(classNode, superNode, String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#isA");
        }
        for (Field field : cmClass.getFields()) {
            NodeType fieldNode = (NodeType)this.getElement(field);
            boolean isAttribute = this.isAttribute(field);
            if (isAttribute) {
                NodeType attrNode = fieldNode;
                this.createEdge(classNode, attrNode, String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#hasAttribute");
                continue;
            }
            NodeType edgeNode = fieldNode;
            EdgeType fromEdge = this.createEdge(edgeNode, classNode, String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#from");
            TupType limits = this.createLimit(0, -1);
            GxlUtil.setAttribute((TypedElementType)fromEdge, "limits", limits, GxlUtil.AttrTypeEnum.TUP);
            GxlUtil.setAttribute((TypedElementType)fromEdge, "isordered", false, GxlUtil.AttrTypeEnum.BOOL);
        }
    }

    @Override
    public void visit(Field field, Object param) {
        if (this.hasElement(field)) {
            return;
        }
        NodeType fieldNode = null;
        if (this.isAttribute(field)) {
            NodeType typeNode = (NodeType)this.getElement(field.getType());
            NodeType attrNode = this.createNode(this.getId(field), String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#AttributeClass", field.getDefiningClass().getId().getNamespace());
            GxlUtil.setAttribute((TypedElementType)attrNode, "name", field.getName().toString(), GxlUtil.AttrTypeEnum.STRING);
            this.createEdge(attrNode, typeNode, String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#hasDomain");
            fieldNode = attrNode;
        } else if (field.getType() instanceof Container) {
            NodeType edgeNode;
            fieldNode = edgeNode = (NodeType)this.getElement(field.getType());
        } else {
            NodeType edgeNode = this.createNode(this.getId(field), String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#EdgeClass", field.getDefiningClass().getId().getNamespace());
            GxlUtil.setAttribute((TypedElementType)edgeNode, "name", field.getName().toString(), GxlUtil.AttrTypeEnum.STRING);
            GxlUtil.setAttribute((TypedElementType)edgeNode, "isdirected", true, GxlUtil.AttrTypeEnum.BOOL);
            GxlUtil.setAttribute((TypedElementType)edgeNode, "isabstract", false, GxlUtil.AttrTypeEnum.BOOL);
            boolean ordered = false;
            NodeType typeNode = (NodeType)this.getElement(field.getType());
            EdgeType toEdge = this.createEdge(edgeNode, typeNode, String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#to");
            TupType limits = this.createLimit(field.getLowerBound(), field.getUpperBound());
            GxlUtil.setAttribute((TypedElementType)toEdge, "limits", limits, GxlUtil.AttrTypeEnum.TUP);
            GxlUtil.setAttribute((TypedElementType)toEdge, "isordered", ordered, GxlUtil.AttrTypeEnum.BOOL);
            fieldNode = edgeNode;
        }
        this.setElement(field, fieldNode);
    }

    @Override
    public void visit(Container container, Object param) {
        if (!this.isAttribute(container)) {
            String edgeId = this.getEdgeId();
            NodeType edgeNode = this.createNode(edgeId, String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#EdgeClass", Id.ROOT);
            GxlUtil.setAttribute((TypedElementType)edgeNode, "name", "value_" + edgeId, GxlUtil.AttrTypeEnum.STRING);
            GxlUtil.setAttribute((TypedElementType)edgeNode, "isdirected", true, GxlUtil.AttrTypeEnum.BOOL);
            GxlUtil.setAttribute((TypedElementType)edgeNode, "isabstract", false, GxlUtil.AttrTypeEnum.BOOL);
            this.setElement(container, edgeNode);
            Container.Kind ct = container.getContainerType();
            boolean ordered = ct == Container.Kind.ORD || ct == Container.Kind.SEQ;
            NodeType typeNode = (NodeType)this.getElement(container.getType());
            if (container.getType() instanceof Container) {
                NodeType containerNode = this.createNode(this.getId(container), String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#NodeClass", Id.ROOT);
                GxlUtil.setAttribute((TypedElementType)containerNode, "name", this.getId(container), GxlUtil.AttrTypeEnum.STRING);
                GxlUtil.setAttribute((TypedElementType)containerNode, "isabstract", false, GxlUtil.AttrTypeEnum.BOOL);
                EdgeType toEdge = this.createEdge(edgeNode, containerNode, String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#to");
                TupType limits = this.createLimit(0, -1);
                GxlUtil.setAttribute((TypedElementType)toEdge, "limits", limits, GxlUtil.AttrTypeEnum.TUP);
                GxlUtil.setAttribute((TypedElementType)toEdge, "isordered", ordered, GxlUtil.AttrTypeEnum.BOOL);
                EdgeType fromEdge = this.createEdge(typeNode, containerNode, String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#from");
                limits = this.createLimit(1, 1);
                GxlUtil.setAttribute((TypedElementType)fromEdge, "limits", limits, GxlUtil.AttrTypeEnum.TUP);
                GxlUtil.setAttribute((TypedElementType)fromEdge, "isordered", false, GxlUtil.AttrTypeEnum.BOOL);
            } else {
                EdgeType toEdge = this.createEdge(edgeNode, typeNode, String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#to");
                TupType limits = this.createLimit(0, -1);
                GxlUtil.setAttribute((TypedElementType)toEdge, "limits", limits, GxlUtil.AttrTypeEnum.TUP);
                GxlUtil.setAttribute((TypedElementType)toEdge, "isordered", ordered, GxlUtil.AttrTypeEnum.BOOL);
            }
            return;
        }
        String gxlType = GxlUtil.g_gxlTypeGraphURI;
        switch (container.getContainerType()) {
            case SET: {
                gxlType = String.valueOf(gxlType) + "#Set";
                break;
            }
            case BAG: {
                gxlType = String.valueOf(gxlType) + "#Bag";
                break;
            }
            case SEQ: {
                gxlType = String.valueOf(gxlType) + "#Seq";
                break;
            }
            case ORD: {
                gxlType = String.valueOf(gxlType) + "#Seq";
            }
        }
        NodeType containerNode = this.createNode(this.getId(container), gxlType, Id.ROOT);
        this.setElement(container, containerNode);
        NodeType subTypeNode = (NodeType)this.getElement(container.getType());
        this.createEdge(containerNode, subTypeNode, String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#hasComponent");
    }

    @Override
    public void visit(Enum cmEnum, Object param) {
        if (this.hasElement(cmEnum)) {
            return;
        }
        NodeType enumNode = this.createNode(this.getId(cmEnum), String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#Enum", cmEnum.getId().getNamespace());
        this.setElement(cmEnum, enumNode);
        for (Name literal : cmEnum.getLiterals()) {
            String literalId = String.valueOf(this.getId(cmEnum)) + "_" + literal;
            NodeType literalNode = this.createNode(literalId, String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#EnumVal", cmEnum.getId().getNamespace());
            GxlUtil.setAttribute((TypedElementType)literalNode, "value", literal.toString(), GxlUtil.AttrTypeEnum.STRING);
            this.createEdge(enumNode, literalNode, String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#containsValue");
        }
    }

    @Override
    public void visit(Tuple tuple, Object param) {
        if (this.hasElement(tuple)) {
            return;
        }
        if (this.isAttribute(tuple)) {
            NodeType tupleNode = this.createNode(this.getId(tuple), String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#Tup", Id.ROOT);
            this.setElement(tuple, tupleNode);
            int index = 0;
            for (Type type : tuple.getTypes()) {
                NodeType typeNode = (NodeType)this.getElement(type);
                EdgeType componentEdge = this.createEdge(tupleNode, typeNode, String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#hasComponent");
                componentEdge.setToorder(BigInteger.valueOf(index++));
            }
        } else {
            Class cmClass = this.makeClass(tuple);
            this.m_tupleClasses.put(tuple, cmClass);
            this.setElement(tuple, (NodeType)this.getElement(cmClass));
        }
    }

    @Override
    public void visit(AbstractProperty abstractProperty, Object param) {
        if (this.hasElement(abstractProperty)) {
            return;
        }
        this.setElement(abstractProperty, null);
        NodeType classNode = (NodeType)this.getElement(abstractProperty.getAbstractClass());
        GxlUtil.setAttribute((TypedElementType)classNode, "isabstract", true, GxlUtil.AttrTypeEnum.BOOL);
    }

    @Override
    public void visit(ContainmentProperty containmentProperty, Object param) {
        if (this.hasElement(containmentProperty)) {
            return;
        }
        this.setElement(containmentProperty, null);
        NodeType fieldNode = (NodeType)this.getElement(containmentProperty.getField());
        GxlUtil.setElemType((TypedElementType)fieldNode, String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#CompositionClass");
        GxlUtil.setAttribute((TypedElementType)fieldNode, "aggregate", "to", GxlUtil.AttrTypeEnum.ENUM);
    }

    @Override
    public void visit(IdentityProperty identityProperty, Object param) {
        if (this.hasElement(identityProperty)) {
            return;
        }
        this.setElement(identityProperty, null);
    }

    @Override
    public void visit(KeysetProperty keysetProperty, Object param) {
        if (this.hasElement(keysetProperty)) {
            return;
        }
        this.setElement(keysetProperty, null);
    }

    @Override
    public void visit(OppositeProperty oppositeProperty, Object param) {
        if (this.hasElement(oppositeProperty)) {
            return;
        }
        this.setElement(oppositeProperty, null);
    }

    @Override
    public void visit(DefaultValueProperty defaultValueProperty, Object param) {
        if (this.hasElement(defaultValueProperty)) {
            return;
        }
        this.setElement(defaultValueProperty, null);
        if (!this.isAttribute(defaultValueProperty.getField())) {
            throw new IllegalArgumentException("Field must be an attribute for use with default value");
        }
        NodeType fieldNode = (NodeType)this.getElement(defaultValueProperty.getField());
        NodeType valueNode = this.getValueElement(defaultValueProperty.getDefaultValue());
        this.createEdge(fieldNode, valueNode, String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#hasDefaultValue");
    }

    public String getId(Type type) {
        if (this.m_objectIDs.containsKey(type)) {
            return this.m_objectIDs.get(type);
        }
        String nodeId = null;
        if (type instanceof Identifiable) {
            Id typeId = ((Identifiable)((Object)type)).getId();
            nodeId = this.getShortId(typeId).toString();
            if (!(type instanceof Class)) {
                nodeId = "type_" + nodeId;
            }
        } else {
            String className = type.getClass().getSimpleName();
            nodeId = "type_" + className + this.m_nextType++;
        }
        this.m_objectIDs.put(type, nodeId);
        return nodeId;
    }

    public String getId(Field field) {
        if (this.m_objectIDs.containsKey(field)) {
            return this.m_objectIDs.get(field);
        }
        String id = null;
        id = "field_" + field.getName() + this.m_nextType++;
        this.m_objectIDs.put(field, id);
        return id;
    }

    public String getId(Id packageId) {
        return this.m_packageNodes.get(packageId).getId();
    }

    private Id getShortId(Id id) {
        return id;
    }

    private String getEdgeId() {
        return "e" + this.m_nextEdge++;
    }

    private String getValueId(Value v) {
        return "val_" + v.toString() + "_" + this.m_nextValue++;
    }

    private NodeType createNode(String id, String type, Id packageId) {
        NodeType newNode = new NodeType();
        newNode.setId(id);
        if (type != null) {
            GxlUtil.setElemType((TypedElementType)newNode, type);
        }
        this.m_typeGraph.getNodeOrEdgeOrRel().add(newNode);
        NodeType graphNode = this.getPackageNode(Id.ROOT);
        if (graphNode != null && (type.equals(String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#NodeClass") || type.equals(String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#EdgeClass") || type.equals(String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#CompositionClass") || type.equals(String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#AggregationClass") || type.equals(String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#RelationClass"))) {
            this.createEdge(graphNode, newNode, String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#contains");
        }
        return newNode;
    }

    private EdgeType createEdge(NodeType from, NodeType to, String type) {
        EdgeType newEdge = new EdgeType();
        newEdge.setFrom((Object)from);
        newEdge.setTo((Object)to);
        newEdge.setId(this.getEdgeId());
        if (type != null) {
            GxlUtil.setElemType((TypedElementType)newEdge, type);
        }
        this.m_typeGraph.getNodeOrEdgeOrRel().add(newEdge);
        return newEdge;
    }

    private TupType createLimit(int lower, int upper) {
        TupType limitTuple = new TupType();
        JAXBElement lowerInt = GxlUtil.g_objectFactory.createInt(BigInteger.valueOf(lower));
        JAXBElement upperInt = GxlUtil.g_objectFactory.createInt(BigInteger.valueOf(upper));
        limitTuple.getBagOrSetOrSeq().add(lowerInt);
        limitTuple.getBagOrSetOrSeq().add(upperInt);
        return limitTuple;
    }

    public boolean isAttribute(Field field) {
        return this.isAttribute(field.getType());
    }

    public boolean isAttribute(Type type) {
        while (type instanceof Container) {
            type = ((Container)type).getType();
        }
        boolean isAttribute = type instanceof DataType;
        if (type instanceof Tuple) {
            isAttribute = true;
            Tuple tup = (Tuple)type;
            for (Type t : tup.getTypes()) {
                isAttribute &= this.isAttribute(t);
            }
        }
        if (type instanceof Container) {
            return this.isAttribute(type);
        }
        return isAttribute;
    }

    private NodeType getValueElement(Value v) {
        if (this.hasElement(v)) {
            return (NodeType)this.getElement(v);
        }
        NodeType valNode = null;
        if (v instanceof BoolValue) {
            valNode = this.createNode(this.getValueId(v), String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#BoolVal", Id.ROOT);
            GxlUtil.setAttribute((TypedElementType)valNode, "value", new Boolean(((BoolValue)v).getValue()).toString(), GxlUtil.AttrTypeEnum.STRING);
            return valNode;
        }
        if (v instanceof IntValue) {
            valNode = this.createNode(this.getValueId(v), String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#IntVal", Id.ROOT);
            GxlUtil.setAttribute((TypedElementType)valNode, "value", ((IntValue)v).getValue().toString(), GxlUtil.AttrTypeEnum.STRING);
            return valNode;
        }
        if (v instanceof RealValue) {
            valNode = this.createNode(this.getValueId(v), String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#FloatVal", Id.ROOT);
            GxlUtil.setAttribute((TypedElementType)valNode, "value", ((RealValue)v).getValue().toString(), GxlUtil.AttrTypeEnum.STRING);
            return valNode;
        }
        if (v instanceof StringValue) {
            valNode = this.createNode(this.getValueId(v), String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#StringVal", Id.ROOT);
            GxlUtil.setAttribute((TypedElementType)valNode, "value", ((StringValue)v).getValue(), GxlUtil.AttrTypeEnum.STRING);
            return valNode;
        }
        if (v instanceof EnumValue) {
            valNode = this.createNode(this.getValueId(v), String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#EnumVal", ((Enum)v.getType()).getId().getNamespace());
            GxlUtil.setAttribute((TypedElementType)valNode, "value", ((EnumValue)v).getValue().toString(), GxlUtil.AttrTypeEnum.STRING);
            return valNode;
        }
        if (v instanceof CustomDataValue) {
            valNode = this.createNode(this.getValueId(v), String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#StringVal", ((CustomDataType)v.getType()).getId().getNamespace());
            GxlUtil.setAttribute((TypedElementType)valNode, "value", ((CustomDataValue)v).getValue().toString(), GxlUtil.AttrTypeEnum.STRING);
            return valNode;
        }
        if (v instanceof ContainerValue) {
            ContainerValue cv = (ContainerValue)v;
            String type = String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#";
            switch (((Container)cv.getType()).getContainerType()) {
                case SET: {
                    type = String.valueOf(type) + "SetVal";
                    break;
                }
                case BAG: {
                    type = String.valueOf(type) + "BagVal";
                    break;
                }
                case SEQ: 
                case ORD: {
                    type = String.valueOf(type) + "SeqVal";
                }
            }
            valNode = this.createNode(this.getValueId(v), type, Id.ROOT);
            int index = 0;
            Iterator iterator = cv.getValue().iterator();
            while (iterator.hasNext()) {
                Value subVal = (Value)iterator.next();
                NodeType subValNode = this.getValueElement(subVal);
                EdgeType valEdge = this.createEdge(valNode, subValNode, String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#hasComponentValue");
                valEdge.setToorder(BigInteger.valueOf(index++));
            }
            return valNode;
        }
        if (v instanceof TupleValue) {
            TupleValue tv = (TupleValue)v;
            valNode = this.createNode(this.getValueId(v), String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#TupVal", Id.ROOT);
            for (Map.Entry subEntry : tv.getValue().entrySet()) {
                NodeType subValNode = this.getValueElement((Value)subEntry.getValue());
                EdgeType valEdge = this.createEdge(valNode, subValNode, String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#hasComponentValue");
                valEdge.setToorder(BigInteger.valueOf(((Integer)subEntry.getKey()).intValue()));
            }
            return valNode;
        }
        this.setElement(v, valNode);
        return valNode;
    }

    private NodeType getPackageNode(Id packageId) {
        if (!this.m_packageNodes.containsKey(packageId)) {
            NodeType graphNode = new NodeType();
            graphNode.setId("graph_" + (packageId == Id.ROOT ? this.m_currentTypeName : packageId));
            GxlUtil.setElemType((TypedElementType)graphNode, String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#GraphClass");
            GxlUtil.setAttribute((TypedElementType)graphNode, "name", packageId == Id.ROOT ? this.m_currentTypeName : packageId.getName().toString(), GxlUtil.AttrTypeEnum.STRING);
            this.m_typeGraph.getNodeOrEdgeOrRel().add(graphNode);
            this.m_packageNodes.put(packageId, graphNode);
            if (packageId != Id.ROOT) {
                NodeType parentNode = this.getPackageNode(packageId.getNamespace());
                NodeType intermediateNode = null;
                if (this.m_packageIntermediateNodes.containsKey(packageId.getNamespace())) {
                    intermediateNode = this.m_packageIntermediateNodes.get(packageId.getNamespace());
                } else {
                    intermediateNode = new NodeType();
                    intermediateNode.setId("graphnode_" + packageId.getNamespace());
                    GxlUtil.setElemType((TypedElementType)graphNode, String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#NodeClass");
                    this.createEdge(parentNode, intermediateNode, String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#contains");
                    this.m_typeGraph.getNodeOrEdgeOrRel().add(intermediateNode);
                }
                this.createEdge(intermediateNode, graphNode, String.valueOf(GxlUtil.g_gxlTypeGraphURI) + "#hasAsComponentGraph");
            }
            return graphNode;
        }
        return this.m_packageNodes.get(packageId);
    }

    private String idToName(Id id) {
        String res = id.getName().toString();
        while (id.getNamespace() != Id.ROOT) {
            res = id.getNamespace().getName() + "." + res;
            id = id.getNamespace();
        }
        return res;
    }

    private Class makeClass(Tuple tuple) {
        Class cmClass = new Class(Id.getId(Id.ROOT, Name.getName(this.getId(tuple))));
        int index = 1;
        for (Type t : tuple.getTypes()) {
            cmClass.addField(new Field(Name.getName("_" + index++), t, 1, 1));
        }
        return cmClass;
    }

    public Class getTupleClass(Tuple t) {
        if (this.m_tupleClasses.containsKey(t)) {
            return this.m_tupleClasses.get(t);
        }
        return null;
    }
}

