/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.type;

import groove.io.conceptual.Id;
import groove.io.conceptual.Name;
import groove.io.conceptual.Visitor;
import groove.io.conceptual.type.DataType;
import groove.io.conceptual.value.EnumValue;
import groove.io.conceptual.value.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Enum
extends DataType {
    private List<Name> m_values = new ArrayList<Name>();

    public Enum(Id id) {
        super(id);
    }

    public void addLiteral(Name litName) {
        this.m_values.add(litName);
    }

    @Override
    public String typeString() {
        return "Enum";
    }

    @Override
    public String toString() {
        return this.getId() + "<" + this.typeString() + ">";
    }

    public Collection<Name> getLiterals() {
        return this.m_values;
    }

    @Override
    public boolean doVisit(Visitor v, Object param) {
        v.visit(this, param);
        return true;
    }

    @Override
    public Value valueFromString(String valueString) {
        Name valName = Name.getName(valueString);
        if (this.m_values.contains(valName)) {
            return new EnumValue(this, valName);
        }
        return null;
    }
}

