/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.type;

import groove.io.conceptual.Id;
import groove.io.conceptual.Name;
import groove.io.conceptual.Visitor;
import groove.io.conceptual.type.DataType;
import groove.io.conceptual.value.IntValue;
import groove.io.conceptual.value.Value;

public class IntType
extends DataType {
    private static final IntType instance = new IntType();
    public static final String NAME = "int";

    private IntType() {
        super(Id.getId(Id.ROOT, Name.getName(NAME)));
    }

    @Override
    public String typeString() {
        return NAME;
    }

    @Override
    public boolean doVisit(Visitor v, Object param) {
        v.visit(this, param);
        return true;
    }

    @Override
    public Value valueFromString(String valueString) {
        IntValue result;
        try {
            result = new IntValue(Integer.parseInt(valueString));
        }
        catch (NumberFormatException numberFormatException) {
            result = null;
        }
        return result;
    }

    @Override
    public boolean acceptValue(Value v) {
        return v instanceof IntValue;
    }

    public static IntType instance() {
        return instance;
    }
}

