/*
 * Decompiled with CFR 0.152.
 */
package groove.io.ecore2groove;

import groove.graph.GraphRole;
import groove.graph.plain.PlainGraph;
import groove.graph.plain.PlainLabel;
import groove.graph.plain.PlainNode;
import groove.io.ecore2groove.GraphLabels;
import groove.io.ecore2groove.ModelHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ConstraintRules {
    private ModelHandler mh;
    private List<PlainGraph> constraintRules;

    public ConstraintRules(ModelHandler mh) {
        this.mh = mh;
        this.constraintRules = new ArrayList<PlainGraph>();
        this.eClassConstraints(mh.getEClasses());
        this.eEnumConstraints(mh.getEEnums());
        this.eReferenceConstraints(mh.getEReferences());
        this.eAttributeConstraints(mh.getEAttributes());
    }

    private void eClassConstraints(Vector<EClass> eClasses) {
        for (EClass eClass : eClasses) {
            if (!eClass.isAbstract()) continue;
            this.addAbstractConstraint(eClass);
        }
        if (this.mh.getEReferences().size() != 0) {
            this.addCyclicityConstraint();
            this.addOneContainerConstraint();
        }
        this.addRootConstraint();
    }

    private void eEnumConstraints(Vector<EEnum> eEnums) {
        for (EEnum eEnum : eEnums) {
            this.addNoLiteralsConstraint(eEnum);
            this.addManyLiteralsConstraint(eEnum);
            this.addNoIncValConstraint(eEnum);
            this.addManyIncValConstraint(eEnum);
        }
    }

    private void eReferenceConstraints(Vector<EReference> eReferences) {
        for (EReference eReference : eReferences) {
            this.addNoValConstraint((EStructuralFeature)eReference);
            this.addManyValConstraint((EStructuralFeature)eReference);
            this.addNoContainerConstraint((EStructuralFeature)eReference);
            this.addManyContainerConstraint((EStructuralFeature)eReference);
            if (eReference.isMany() && eReference.isUnique()) {
                this.addUniqueRefConstraint(eReference);
            }
            if (eReference.getLowerBound() > 0) {
                this.addLowerBoundConstraint((EStructuralFeature)eReference);
            }
            if (eReference.getUpperBound() != -1) {
                this.addUpperBoundConstraint((EStructuralFeature)eReference);
            }
            if (eReference.getEOpposite() != null) {
                this.addOppositeConstraint(eReference);
            }
            if (!eReference.getEKeys().isEmpty()) {
                this.addEkeysConstraint(eReference);
            }
            if (eReference.isOrdered() && eReference.isMany()) {
                this.addOrderedConstraint((EStructuralFeature)eReference);
            }
            if (eReference.isContainment()) {
                this.addContainmentConstraint(eReference);
                continue;
            }
            this.addNotContainmentConstraint(eReference);
        }
    }

    private void eAttributeConstraints(Vector<EAttribute> eAttributes) {
        for (EAttribute eAttribute : eAttributes) {
            this.addManyValConstraint((EStructuralFeature)eAttribute);
            this.addValuesConstraint(eAttribute);
            if (eAttribute.isMany() && eAttribute.isUnique()) {
                this.addUniqueAttrConstraint(eAttribute);
            }
            if (eAttribute.getLowerBound() > 0) {
                this.addLowerBoundConstraint((EStructuralFeature)eAttribute);
            }
            if (eAttribute.getUpperBound() != -1) {
                this.addUpperBoundConstraint((EStructuralFeature)eAttribute);
            }
            if (!eAttribute.isChangeable() && eAttribute.getDefaultValueLiteral() != null && !eAttribute.getDefaultValueLiteral().equals("")) {
                this.addUnchangeableConstraint(eAttribute);
            }
            if (eAttribute.isID()) {
                this.addIDConstraint(eAttribute);
            }
            if (!eAttribute.isOrdered() || !eAttribute.isMany()) continue;
            this.addOrderedConstraint((EStructuralFeature)eAttribute);
        }
    }

    private void addCyclicityConstraint() {
        String name = "constraint - global - cyclicity";
        PlainGraph constraintRule = this.createRuleGraph(name);
        PlainNode node = (PlainNode)constraintRule.addNode();
        constraintRule.addEdge(node, this.mh.getEClassType(), node);
        constraintRule.addEdge(node, "path:(?.flag:containment.val)+", node);
    }

    private void addOneContainerConstraint() {
        String name = "constraint - global - noContainer";
        PlainGraph constraintRule = this.createRuleGraph(name);
        PlainLabel eclassLabel = PlainLabel.createLabel(this.mh.getEClassType());
        PlainLabel notFlagLabel = PlainLabel.createLabel("not:flag:root");
        PlainLabel refLabel = PlainLabel.createLabel(this.mh.getEReferenceType());
        PlainNode eclassNode = (PlainNode)constraintRule.addNode();
        PlainNode contRefNode = (PlainNode)constraintRule.addNode();
        constraintRule.addEdge(eclassNode, eclassLabel, eclassNode);
        constraintRule.addEdge(eclassNode, notFlagLabel, eclassNode);
        constraintRule.addEdge(contRefNode, refLabel, contRefNode);
        constraintRule.addEdge(contRefNode, "not:", contRefNode);
        constraintRule.addEdge(contRefNode, "flag:containment", contRefNode);
        constraintRule.addEdge(contRefNode, "val", eclassNode);
        constraintRule = this.createRuleGraph(name);
        name = "constraint - global - manyContainers";
        eclassNode = (PlainNode)constraintRule.addNode();
        PlainNode refNode1 = (PlainNode)constraintRule.addNode();
        PlainNode refNode2 = (PlainNode)constraintRule.addNode();
        PlainLabel regExprLabel = PlainLabel.createLabel("path:flag:containment.val");
        PlainLabel unequalLabel = PlainLabel.createLabel("!=");
        constraintRule.addEdge(eclassNode, eclassLabel, eclassNode);
        constraintRule.addEdge(eclassNode, notFlagLabel, eclassNode);
        constraintRule.addEdge(refNode1, refLabel, refNode1);
        constraintRule.addEdge(refNode2, refLabel, refNode2);
        constraintRule.addEdge(refNode1, unequalLabel, refNode2);
        constraintRule.addEdge(refNode1, regExprLabel, eclassNode);
        constraintRule.addEdge(refNode2, regExprLabel, eclassNode);
    }

    private void addRootConstraint() {
        String name = "constraint - global - manyRoot";
        PlainGraph constraintRule = this.createRuleGraph(name);
        PlainNode node1 = (PlainNode)constraintRule.addNode();
        PlainNode node2 = (PlainNode)constraintRule.addNode();
        PlainLabel eclassLabel = PlainLabel.createLabel(this.mh.getEClassType());
        PlainLabel flagLabel = PlainLabel.createLabel("flag:root");
        PlainLabel unequalLabel = PlainLabel.createLabel("!=");
        constraintRule.addEdge(node1, eclassLabel, node1);
        constraintRule.addEdge(node2, eclassLabel, node2);
        constraintRule.addEdge(node1, flagLabel, node1);
        constraintRule.addEdge(node2, flagLabel, node2);
        constraintRule.addEdge(node1, unequalLabel, node2);
        constraintRule = this.createRuleGraph(name);
        name = "constraint - global - noRoot";
        PlainNode eclassNode = (PlainNode)constraintRule.addNode();
        PlainLabel notLabel = PlainLabel.createLabel("not:");
        constraintRule.addEdge(eclassNode, eclassLabel, eclassNode);
        constraintRule.addEdge(eclassNode, flagLabel, eclassNode);
        constraintRule.addEdge(eclassNode, notLabel, eclassNode);
        if (this.mh.getEReferences().size() != 0) {
            constraintRule = this.createRuleGraph(name);
            name = "constraint - global - rootContainer";
            eclassNode = (PlainNode)constraintRule.addNode();
            PlainNode refNode = (PlainNode)constraintRule.addNode();
            PlainLabel regExprLabel = PlainLabel.createLabel("path:flag:containment.val");
            PlainLabel refLabel = PlainLabel.createLabel(this.mh.getEReferenceType());
            constraintRule.addEdge(eclassNode, eclassLabel, eclassNode);
            constraintRule.addEdge(eclassNode, flagLabel, eclassNode);
            constraintRule.addEdge(refNode, refLabel, refNode);
            constraintRule.addEdge(refNode, regExprLabel, eclassNode);
        }
    }

    private void addContainmentConstraint(EReference eReference) {
        String name = "constraint - " + GraphLabels.getLabelNoType((EStructuralFeature)eReference) + " - noContainmentFlag";
        PlainGraph constraintRule = this.createRuleGraph(name);
        PlainNode node = (PlainNode)constraintRule.addNode();
        PlainLabel refLabel = PlainLabel.createLabel(GraphLabels.getLabel((EStructuralFeature)eReference));
        PlainLabel notContLabel = PlainLabel.createLabel("not:flag:containment");
        constraintRule.addEdge(node, refLabel, node);
        constraintRule.addEdge(node, notContLabel, node);
    }

    private void addNotContainmentConstraint(EReference eReference) {
        String name = "constraint - " + GraphLabels.getLabelNoType((EStructuralFeature)eReference) + " - containmentFlag";
        PlainGraph constraintRule = this.createRuleGraph(name);
        PlainNode node = (PlainNode)constraintRule.addNode();
        PlainLabel refLabel = PlainLabel.createLabel(GraphLabels.getLabel((EStructuralFeature)eReference));
        PlainLabel contLabel = PlainLabel.createLabel("flag:containment");
        constraintRule.addEdge(node, refLabel, node);
        constraintRule.addEdge(node, contLabel, node);
    }

    private void addOrderedConstraint(EStructuralFeature eFeature) {
        String name = "constraint - " + GraphLabels.getLabelNoType(eFeature) + " - ordered not two tail";
        PlainGraph constraintRule = this.createRuleGraph(name);
        PlainNode sourceNode = (PlainNode)constraintRule.addNode();
        PlainNode featureNode1 = (PlainNode)constraintRule.addNode();
        PlainNode featureNode2 = (PlainNode)constraintRule.addNode();
        PlainNode notFeatureNode1 = (PlainNode)constraintRule.addNode();
        PlainNode notFeatureNode2 = (PlainNode)constraintRule.addNode();
        PlainLabel sourceLabel = PlainLabel.createLabel(GraphLabels.getLabel((EClassifier)eFeature.getEContainingClass()));
        PlainLabel featureLabel = PlainLabel.createLabel(GraphLabels.getLabel(eFeature));
        PlainLabel nameLabel = PlainLabel.createLabel(eFeature.getName());
        PlainLabel unequalLabel = PlainLabel.createLabel("!=");
        PlainLabel nextLabel = PlainLabel.createLabel("next");
        PlainLabel notLabel = PlainLabel.createLabel("not:");
        constraintRule.addEdge(sourceNode, sourceLabel, sourceNode);
        constraintRule.addEdge(featureNode1, featureLabel, featureNode1);
        constraintRule.addEdge(featureNode2, featureLabel, featureNode2);
        constraintRule.addEdge(notFeatureNode1, featureLabel, notFeatureNode1);
        constraintRule.addEdge(notFeatureNode2, featureLabel, notFeatureNode2);
        constraintRule.addEdge(notFeatureNode1, notLabel, notFeatureNode1);
        constraintRule.addEdge(notFeatureNode2, notLabel, notFeatureNode2);
        constraintRule.addEdge(sourceNode, nameLabel, featureNode1);
        constraintRule.addEdge(sourceNode, nameLabel, featureNode2);
        constraintRule.addEdge(sourceNode, nameLabel, notFeatureNode1);
        constraintRule.addEdge(sourceNode, nameLabel, notFeatureNode2);
        constraintRule.addEdge(featureNode1, unequalLabel, featureNode2);
        constraintRule.addEdge(featureNode1, nextLabel, notFeatureNode1);
        constraintRule.addEdge(featureNode2, nextLabel, notFeatureNode2);
        constraintRule = this.createRuleGraph(name);
        name = "constraint - " + GraphLabels.getLabelNoType(eFeature) + " - ordered not two head";
        sourceNode = (PlainNode)constraintRule.addNode();
        featureNode1 = (PlainNode)constraintRule.addNode();
        featureNode2 = (PlainNode)constraintRule.addNode();
        notFeatureNode1 = (PlainNode)constraintRule.addNode();
        notFeatureNode2 = (PlainNode)constraintRule.addNode();
        constraintRule.addEdge(sourceNode, sourceLabel, sourceNode);
        constraintRule.addEdge(featureNode1, featureLabel, featureNode1);
        constraintRule.addEdge(featureNode2, featureLabel, featureNode2);
        constraintRule.addEdge(notFeatureNode1, featureLabel, notFeatureNode1);
        constraintRule.addEdge(notFeatureNode2, featureLabel, notFeatureNode2);
        constraintRule.addEdge(notFeatureNode1, notLabel, notFeatureNode1);
        constraintRule.addEdge(notFeatureNode2, notLabel, notFeatureNode2);
        constraintRule.addEdge(sourceNode, nameLabel, featureNode1);
        constraintRule.addEdge(sourceNode, nameLabel, featureNode2);
        constraintRule.addEdge(sourceNode, nameLabel, notFeatureNode1);
        constraintRule.addEdge(sourceNode, nameLabel, notFeatureNode2);
        constraintRule.addEdge(featureNode1, unequalLabel, featureNode2);
        constraintRule.addEdge(notFeatureNode1, nextLabel, featureNode1);
        constraintRule.addEdge(notFeatureNode2, nextLabel, featureNode2);
        constraintRule = this.createRuleGraph(name);
        name = "constraint - " + GraphLabels.getLabelNoType(eFeature) + " - ordered not two in";
        sourceNode = (PlainNode)constraintRule.addNode();
        featureNode1 = (PlainNode)constraintRule.addNode();
        featureNode2 = (PlainNode)constraintRule.addNode();
        PlainNode featureNode3 = (PlainNode)constraintRule.addNode();
        constraintRule.addEdge(sourceNode, sourceLabel, sourceNode);
        constraintRule.addEdge(featureNode1, featureLabel, featureNode1);
        constraintRule.addEdge(featureNode2, featureLabel, featureNode2);
        constraintRule.addEdge(featureNode3, featureLabel, featureNode3);
        constraintRule.addEdge(sourceNode, nameLabel, featureNode1);
        constraintRule.addEdge(sourceNode, nameLabel, featureNode2);
        constraintRule.addEdge(sourceNode, nameLabel, featureNode3);
        constraintRule.addEdge(featureNode1, unequalLabel, featureNode2);
        constraintRule.addEdge(featureNode1, nextLabel, featureNode3);
        constraintRule.addEdge(featureNode2, nextLabel, featureNode3);
        constraintRule = this.createRuleGraph(name);
        name = "constraint - " + GraphLabels.getLabelNoType(eFeature) + " - ordered not two out";
        sourceNode = (PlainNode)constraintRule.addNode();
        featureNode1 = (PlainNode)constraintRule.addNode();
        featureNode2 = (PlainNode)constraintRule.addNode();
        featureNode3 = (PlainNode)constraintRule.addNode();
        constraintRule.addEdge(sourceNode, sourceLabel, sourceNode);
        constraintRule.addEdge(featureNode1, featureLabel, featureNode1);
        constraintRule.addEdge(featureNode2, featureLabel, featureNode2);
        constraintRule.addEdge(featureNode3, featureLabel, featureNode3);
        constraintRule.addEdge(sourceNode, nameLabel, featureNode1);
        constraintRule.addEdge(sourceNode, nameLabel, featureNode2);
        constraintRule.addEdge(sourceNode, nameLabel, featureNode3);
        constraintRule.addEdge(featureNode1, unequalLabel, featureNode2);
        constraintRule.addEdge(featureNode3, nextLabel, featureNode1);
        constraintRule.addEdge(featureNode3, nextLabel, featureNode2);
        constraintRule = this.createRuleGraph(name);
        name = "constraint - " + GraphLabels.getLabelNoType(eFeature) + " - ordered not circular";
        sourceNode = (PlainNode)constraintRule.addNode();
        featureNode1 = (PlainNode)constraintRule.addNode();
        PlainLabel nextPlusLabel = PlainLabel.createLabel("path:next+");
        constraintRule.addEdge(sourceNode, sourceLabel, sourceNode);
        constraintRule.addEdge(featureNode1, featureLabel, featureNode1);
        constraintRule.addEdge(sourceNode, nameLabel, featureNode1);
        constraintRule.addEdge(featureNode1, nextPlusLabel, featureNode1);
    }

    private void addEkeysConstraint(EReference eReference) {
        String name = "constraint - " + GraphLabels.getLabelNoType((EStructuralFeature)eReference) + " - ekeys";
        PlainGraph constraintRule = this.createRuleGraph(name);
        PlainNode sourceNode = (PlainNode)constraintRule.addNode();
        PlainNode refNode1 = (PlainNode)constraintRule.addNode();
        PlainNode refNode2 = (PlainNode)constraintRule.addNode();
        PlainNode targetNode1 = (PlainNode)constraintRule.addNode();
        PlainNode targetNode2 = (PlainNode)constraintRule.addNode();
        PlainLabel sourceLabel = PlainLabel.createLabel(GraphLabels.getLabel((EClassifier)eReference.getEContainingClass()));
        PlainLabel refLabel = PlainLabel.createLabel(GraphLabels.getLabel((EStructuralFeature)eReference));
        PlainLabel targetLabel = PlainLabel.createLabel(GraphLabels.getLabel((EClassifier)eReference.getEReferenceType()));
        PlainLabel nameLabel = PlainLabel.createLabel(eReference.getName());
        PlainLabel valLabel = PlainLabel.createLabel("val");
        PlainLabel unequalLabel = PlainLabel.createLabel("!=");
        constraintRule.addEdge(sourceNode, sourceLabel, sourceNode);
        constraintRule.addEdge(refNode1, refLabel, refNode1);
        constraintRule.addEdge(refNode2, refLabel, refNode2);
        constraintRule.addEdge(targetNode1, targetLabel, targetNode1);
        constraintRule.addEdge(targetNode2, targetLabel, targetNode2);
        constraintRule.addEdge(sourceNode, nameLabel, refNode1);
        constraintRule.addEdge(sourceNode, nameLabel, refNode2);
        constraintRule.addEdge(refNode1, valLabel, targetNode1);
        constraintRule.addEdge(refNode2, valLabel, targetNode2);
        constraintRule.addEdge(targetNode1, unequalLabel, targetNode2);
        for (EAttribute eAttribute : eReference.getEKeys()) {
            if (eAttribute.isMany() && (eAttribute.isOrdered() || !eAttribute.isUnique())) {
                return;
            }
            String targetString = "";
            if (eAttribute.getEAttributeType().eClass().getName().equals("EEnum")) {
                this.addEnumCheck(constraintRule, eAttribute, targetNode1, targetNode2);
                continue;
            }
            targetString = GraphLabels.getLabel(eAttribute.getEAttributeType(), null);
            if (targetString.equals("")) {
                return;
            }
            this.addDataTypeCheck(constraintRule, eAttribute, targetNode1, targetNode2);
        }
    }

    private void addIDConstraint(EAttribute eAttribute) {
        boolean isEnum = false;
        String targetString = "";
        if (eAttribute.getEAttributeType().eClass().getName().equals("EEnum")) {
            isEnum = true;
        } else {
            targetString = GraphLabels.getLabel(eAttribute.getEAttributeType(), null);
            if (targetString.equals("")) {
                return;
            }
        }
        if (eAttribute.isMany() && (eAttribute.isOrdered() || !eAttribute.isUnique())) {
            return;
        }
        EClass contEClass = null;
        EReference contEReference = null;
        for (EReference eReference : this.mh.getEReferences()) {
            if (!eReference.getEReferenceType().equals(eAttribute.getEContainingClass()) || !eReference.isContainment()) continue;
            contEClass = eReference.getEContainingClass();
            contEReference = eReference;
            break;
        }
        if (contEClass == null) {
            return;
        }
        String name = "constraint - " + GraphLabels.getLabelNoType((EStructuralFeature)eAttribute) + " - id";
        PlainGraph constraintRule = this.createRuleGraph(name);
        PlainNode contEClassNode = (PlainNode)constraintRule.addNode();
        PlainNode contERefNode1 = (PlainNode)constraintRule.addNode();
        PlainNode contERefNode2 = (PlainNode)constraintRule.addNode();
        PlainNode contNode1 = (PlainNode)constraintRule.addNode();
        PlainNode contNode2 = (PlainNode)constraintRule.addNode();
        PlainLabel contEClassLabel = PlainLabel.createLabel(GraphLabels.getLabel((EClassifier)contEClass));
        PlainLabel contERefLabel = PlainLabel.createLabel(GraphLabels.getLabel((EStructuralFeature)contEReference));
        PlainLabel contLabel = PlainLabel.createLabel(GraphLabels.getLabel((EClassifier)eAttribute.getEContainingClass()));
        PlainLabel refNameLabel = PlainLabel.createLabel(contEReference.getName());
        PlainLabel valLabel = PlainLabel.createLabel("val");
        PlainLabel unequalLabel = PlainLabel.createLabel("!=");
        constraintRule.addEdge(contEClassNode, contEClassLabel, contEClassNode);
        constraintRule.addEdge(contERefNode1, contERefLabel, contERefNode1);
        constraintRule.addEdge(contERefNode2, contERefLabel, contERefNode2);
        constraintRule.addEdge(contNode1, contLabel, contNode1);
        constraintRule.addEdge(contNode2, contLabel, contNode2);
        constraintRule.addEdge(contEClassNode, refNameLabel, contERefNode1);
        constraintRule.addEdge(contEClassNode, refNameLabel, contERefNode2);
        constraintRule.addEdge(contERefNode1, valLabel, contNode1);
        constraintRule.addEdge(contERefNode2, valLabel, contNode2);
        constraintRule.addEdge(contNode1, unequalLabel, contNode2);
        if (isEnum) {
            this.addEnumCheck(constraintRule, eAttribute, contNode1, contNode2);
        } else {
            this.addDataTypeCheck(constraintRule, eAttribute, contNode1, contNode2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addValuesConstraint(EAttribute eAttribute) {
        String lowerBound = null;
        String upperBound = null;
        String type = null;
        if (eAttribute.getEAttributeType().getName().equals("EByte") || eAttribute.getEAttributeType().getName().equals("EByteObject")) {
            lowerBound = String.valueOf(-128);
            upperBound = String.valueOf(127);
            type = "int:";
        } else if (eAttribute.getEAttributeType().getName().equals("EShort") || eAttribute.getEAttributeType().getName().equals("EShortObject")) {
            lowerBound = String.valueOf(Short.MIN_VALUE);
            upperBound = String.valueOf(Short.MAX_VALUE);
            type = "int:";
        } else if (eAttribute.getEAttributeType().getName().equals("EChar") || eAttribute.getEAttributeType().getName().equals("ECharObject")) {
            lowerBound = String.valueOf('\u0000');
            upperBound = String.valueOf('\uffff');
            type = "int:";
        } else if (eAttribute.getEAttributeType().getName().equals("ELong") || eAttribute.getEAttributeType().getName().equals("ELongObject")) {
            lowerBound = String.valueOf(Long.MIN_VALUE);
            upperBound = String.valueOf(Long.MAX_VALUE);
            type = "int:";
        } else {
            if (!eAttribute.getEAttributeType().getName().equals("EInt") && !eAttribute.getEAttributeType().getName().equals("EIntegerObject")) return;
            if (!this.mh.isBigAlgebra()) return;
            lowerBound = String.valueOf(Integer.MIN_VALUE);
            upperBound = String.valueOf(Integer.MAX_VALUE);
            type = "int:";
        }
        String name = "constraint - " + GraphLabels.getLabelNoType((EStructuralFeature)eAttribute) + " - validValues";
        PlainGraph constraintRule = this.createRuleGraph(name);
        PlainNode attrNode = (PlainNode)constraintRule.addNode();
        PlainNode datatypeNode = (PlainNode)constraintRule.addNode();
        PlainNode lowerBoundNode = (PlainNode)constraintRule.addNode();
        PlainNode upperBoundNode = (PlainNode)constraintRule.addNode();
        PlainNode compare1Node = (PlainNode)constraintRule.addNode();
        PlainNode compare2Node = (PlainNode)constraintRule.addNode();
        PlainNode compare3Node = (PlainNode)constraintRule.addNode();
        PlainNode bool1Node = (PlainNode)constraintRule.addNode();
        PlainNode bool2Node = (PlainNode)constraintRule.addNode();
        PlainNode bool3Node = (PlainNode)constraintRule.addNode();
        PlainLabel attrLabel = PlainLabel.createLabel(GraphLabels.getLabel((EStructuralFeature)eAttribute));
        PlainLabel datatypeLabel = PlainLabel.createLabel(type);
        PlainLabel lowerBoundLabel = PlainLabel.createLabel(String.valueOf(type) + lowerBound);
        PlainLabel upperBoundLabel = PlainLabel.createLabel(String.valueOf(type) + upperBound);
        PlainLabel boolLabel = PlainLabel.createLabel("bool:");
        PlainLabel trueLabel = PlainLabel.createLabel("bool:true");
        PlainLabel valLabel = PlainLabel.createLabel("val");
        PlainLabel arg1Label = PlainLabel.createLabel("arg:0");
        PlainLabel arg2Label = PlainLabel.createLabel("arg:1");
        PlainLabel gtLabel = PlainLabel.createLabel(String.valueOf(type) + "gt");
        PlainLabel ltLabel = PlainLabel.createLabel(String.valueOf(type) + "lt");
        PlainLabel orLabel = PlainLabel.createLabel("bool:or");
        constraintRule.addEdge(attrNode, attrLabel, attrNode);
        constraintRule.addEdge(datatypeNode, datatypeLabel, datatypeNode);
        constraintRule.addEdge(lowerBoundNode, lowerBoundLabel, lowerBoundNode);
        constraintRule.addEdge(upperBoundNode, upperBoundLabel, upperBoundNode);
        constraintRule.addEdge(bool1Node, boolLabel, bool1Node);
        constraintRule.addEdge(bool2Node, boolLabel, bool2Node);
        constraintRule.addEdge(bool3Node, trueLabel, bool3Node);
        constraintRule.addEdge(attrNode, valLabel, datatypeNode);
        constraintRule.addEdge(compare1Node, arg1Label, datatypeNode);
        constraintRule.addEdge(compare1Node, arg2Label, upperBoundNode);
        constraintRule.addEdge(compare1Node, gtLabel, bool1Node);
        constraintRule.addEdge(compare2Node, arg1Label, datatypeNode);
        constraintRule.addEdge(compare2Node, arg2Label, lowerBoundNode);
        constraintRule.addEdge(compare2Node, ltLabel, bool2Node);
        constraintRule.addEdge(compare3Node, arg1Label, bool1Node);
        constraintRule.addEdge(compare3Node, arg2Label, bool2Node);
        constraintRule.addEdge(compare3Node, orLabel, bool3Node);
    }

    private void addUnchangeableConstraint(EAttribute eAttribute) {
        String targetString = GraphLabels.getLabel(eAttribute.getEAttributeType(), null);
        String defaultString = GraphLabels.getLabel(eAttribute.getEAttributeType(), eAttribute.getDefaultValue());
        if (targetString.equals("") || defaultString.equals("")) {
            return;
        }
        String name = "constraint - " + GraphLabels.getLabelNoType((EStructuralFeature)eAttribute) + " - unchangeable";
        PlainGraph constraintRule = this.createRuleGraph(name);
        PlainNode attrNode = (PlainNode)constraintRule.addNode();
        PlainNode datatypeNode = (PlainNode)constraintRule.addNode();
        PlainNode defaultValNode = (PlainNode)constraintRule.addNode();
        PlainNode compareNode = (PlainNode)constraintRule.addNode();
        PlainNode boolNode = (PlainNode)constraintRule.addNode();
        PlainLabel attrLabel = PlainLabel.createLabel(GraphLabels.getLabel((EStructuralFeature)eAttribute));
        PlainLabel datatypeLabel = PlainLabel.createLabel(GraphLabels.getLabel(eAttribute.getEAttributeType(), null));
        PlainLabel defaultValLabel = PlainLabel.createLabel(GraphLabels.getLabel(eAttribute.getEAttributeType(), eAttribute.getDefaultValue()));
        PlainLabel boolLabel = PlainLabel.createLabel("bool:false");
        PlainLabel compareLabel = PlainLabel.createLabel(datatypeLabel + "eq");
        PlainLabel valLabel = PlainLabel.createLabel("val");
        PlainLabel arg1Label = PlainLabel.createLabel("arg:0");
        PlainLabel arg2Label = PlainLabel.createLabel("arg:1");
        constraintRule.addEdge(attrNode, attrLabel, attrNode);
        constraintRule.addEdge(datatypeNode, datatypeLabel, datatypeNode);
        constraintRule.addEdge(defaultValNode, defaultValLabel, defaultValNode);
        constraintRule.addEdge(boolNode, boolLabel, boolNode);
        constraintRule.addEdge(attrNode, valLabel, datatypeNode);
        constraintRule.addEdge(compareNode, arg1Label, datatypeNode);
        constraintRule.addEdge(compareNode, arg2Label, defaultValNode);
        constraintRule.addEdge(compareNode, compareLabel, boolNode);
    }

    private void addOppositeConstraint(EReference eReference) {
        String name = "constraint - " + GraphLabels.getLabelNoType((EStructuralFeature)eReference) + " - opposite";
        PlainGraph constraintRule = this.createRuleGraph(name);
        PlainNode refNode = (PlainNode)constraintRule.addNode();
        PlainLabel refLabel = PlainLabel.createLabel(GraphLabels.getLabel((EStructuralFeature)eReference));
        PlainLabel regExprLabel = PlainLabel.createLabel("path:!opposite.opposite");
        constraintRule.addEdge(refNode, refLabel, refNode);
        constraintRule.addEdge(refNode, regExprLabel, refNode);
        name = "constraint - " + GraphLabels.getLabelNoType((EStructuralFeature)eReference) + " - not two opposite";
        constraintRule = this.createRuleGraph(name);
        refNode = (PlainNode)constraintRule.addNode();
        PlainNode erefNode1 = (PlainNode)constraintRule.addNode();
        PlainNode erefNode2 = (PlainNode)constraintRule.addNode();
        EReference opposite = eReference.getEOpposite();
        PlainLabel oppositeLabel = PlainLabel.createLabel("opposite");
        PlainLabel erefLabel = PlainLabel.createLabel(GraphLabels.getLabel((EStructuralFeature)opposite));
        PlainLabel unequalLabel = PlainLabel.createLabel("!=");
        constraintRule.addEdge(refNode, refLabel, refNode);
        constraintRule.addEdge(erefNode1, erefLabel, erefNode1);
        constraintRule.addEdge(erefNode2, erefLabel, erefNode2);
        constraintRule.addEdge(refNode, oppositeLabel, erefNode1);
        constraintRule.addEdge(refNode, oppositeLabel, erefNode2);
        constraintRule.addEdge(erefNode1, unequalLabel, erefNode2);
    }

    private void addLowerBoundConstraint(EStructuralFeature eFeature) {
        int lowerBound = eFeature.getLowerBound();
        String name = "constraint - " + GraphLabels.getLabelNoType(eFeature) + " - lowerBound";
        PlainGraph constraintRule = this.createRuleGraph(name);
        PlainNode sourceNode = (PlainNode)constraintRule.addNode();
        Vector<PlainNode> featureNodes = new Vector<PlainNode>();
        PlainLabel sourceLabel = PlainLabel.createLabel(GraphLabels.getLabel((EClassifier)eFeature.getEContainingClass()));
        PlainLabel featureLabel = PlainLabel.createLabel(GraphLabels.getLabel(eFeature));
        PlainLabel nameLabel = PlainLabel.createLabel(eFeature.getName());
        PlainLabel unequalLabel = PlainLabel.createLabel("!=");
        PlainLabel notLabel = PlainLabel.createLabel("not:");
        constraintRule.addEdge(sourceNode, sourceLabel, sourceNode);
        int i = 0;
        while (i < lowerBound) {
            PlainNode featureNode = (PlainNode)constraintRule.addNode();
            constraintRule.addEdge(featureNode, featureLabel, featureNode);
            constraintRule.addEdge(featureNode, notLabel, featureNode);
            constraintRule.addEdge(sourceNode, nameLabel, featureNode);
            featureNodes.add(featureNode);
            ++i;
        }
        i = 0;
        while (i < lowerBound - 1) {
            int j = i + 1;
            while (j < lowerBound) {
                constraintRule.addEdge((PlainNode)featureNodes.get(i), unequalLabel, (PlainNode)featureNodes.get(j));
                ++j;
            }
            ++i;
        }
    }

    private void addUpperBoundConstraint(EStructuralFeature eFeature) {
        int upperBound = eFeature.getUpperBound();
        if (upperBound == -1) {
            return;
        }
        String name = "constraint - " + GraphLabels.getLabelNoType(eFeature) + " - upperBound";
        PlainGraph constraintRule = this.createRuleGraph(name);
        PlainNode sourceNode = (PlainNode)constraintRule.addNode();
        Vector<PlainNode> featureNodes = new Vector<PlainNode>();
        PlainLabel sourceLabel = PlainLabel.createLabel(GraphLabels.getLabel((EClassifier)eFeature.getEContainingClass()));
        PlainLabel featureLabel = PlainLabel.createLabel(GraphLabels.getLabel(eFeature));
        PlainLabel nameLabel = PlainLabel.createLabel(eFeature.getName());
        PlainLabel unequalLabel = PlainLabel.createLabel("!=");
        constraintRule.addEdge(sourceNode, sourceLabel, sourceNode);
        int i = 0;
        while (i < upperBound + 1) {
            PlainNode featureNode = (PlainNode)constraintRule.addNode();
            constraintRule.addEdge(featureNode, featureLabel, featureNode);
            constraintRule.addEdge(sourceNode, nameLabel, featureNode);
            featureNodes.add(featureNode);
            ++i;
        }
        i = 0;
        while (i < upperBound) {
            int j = i + 1;
            while (j < upperBound + 1) {
                constraintRule.addEdge((PlainNode)featureNodes.get(i), unequalLabel, (PlainNode)featureNodes.get(j));
                ++j;
            }
            ++i;
        }
    }

    private void addUniqueAttrConstraint(EAttribute eAttribute) {
        if (eAttribute.getEAttributeType().eClass().getName().equals("EEnum")) {
            this.addUniqueEnumAttrConstraint(eAttribute);
            return;
        }
        String targetString = GraphLabels.getLabel(eAttribute.getEAttributeType(), null);
        if (targetString.equals("")) {
            return;
        }
        String name = "constraint - " + GraphLabels.getLabelNoType((EStructuralFeature)eAttribute) + " - unique";
        PlainGraph constraintRule = this.createRuleGraph(name);
        PlainNode sourceNode = (PlainNode)constraintRule.addNode();
        PlainNode targetNode = (PlainNode)constraintRule.addNode();
        PlainNode refNode1 = (PlainNode)constraintRule.addNode();
        PlainNode refNode2 = (PlainNode)constraintRule.addNode();
        PlainLabel sourceLabel = PlainLabel.createLabel(GraphLabels.getLabel((EClassifier)eAttribute.getEContainingClass()));
        PlainLabel refLabel = PlainLabel.createLabel(GraphLabels.getLabel((EStructuralFeature)eAttribute));
        PlainLabel targetLabel = PlainLabel.createLabel(targetString);
        PlainLabel unequalLabel = PlainLabel.createLabel("!=");
        PlainLabel valLabel = PlainLabel.createLabel("val");
        PlainLabel nameLabel = PlainLabel.createLabel(eAttribute.getName());
        constraintRule.addEdge(sourceNode, sourceLabel, sourceNode);
        constraintRule.addEdge(refNode1, refLabel, refNode1);
        constraintRule.addEdge(refNode2, refLabel, refNode2);
        constraintRule.addEdge(targetNode, targetLabel, targetNode);
        constraintRule.addEdge(sourceNode, nameLabel, refNode1);
        constraintRule.addEdge(sourceNode, nameLabel, refNode2);
        constraintRule.addEdge(refNode1, unequalLabel, refNode2);
        constraintRule.addEdge(refNode1, valLabel, targetNode);
        constraintRule.addEdge(refNode2, valLabel, targetNode);
    }

    private void addUniqueEnumAttrConstraint(EAttribute eAttribute) {
        String name = "constraint - " + GraphLabels.getLabelNoType((EStructuralFeature)eAttribute) + " - unique";
        PlainGraph constraintRule = this.createRuleGraph(name);
        PlainNode sourceNode = (PlainNode)constraintRule.addNode();
        PlainNode attrNode1 = (PlainNode)constraintRule.addNode();
        PlainNode attrNode2 = (PlainNode)constraintRule.addNode();
        PlainNode targetNode1 = (PlainNode)constraintRule.addNode();
        PlainNode targetNode2 = (PlainNode)constraintRule.addNode();
        PlainLabel sourceLabel = PlainLabel.createLabel(GraphLabels.getLabel((EClassifier)eAttribute.getEContainingClass()));
        PlainLabel attrLabel = PlainLabel.createLabel(GraphLabels.getLabel((EStructuralFeature)eAttribute));
        PlainLabel targetLabel = PlainLabel.createLabel(GraphLabels.getLabel((EEnum)eAttribute.getEAttributeType()));
        PlainLabel unequalLabel = PlainLabel.createLabel("!=");
        PlainLabel valLabel = PlainLabel.createLabel("val");
        PlainLabel nameLabel = PlainLabel.createLabel(eAttribute.getName());
        PlainLabel matchLabel = PlainLabel.createLabel("flag:?x");
        PlainLabel lookLabel = PlainLabel.createLabel("flag:?x");
        constraintRule.addEdge(sourceNode, sourceLabel, sourceNode);
        constraintRule.addEdge(attrNode1, attrLabel, attrNode1);
        constraintRule.addEdge(attrNode2, attrLabel, attrNode2);
        constraintRule.addEdge(targetNode1, targetLabel, targetNode1);
        constraintRule.addEdge(targetNode2, targetLabel, targetNode2);
        constraintRule.addEdge(attrNode1, unequalLabel, attrNode2);
        constraintRule.addEdge(sourceNode, nameLabel, attrNode1);
        constraintRule.addEdge(sourceNode, nameLabel, attrNode2);
        constraintRule.addEdge(attrNode1, valLabel, targetNode1);
        constraintRule.addEdge(attrNode2, valLabel, targetNode2);
        constraintRule.addEdge(targetNode1, lookLabel, targetNode1);
        constraintRule.addEdge(targetNode2, matchLabel, targetNode2);
    }

    private void addUniqueRefConstraint(EReference eReference) {
        String name = "constraint - " + GraphLabels.getLabelNoType((EStructuralFeature)eReference) + " - unique";
        PlainGraph constraintRule = this.createRuleGraph(name);
        PlainNode sourceNode = (PlainNode)constraintRule.addNode();
        PlainNode targetNode = (PlainNode)constraintRule.addNode();
        PlainNode refNode1 = (PlainNode)constraintRule.addNode();
        PlainNode refNode2 = (PlainNode)constraintRule.addNode();
        PlainLabel sourceLabel = PlainLabel.createLabel(GraphLabels.getLabel((EClassifier)eReference.getEContainingClass()));
        PlainLabel refLabel = PlainLabel.createLabel(GraphLabels.getLabel((EStructuralFeature)eReference));
        PlainLabel targetLabel = PlainLabel.createLabel(GraphLabels.getLabel((EClassifier)eReference.getEReferenceType()));
        PlainLabel unequalLabel = PlainLabel.createLabel("!=");
        PlainLabel valLabel = PlainLabel.createLabel("val");
        PlainLabel nameLabel = PlainLabel.createLabel(eReference.getName());
        constraintRule.addEdge(sourceNode, sourceLabel, sourceNode);
        constraintRule.addEdge(targetNode, targetLabel, targetNode);
        constraintRule.addEdge(refNode1, refLabel, refNode1);
        constraintRule.addEdge(refNode2, refLabel, refNode2);
        constraintRule.addEdge(sourceNode, nameLabel, refNode1);
        constraintRule.addEdge(sourceNode, nameLabel, refNode2);
        constraintRule.addEdge(refNode1, valLabel, targetNode);
        constraintRule.addEdge(refNode2, valLabel, targetNode);
        constraintRule.addEdge(refNode1, unequalLabel, refNode2);
    }

    private void addNoContainerConstraint(EStructuralFeature eStructuralFeature) {
        String name = "constraint - " + GraphLabels.getLabelNoType(eStructuralFeature) + " - noContainer";
        PlainGraph constraintRule = this.createRuleGraph(name);
        PlainNode featureNode = (PlainNode)constraintRule.addNode();
        PlainNode containerNode = (PlainNode)constraintRule.addNode();
        PlainLabel featureLabel = PlainLabel.createLabel(GraphLabels.getLabel(eStructuralFeature));
        PlainLabel containerLabel = PlainLabel.createLabel(GraphLabels.getLabel((EClassifier)eStructuralFeature.getEContainingClass()));
        PlainLabel notLabel = PlainLabel.createLabel("not:");
        PlainLabel nameLabel = PlainLabel.createLabel(eStructuralFeature.getName());
        constraintRule.addEdge(featureNode, featureLabel, featureNode);
        constraintRule.addEdge(containerNode, containerLabel, containerNode);
        constraintRule.addEdge(containerNode, notLabel, containerNode);
        constraintRule.addEdge(containerNode, nameLabel, featureNode);
    }

    private void addManyContainerConstraint(EStructuralFeature eStructuralFeature) {
        String name = "constraint - " + GraphLabels.getLabelNoType(eStructuralFeature) + " - manyContainers";
        PlainGraph constraintRule = this.createRuleGraph(name);
        PlainNode featureNode = (PlainNode)constraintRule.addNode();
        PlainNode containerNode1 = (PlainNode)constraintRule.addNode();
        PlainNode containerNode2 = (PlainNode)constraintRule.addNode();
        PlainLabel featureLabel = PlainLabel.createLabel(GraphLabels.getLabel(eStructuralFeature));
        PlainLabel containerLabel = PlainLabel.createLabel(GraphLabels.getLabel((EClassifier)eStructuralFeature.getEContainingClass()));
        PlainLabel nameLabel = PlainLabel.createLabel(eStructuralFeature.getName());
        PlainLabel unequalLabel = PlainLabel.createLabel("!=");
        constraintRule.addEdge(featureNode, featureLabel, featureNode);
        constraintRule.addEdge(containerNode1, containerLabel, containerNode1);
        constraintRule.addEdge(containerNode2, containerLabel, containerNode2);
        constraintRule.addEdge(containerNode1, nameLabel, featureNode);
        constraintRule.addEdge(containerNode2, nameLabel, featureNode);
        constraintRule.addEdge(containerNode1, unequalLabel, containerNode2);
    }

    private void addNoValConstraint(EStructuralFeature eStructuralFeature) {
        String name = "constraint - " + GraphLabels.getLabelNoType(eStructuralFeature) + " - noVal";
        PlainGraph constraintRule = this.createRuleGraph(name);
        PlainNode featureNode = (PlainNode)constraintRule.addNode();
        PlainNode targetNode = (PlainNode)constraintRule.addNode();
        PlainLabel featureLabel = PlainLabel.createLabel(GraphLabels.getLabel(eStructuralFeature));
        PlainLabel targetLabel = PlainLabel.createLabel(GraphLabels.getLabel(eStructuralFeature.getEType()));
        PlainLabel notLabel = PlainLabel.createLabel("not:");
        PlainLabel valLabel = PlainLabel.createLabel("val");
        constraintRule.addEdge(featureNode, featureLabel, featureNode);
        constraintRule.addEdge(targetNode, targetLabel, targetNode);
        constraintRule.addEdge(targetNode, notLabel, targetNode);
        constraintRule.addEdge(featureNode, valLabel, targetNode);
    }

    private void addManyValConstraint(EStructuralFeature eStructuralFeature) {
        String targetString;
        if (eStructuralFeature instanceof EAttribute) {
            targetString = GraphLabels.getLabel(((EAttribute)eStructuralFeature).getEAttributeType());
            if (targetString.equals("")) {
                return;
            }
        } else {
            targetString = GraphLabels.getLabel(eStructuralFeature.getEType());
        }
        String name = "constraint - " + GraphLabels.getLabelNoType(eStructuralFeature) + " - manyVals";
        PlainGraph constraintRule = this.createRuleGraph(name);
        PlainNode featureNode = (PlainNode)constraintRule.addNode();
        PlainNode targetNode1 = (PlainNode)constraintRule.addNode();
        PlainNode targetNode2 = (PlainNode)constraintRule.addNode();
        PlainLabel featureLabel = PlainLabel.createLabel(GraphLabels.getLabel(eStructuralFeature));
        PlainLabel targetLabel = PlainLabel.createLabel(targetString);
        PlainLabel valLabel = PlainLabel.createLabel("val");
        PlainLabel unequalLabel = PlainLabel.createLabel("!=");
        constraintRule.addEdge(featureNode, featureLabel, featureNode);
        constraintRule.addEdge(targetNode1, targetLabel, targetNode1);
        constraintRule.addEdge(targetNode2, targetLabel, targetNode2);
        constraintRule.addEdge(featureNode, valLabel, targetNode1);
        constraintRule.addEdge(featureNode, valLabel, targetNode2);
        constraintRule.addEdge(targetNode1, unequalLabel, targetNode2);
    }

    private void addNoIncValConstraint(EEnum eEnum) {
        String name = "constraint - " + GraphLabels.getLabelNoType(eEnum) + " - noIncVal";
        PlainGraph constraintRule = this.createRuleGraph(name);
        PlainNode enumNode = (PlainNode)constraintRule.addNode();
        PlainNode attrNode = (PlainNode)constraintRule.addNode();
        PlainLabel enumLabel = PlainLabel.createLabel(GraphLabels.getLabel(eEnum));
        PlainLabel attrLabel = PlainLabel.createLabel(this.mh.getEAttributeType());
        PlainLabel valLabel = PlainLabel.createLabel("val");
        PlainLabel notLabel = PlainLabel.createLabel("not:");
        constraintRule.addEdge(enumNode, enumLabel, enumNode);
        constraintRule.addEdge(attrNode, attrLabel, attrNode);
        constraintRule.addEdge(attrNode, notLabel, attrNode);
        constraintRule.addEdge(attrNode, valLabel, enumNode);
    }

    private void addManyIncValConstraint(EEnum eEnum) {
        String name = "constraint - " + GraphLabels.getLabelNoType(eEnum) + " - manyIncVal";
        PlainGraph constraintRule = this.createRuleGraph(name);
        PlainNode enumNode = (PlainNode)constraintRule.addNode();
        PlainNode attrNode1 = (PlainNode)constraintRule.addNode();
        PlainNode attrNode2 = (PlainNode)constraintRule.addNode();
        PlainLabel enumLabel = PlainLabel.createLabel(GraphLabels.getLabel(eEnum));
        PlainLabel attrLabel = PlainLabel.createLabel(this.mh.getEAttributeType());
        PlainLabel unequalLabel = PlainLabel.createLabel("!=");
        PlainLabel regExprLabel = PlainLabel.createLabel("path:val." + GraphLabels.getLabel(eEnum));
        constraintRule.addEdge(enumNode, enumLabel, enumNode);
        constraintRule.addEdge(attrNode1, attrLabel, attrNode1);
        constraintRule.addEdge(attrNode2, attrLabel, attrNode2);
        constraintRule.addEdge(attrNode1, unequalLabel, attrNode2);
        constraintRule.addEdge(attrNode1, regExprLabel, enumNode);
        constraintRule.addEdge(attrNode2, regExprLabel, enumNode);
    }

    private void addNoLiteralsConstraint(EEnum eEnum) {
        String name = "constraint - " + GraphLabels.getLabelNoType(eEnum) + " - noLiteral";
        PlainGraph constraintRule = this.createRuleGraph(name);
        PlainNode node = this.addEnumNode(constraintRule, eEnum);
        for (EEnumLiteral eEnumLiteral : eEnum.getELiterals()) {
            String labelText = GraphLabels.getLabel(eEnumLiteral);
            constraintRule.addEdge(node, "not:" + labelText, node);
        }
    }

    private void addManyLiteralsConstraint(EEnum eEnum) {
        if (eEnum.getELiterals().size() > 1) {
            String name = "constraint - " + GraphLabels.getLabelNoType(eEnum) + " - manyLiterals";
            PlainGraph constraintRule = this.createRuleGraph(name);
            PlainNode node = this.addEnumNode(constraintRule, eEnum);
            StringBuilder regExpr = new StringBuilder();
            EList literals = eEnum.getELiterals();
            int i = 0;
            while (i < literals.size() - 1) {
                regExpr.append(String.valueOf(GraphLabels.getLabel((EEnumLiteral)literals.get(i))) + ".(");
                int j = i + 1;
                while (j < literals.size()) {
                    regExpr.append(GraphLabels.getLabel((EEnumLiteral)literals.get(j)));
                    if (j < literals.size() - 1) {
                        regExpr.append("|");
                    }
                    ++j;
                }
                regExpr.append(")");
                if (i < literals.size() - 2) {
                    regExpr.append("|");
                }
                ++i;
            }
            String regExprStr = "path:" + regExpr.toString();
            constraintRule.addEdge(node, regExprStr, node);
        }
    }

    private void addAbstractConstraint(EClass eClass) {
        String name = "constraint - " + GraphLabels.getLabelNoType((EClassifier)eClass) + " - abstract";
        PlainGraph constraintRule = this.createRuleGraph(name);
        PlainNode node = this.addClassNode(constraintRule, eClass);
        for (EClass otherClass : this.mh.getEClasses()) {
            if (!eClass.isSuperTypeOf(otherClass) || eClass.equals(otherClass)) continue;
            String subClassLabel = "not:" + GraphLabels.getLabel((EClassifier)otherClass);
            constraintRule.addEdge(node, subClassLabel, node);
        }
    }

    private PlainNode addClassNode(PlainGraph constraintRule, EClass eClass) {
        PlainNode node = (PlainNode)constraintRule.addNode();
        constraintRule.addEdge(node, GraphLabels.getLabel((EClassifier)eClass), node);
        return node;
    }

    private PlainNode addEnumNode(PlainGraph constraintRule, EEnum eEnum) {
        PlainNode node = (PlainNode)constraintRule.addNode();
        constraintRule.addEdge(node, GraphLabels.getLabel(eEnum), node);
        return node;
    }

    private void addEnumCheck(PlainGraph constraintRule, EAttribute eAttribute, PlainNode node1, PlainNode node2) {
        PlainLabel attrLabel = PlainLabel.createLabel(GraphLabels.getLabel((EStructuralFeature)eAttribute));
        PlainLabel attrNameLabel = PlainLabel.createLabel(eAttribute.getName());
        PlainLabel enumLabel = PlainLabel.createLabel(GraphLabels.getLabel((EEnum)eAttribute.getEAttributeType()));
        PlainLabel valLabel = PlainLabel.createLabel("val");
        PlainNode attrA1Node = (PlainNode)constraintRule.addNode();
        PlainNode attrA2Node = (PlainNode)constraintRule.addNode();
        PlainNode attrB1Node = (PlainNode)constraintRule.addNode();
        PlainNode attrB2Node = (PlainNode)constraintRule.addNode();
        PlainNode enumA1Node = (PlainNode)constraintRule.addNode();
        PlainNode enumA2Node = (PlainNode)constraintRule.addNode();
        PlainNode enumB1Node = (PlainNode)constraintRule.addNode();
        PlainNode enumB2Node = (PlainNode)constraintRule.addNode();
        PlainNode forallANode = (PlainNode)constraintRule.addNode();
        PlainNode forallBNode = (PlainNode)constraintRule.addNode();
        PlainNode existsANode = (PlainNode)constraintRule.addNode();
        PlainNode existsBNode = (PlainNode)constraintRule.addNode();
        PlainLabel wildcardALabel = PlainLabel.createLabel("flag:?" + eAttribute.getName() + "_A");
        PlainLabel wildcardBLabel = PlainLabel.createLabel("flag:?" + eAttribute.getName() + "_B");
        PlainLabel atLabel = PlainLabel.createLabel("at");
        PlainLabel inLabel = PlainLabel.createLabel("in");
        PlainLabel forallLabel = PlainLabel.createLabel("forall:");
        PlainLabel existsLabel = PlainLabel.createLabel("exists:");
        constraintRule.addEdge(attrA1Node, attrLabel, attrA1Node);
        constraintRule.addEdge(attrA2Node, attrLabel, attrA2Node);
        constraintRule.addEdge(attrB1Node, attrLabel, attrB1Node);
        constraintRule.addEdge(attrB2Node, attrLabel, attrB2Node);
        constraintRule.addEdge(enumA1Node, enumLabel, enumA1Node);
        constraintRule.addEdge(enumA2Node, enumLabel, enumA2Node);
        constraintRule.addEdge(enumB1Node, enumLabel, enumB1Node);
        constraintRule.addEdge(enumB2Node, enumLabel, enumB2Node);
        constraintRule.addEdge(enumA1Node, wildcardALabel, enumA1Node);
        constraintRule.addEdge(enumA2Node, wildcardALabel, enumA2Node);
        constraintRule.addEdge(enumB1Node, wildcardBLabel, enumB1Node);
        constraintRule.addEdge(enumB2Node, wildcardBLabel, enumB2Node);
        constraintRule.addEdge(forallANode, forallLabel, forallANode);
        constraintRule.addEdge(forallBNode, forallLabel, forallBNode);
        constraintRule.addEdge(existsANode, existsLabel, existsANode);
        constraintRule.addEdge(existsBNode, existsLabel, existsBNode);
        constraintRule.addEdge(node1, attrNameLabel, attrA1Node);
        constraintRule.addEdge(node1, attrNameLabel, attrB2Node);
        constraintRule.addEdge(node2, attrNameLabel, attrA2Node);
        constraintRule.addEdge(node2, attrNameLabel, attrB1Node);
        constraintRule.addEdge(attrA1Node, valLabel, enumA1Node);
        constraintRule.addEdge(attrA2Node, valLabel, enumA2Node);
        constraintRule.addEdge(attrB1Node, valLabel, enumB1Node);
        constraintRule.addEdge(attrB2Node, valLabel, enumB2Node);
        constraintRule.addEdge(attrA1Node, atLabel, forallANode);
        constraintRule.addEdge(enumA1Node, atLabel, forallANode);
        constraintRule.addEdge(enumA2Node, atLabel, existsANode);
        constraintRule.addEdge(existsANode, inLabel, forallANode);
        constraintRule.addEdge(attrA2Node, atLabel, existsANode);
        constraintRule.addEdge(attrB1Node, atLabel, forallBNode);
        constraintRule.addEdge(enumB1Node, atLabel, forallBNode);
        constraintRule.addEdge(enumB2Node, atLabel, existsBNode);
        constraintRule.addEdge(existsBNode, inLabel, forallBNode);
        constraintRule.addEdge(attrB2Node, atLabel, existsBNode);
    }

    void addDataTypeCheck(PlainGraph constraintRule, EAttribute eAttribute, PlainNode node1, PlainNode node2) {
        String datatypeString = GraphLabels.getLabel(eAttribute.getEAttributeType(), null);
        PlainLabel dataTypeLabel = PlainLabel.createLabel(datatypeString);
        PlainLabel attrLabel = PlainLabel.createLabel(GraphLabels.getLabel((EStructuralFeature)eAttribute));
        PlainLabel attrNameLabel = PlainLabel.createLabel(eAttribute.getName());
        PlainLabel valLabel = PlainLabel.createLabel("val");
        PlainNode attrA1Node = (PlainNode)constraintRule.addNode();
        PlainNode attrA2Node = (PlainNode)constraintRule.addNode();
        PlainNode attrB1Node = (PlainNode)constraintRule.addNode();
        PlainNode attrB2Node = (PlainNode)constraintRule.addNode();
        PlainNode dataTypeANode = (PlainNode)constraintRule.addNode();
        PlainNode dataTypeBNode = (PlainNode)constraintRule.addNode();
        PlainNode forallANode = (PlainNode)constraintRule.addNode();
        PlainNode forallBNode = (PlainNode)constraintRule.addNode();
        PlainNode existsANode = (PlainNode)constraintRule.addNode();
        PlainNode existsBNode = (PlainNode)constraintRule.addNode();
        PlainLabel atLabel = PlainLabel.createLabel("at");
        PlainLabel inLabel = PlainLabel.createLabel("in");
        PlainLabel forallLabel = PlainLabel.createLabel("forall:");
        PlainLabel existsLabel = PlainLabel.createLabel("exists:");
        constraintRule.addEdge(attrA1Node, attrLabel, attrA1Node);
        constraintRule.addEdge(attrA2Node, attrLabel, attrA2Node);
        constraintRule.addEdge(attrB1Node, attrLabel, attrB1Node);
        constraintRule.addEdge(attrB2Node, attrLabel, attrB2Node);
        constraintRule.addEdge(dataTypeANode, dataTypeLabel, dataTypeANode);
        constraintRule.addEdge(dataTypeBNode, dataTypeLabel, dataTypeBNode);
        constraintRule.addEdge(forallANode, forallLabel, forallANode);
        constraintRule.addEdge(forallBNode, forallLabel, forallBNode);
        constraintRule.addEdge(existsANode, existsLabel, existsANode);
        constraintRule.addEdge(existsBNode, existsLabel, existsBNode);
        constraintRule.addEdge(node1, attrNameLabel, attrA1Node);
        constraintRule.addEdge(node1, attrNameLabel, attrB2Node);
        constraintRule.addEdge(node2, attrNameLabel, attrA2Node);
        constraintRule.addEdge(node2, attrNameLabel, attrB1Node);
        constraintRule.addEdge(attrA1Node, valLabel, dataTypeANode);
        constraintRule.addEdge(attrA2Node, valLabel, dataTypeANode);
        constraintRule.addEdge(attrB1Node, valLabel, dataTypeBNode);
        constraintRule.addEdge(attrB2Node, valLabel, dataTypeBNode);
        constraintRule.addEdge(attrA1Node, atLabel, forallANode);
        constraintRule.addEdge(dataTypeANode, atLabel, forallANode);
        constraintRule.addEdge(existsANode, inLabel, forallANode);
        constraintRule.addEdge(attrA2Node, atLabel, existsANode);
        constraintRule.addEdge(attrB1Node, atLabel, forallBNode);
        constraintRule.addEdge(dataTypeBNode, atLabel, forallBNode);
        constraintRule.addEdge(existsBNode, inLabel, forallBNode);
        constraintRule.addEdge(attrB2Node, atLabel, existsBNode);
    }

    public List<PlainGraph> getConstraints() {
        return this.constraintRules;
    }

    private PlainGraph createRuleGraph(String name) {
        PlainGraph result = new PlainGraph(name);
        result.setRole(GraphRole.RULE);
        this.constraintRules.add(result);
        return result;
    }
}

