/*
 * Decompiled with CFR 0.152.
 */
package groove.io.ecore2groove;

import groove.grammar.aspect.AspectKind;
import groove.graph.EdgeRole;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;

public class GraphLabels {
    private static final String DOLLAR = "$";
    private static final String BOOL_PREFIX = AspectKind.BOOL.getPrefix();
    private static final String INT_PREFIX = AspectKind.INT.getPrefix();
    private static final String REAL_PREFIX = AspectKind.REAL.getPrefix();
    private static final String STRING_PREFIX = AspectKind.STRING.getPrefix();
    private static final String FLAG_PREFIX = EdgeRole.FLAG.getPrefix();
    private static final String TYPE_PREFIX = EdgeRole.NODE_TYPE.getPrefix();
    private static final Set<String> boolTypes = new HashSet<String>();
    private static final Set<String> intTypes = new HashSet<String>();
    private static final Set<String> realTypes = new HashSet<String>();
    private static final Set<String> stringTypes = new HashSet<String>();

    static {
        boolTypes.add("boolean");
        boolTypes.add("java.lang.Boolean");
        intTypes.add("int");
        intTypes.add("byte");
        intTypes.add("short");
        intTypes.add("long");
        intTypes.add("java.lang.Integer");
        intTypes.add("java.lang.Byte");
        intTypes.add("java.lang.Short");
        intTypes.add("java.lang.Long");
        intTypes.add("java.math.BigInteger");
        realTypes.add("float");
        realTypes.add("double");
        realTypes.add("java.lang.Float");
        realTypes.add("java.lang.Double");
        realTypes.add("java.math.BigDecimal");
        stringTypes.add("char");
        stringTypes.add("byte[]");
        stringTypes.add("java.lang.String");
        stringTypes.add("java.lang.Character");
        stringTypes.add("java.util.Date");
    }

    public static String getLabel(EClassifier classifier) {
        if (GraphLabels.isRootEPackage(classifier.getEPackage())) {
            return String.valueOf(TYPE_PREFIX) + classifier.getName();
        }
        String label = DOLLAR + classifier.getName();
        EPackage curEPackage = classifier.getEPackage();
        while (!GraphLabels.isRootEPackage(curEPackage)) {
            label = String.valueOf(curEPackage.getName()) + DOLLAR + label;
            curEPackage = curEPackage.getESuperPackage();
        }
        return String.valueOf(TYPE_PREFIX) + label;
    }

    public static String getLabel(EStructuralFeature feature) {
        String label = GraphLabels.getLabel((EClassifier)feature.getEContainingClass());
        label = String.valueOf(label) + DOLLAR + feature.getName();
        return label;
    }

    public static String getLabel(EDataType datatype) {
        String type = datatype.getInstanceTypeName();
        String label = intTypes.contains(type) ? String.valueOf(TYPE_PREFIX) + "int" : (boolTypes.contains(type) ? String.valueOf(TYPE_PREFIX) + "bool" : (realTypes.contains(type) ? String.valueOf(TYPE_PREFIX) + "real" : (stringTypes.contains(type) ? String.valueOf(TYPE_PREFIX) + "string" : "")));
        return label;
    }

    public static String getLabel(EDataType datatype, Object value) {
        String type = datatype.getInstanceTypeName();
        String label = intTypes.contains(type) ? (value == null ? INT_PREFIX : String.valueOf(INT_PREFIX) + value.toString()) : (boolTypes.contains(type) ? (value == null ? BOOL_PREFIX : String.valueOf(BOOL_PREFIX) + value.toString()) : (realTypes.contains(type) ? (value == null ? REAL_PREFIX : String.valueOf(REAL_PREFIX) + value.toString()) : (stringTypes.contains(type) ? (value == null ? STRING_PREFIX : String.valueOf(STRING_PREFIX) + "\"" + value.toString() + "\"") : ("EEnum".equals(datatype.eClass().getName()) ? GraphLabels.getLabel((EEnum)datatype) : ""))));
        return label;
    }

    public static String getLabel(EEnum aEnum) {
        return GraphLabels.getLabel((EClassifier)aEnum);
    }

    private static boolean isRootEPackage(EPackage aPackage) {
        return aPackage.getESuperPackage() == null;
    }

    public static String getLabel(EEnumLiteral literal) {
        return String.valueOf(FLAG_PREFIX) + literal.getLiteral();
    }

    public static String getLabelNoType(EClassifier classifier) {
        if (GraphLabels.isRootEPackage(classifier.getEPackage())) {
            return classifier.getName();
        }
        String label = DOLLAR + classifier.getName();
        EPackage curEPackage = classifier.getEPackage();
        while (!GraphLabels.isRootEPackage(curEPackage)) {
            label = String.valueOf(curEPackage.getName()) + DOLLAR + label;
            curEPackage = curEPackage.getESuperPackage();
        }
        return label;
    }

    public static String getLabelNoType(EEnum aEnum) {
        return GraphLabels.getLabelNoType((EClassifier)aEnum);
    }

    public static String getLabelNoType(EStructuralFeature feature) {
        String label = GraphLabels.getLabelNoType((EClassifier)feature.getEContainingClass());
        label = String.valueOf(label) + DOLLAR + feature.getName();
        return label;
    }
}

