/*
 * Decompiled with CFR 0.152.
 */
package groove.io.ecore2groove;

import groove.io.ecore2groove.GraphLabels;
import groove.util.Groove;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Vector;
import java.util.jar.JarFile;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public class ModelHandler {
    private Resource r;
    private Resource ir;
    private ResourceSet rs;
    private EPackage metaModelRoot;
    private boolean core;
    private boolean bigAlgebra;
    private Vector<EClass> classes;
    private Vector<EEnum> enums;
    private Vector<EEnumLiteral> literals;
    private Vector<EReference> references;
    private Vector<EDataType> datatypes;
    private Vector<EAttribute> attributes;
    private boolean instanceLoaded;
    private Vector<EObject> iClasses;
    private String eClassType;
    private String eReferenceType;
    private String eAttributeType;
    private String eEnumType;

    public ModelHandler(String modelLoc) {
        EObject obj;
        block24: {
            this.r = null;
            this.ir = null;
            this.rs = null;
            this.metaModelRoot = null;
            this.core = false;
            this.bigAlgebra = false;
            this.classes = new Vector();
            this.enums = new Vector();
            this.literals = new Vector();
            this.references = new Vector();
            this.datatypes = new Vector();
            this.attributes = new Vector();
            this.instanceLoaded = false;
            this.iClasses = new Vector();
            this.eClassType = "type:EClass";
            this.eReferenceType = "type:EReference";
            this.eAttributeType = "type:EAttribute";
            this.eEnumType = "type:EEnum";
            if (modelLoc.equals("-core")) {
                this.core = true;
                modelLoc = Groove.getResource("Ecore.ecore").getFile();
            }
            this.rs = new ResourceSetImpl();
            this.rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
            try {
                if (modelLoc.contains(".jar!")) {
                    String substr = modelLoc.substring(5, modelLoc.lastIndexOf(".jar!") + 4);
                    JarFile jarFile = new JarFile(substr);
                    InputStream inputStream = jarFile.getInputStream(jarFile.getEntry("Ecore.ecore"));
                    this.r = this.rs.createResource(URI.createURI((String)substr));
                    this.r.load(inputStream, null);
                    break block24;
                }
                this.r = this.rs.createResource(URI.createURI((String)modelLoc));
                FileInputStream in = new FileInputStream(modelLoc);
                try {
                    this.r.load((InputStream)in, null);
                }
                finally {
                    in.close();
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        TreeIterator it = this.r.getAllContents();
        while (it.hasNext()) {
            obj = (EObject)it.next();
            if (!obj.eClass().getName().equals("EPackage")) continue;
            EPackage ePackage2 = (EPackage)obj;
            ePackage2 = (EPackage)obj;
            String nsURI = ePackage2.getNsURI();
            if (nsURI == null) {
                nsURI = ePackage2.getName();
                ePackage2.setNsURI(nsURI);
            }
            this.rs.getPackageRegistry().put((Object)ePackage2.getNsURI(), (Object)ePackage2);
            if (ePackage2.getESuperPackage() != null || this.metaModelRoot != null && this.metaModelRoot.eContents().size() >= ePackage2.eContents().size()) continue;
            this.metaModelRoot = ePackage2;
        }
        if (this.metaModelRoot == null) {
            System.out.println("No root EPackage found");
            System.exit(1);
        }
        it = this.metaModelRoot.eAllContents();
        while (it.hasNext()) {
            obj = (EObject)it.next();
            if (obj.eClass().getName().equals("EClass")) {
                this.classes.add((EClass)obj);
                continue;
            }
            if (obj.eClass().getName().equals("EEnum")) {
                this.enums.add((EEnum)obj);
                continue;
            }
            if (obj.eClass().getName().equals("EEnumLiteral")) {
                this.literals.add((EEnumLiteral)obj);
                continue;
            }
            if (obj.eClass().getName().equals("EReference")) {
                this.references.add((EReference)obj);
                continue;
            }
            if (!obj.eClass().getName().equals("EAttribute")) continue;
            this.attributes.add((EAttribute)obj);
            if (!"EDataType".equals(((EAttribute)obj).getEAttributeType().eClass().getName())) continue;
            this.datatypes.add(((EAttribute)obj).getEAttributeType());
            this.checkForBigAlgebra(((EAttribute)obj).getEAttributeType());
        }
        Vector<Object> elements = new Vector<Object>();
        elements.addAll(this.classes);
        elements.addAll(this.enums);
        boolean safeName = true;
        block8: do {
            safeName = true;
            for (EClassifier eClassifier : elements) {
                if (!GraphLabels.getLabel(eClassifier).equals(this.eClassType)) continue;
                safeName = false;
                this.eClassType = String.valueOf(this.eClassType) + "_";
                continue block8;
            }
        } while (!safeName);
        block10: do {
            safeName = true;
            for (EClassifier eClassifier : elements) {
                if (!GraphLabels.getLabel(eClassifier).equals(this.eReferenceType)) continue;
                safeName = false;
                this.eReferenceType = String.valueOf(this.eReferenceType) + "_";
                continue block10;
            }
        } while (!safeName);
        block12: do {
            safeName = true;
            for (EClassifier eClassifier : elements) {
                if (!GraphLabels.getLabel(eClassifier).equals(this.eAttributeType)) continue;
                safeName = false;
                this.eAttributeType = String.valueOf(this.eAttributeType) + "_";
                continue block12;
            }
        } while (!safeName);
        block14: do {
            safeName = true;
            for (EClassifier eClassifier : elements) {
                if (!GraphLabels.getLabel(eClassifier).equals(this.eEnumType)) continue;
                safeName = false;
                this.eEnumType = String.valueOf(this.eEnumType) + "_";
                continue block14;
            }
        } while (!safeName);
    }

    private void checkForBigAlgebra(EDataType eAttributeType) {
        String type = eAttributeType.getInstanceTypeName();
        if (type == null) {
            return;
        }
        if (type.equals("java.math.BigInteger") || type.equals("long") || type.equals("java.lang.Long") || type.equals("java.math.BigDecimal") || type.equals("double") || type.equals("java.lang.Double")) {
            this.bigAlgebra = true;
        }
    }

    public boolean isBigAlgebra() {
        return this.bigAlgebra;
    }

    public String getEClassType() {
        return this.eClassType;
    }

    public String getEReferenceType() {
        return this.eReferenceType;
    }

    public String getEAttributeType() {
        return this.eAttributeType;
    }

    public String getEEnumType() {
        return this.eEnumType;
    }

    public String getModelName() {
        return this.metaModelRoot.getName();
    }

    public Vector<EClass> getEClasses() {
        return this.classes;
    }

    public Vector<EEnum> getEEnums() {
        return this.enums;
    }

    public Vector<EEnumLiteral> getEEnumLiterals() {
        return this.literals;
    }

    public Vector<EReference> getEReferences() {
        return this.references;
    }

    public Vector<EAttribute> getEAttributes() {
        return this.attributes;
    }

    public Vector<EDataType> getEDataTypes() {
        return this.datatypes;
    }

    public boolean isCore() {
        return this.core;
    }

    public Vector<EObject> getiClasses() {
        if (this.instanceLoaded) {
            return this.iClasses;
        }
        return null;
    }

    public void loadInstance(String instanceLoc) {
        URI modelURI = URI.createFileURI((String)instanceLoc);
        if (this.core) {
            this.rs = new ResourceSetImpl();
            this.rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new XMIResourceFactoryImpl());
            this.ir = this.rs.getResource(modelURI, true);
            this.iClasses.clear();
            TreeIterator it = this.ir.getAllContents();
            while (it.hasNext()) {
                EObject obj = (EObject)it.next();
                if (!obj.eClass().eClass().getName().equals("EClass")) continue;
                this.iClasses.add(obj);
            }
        } else {
            this.ir = this.rs.getResource(modelURI, true);
            this.iClasses.clear();
            TreeIterator it = this.ir.getAllContents();
            while (it.hasNext()) {
                EObject obj = (EObject)it.next();
                if (!obj.eClass().eClass().getName().equals("EClass")) continue;
                this.iClasses.add(obj);
            }
        }
        this.instanceLoaded = true;
    }

    public void saveModel(Resource r, String filePath) {
        try {
            FileOutputStream out = new FileOutputStream(filePath);
            try {
                r.save((OutputStream)out, Collections.EMPTY_MAP);
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Resource createModel(String name) {
        Resource resultModel = this.rs.createResource(URI.createURI((String)name));
        return resultModel;
    }
}

