/*
 * Decompiled with CFR 0.152.
 */
package groove.io.ecore2groove;

import groove.algebra.AlgebraFamily;
import groove.grammar.GrammarProperties;
import groove.grammar.aspect.AspectGraph;
import groove.grammar.model.ResourceKind;
import groove.graph.GraphInfo;
import groove.graph.plain.PlainGraph;
import groove.io.ecore2groove.ConstraintRules;
import groove.io.ecore2groove.InstanceGraphRep;
import groove.io.ecore2groove.InstanceModelRep;
import groove.io.ecore2groove.ModelHandler;
import groove.io.ecore2groove.TypeGraphRep;
import groove.io.store.SystemStore;
import groove.io.store.SystemStoreFactory;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;

public class Transform {
    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            Transform.exitTransform();
        } else if (args[args.length - 1].endsWith(".gps")) {
            Transform.toGROOVE(args);
        } else if (args[0].endsWith(".gps") && args.length == 3) {
            Transform.toEcore(args);
        } else {
            Transform.exitTransform();
        }
    }

    private static void exitTransform() {
        System.out.println("Ecore to GROOVE converter tool.\nUsage. There are two usage modes:\n- Ecore2Groove <Ecore model> <Ecore instance models> <grammar>\n    Converts from Ecore to GROOVE. The arguments are:\n      * <Ecore model> - the Ecore model file\n      * <Ecore instance models> - any number of instances of the specified Ecore model\n      * <grammar> - the GROOVE grammar to be created, must be a directory that ends with .gps\n\n- Ecore2Groove <grammar> <Ecore model> <Ecore instance models destination>\n    Converts from GROOVE to Ecore. The arguments are:\n      * <grammar> - the GROOVE grammar to be read, must be directory that ends with .gps\n      * <Ecore model> - the Ecore model file\n      * <Ecore instance models destination> - directory where to put generated instance models");
        System.exit(1);
    }

    private static void toEcore(String[] args) throws IOException {
        long start = new Date().getTime();
        long total = new Date().getTime();
        String grammarLoc = args[0];
        String modelLoc = args[1];
        String instancesLoc = args[2];
        ModelHandler mh = new ModelHandler(modelLoc);
        System.out.println("Loaded Ecore model: " + mh.getModelName() + " (" + (new Date().getTime() - start) + " ms)");
        start = new Date().getTime();
        File f = new File(grammarLoc);
        SystemStore grammar = null;
        if (f.exists() && f.isDirectory() && f.canRead()) {
            grammar = SystemStoreFactory.newStore(f, true);
            grammar.reload();
        } else {
            System.out.println(String.valueOf(grammarLoc) + " does not exist, is not a directory or cannot be read!");
            System.exit(1);
        }
        System.out.println("Loaded or created graph grammar: " + f.getName() + " (" + (new Date().getTime() - start) + " ms)");
        File f2 = new File(instancesLoc);
        if (!f2.exists()) {
            if (!f2.mkdir()) {
                System.out.println("Could not create directory " + instancesLoc + "!");
                System.exit(1);
            }
        } else if (!f2.isDirectory() || !f2.canWrite()) {
            System.out.println(String.valueOf(instancesLoc) + " is not directory or is not writable!");
            System.exit(1);
        }
        Map<String, AspectGraph> hostMap = grammar.getGraphs(ResourceKind.HOST);
        for (String graphName : hostMap.keySet()) {
            start = new Date().getTime();
            AspectGraph instanceGraph = hostMap.get(graphName);
            InstanceModelRep im = new InstanceModelRep(mh, instanceGraph);
            mh.saveModel(im.getInstanceModel(), String.valueOf(instancesLoc) + File.separator + graphName);
            System.out.println("Created instance model: " + graphName + " (" + (new Date().getTime() - start) + " ms)");
        }
        System.out.println("\nTotal: " + (new Date().getTime() - total) + " ms");
    }

    private static void toGROOVE(String[] args) throws IOException {
        long total = new Date().getTime();
        long start = new Date().getTime();
        String modelLoc = args[0];
        ModelHandler mh = new ModelHandler(modelLoc);
        System.out.println("Loaded Ecore model: " + mh.getModelName() + " (" + (new Date().getTime() - start) + " ms)");
        start = new Date().getTime();
        String modelName = mh.getModelName();
        if (modelName.equals("EcoreTypes")) {
            modelName = String.valueOf(modelName) + "_";
        }
        TypeGraphRep tgr = new TypeGraphRep(modelName, mh);
        System.out.println("Created type graphs: " + modelName + " (" + (new Date().getTime() - start) + " ms)");
        start = new Date().getTime();
        File f = new File(args[args.length - 1]);
        SystemStore grammar = SystemStoreFactory.newStore(f, true);
        grammar.reload();
        System.out.println("Loaded or created graph grammar: " + f.getName() + " (" + (new Date().getTime() - start) + " ms)");
        AspectGraph atg = AspectGraph.newInstance(tgr.getTypeGraph());
        AspectGraph ecoreatg = AspectGraph.newInstance(tgr.getEcoreTypeGraph());
        HashSet<String> typeGraphsToDelete = new HashSet<String>();
        for (String graphName : grammar.getGraphs(ResourceKind.TYPE).keySet()) {
            typeGraphsToDelete.add(graphName);
        }
        for (String graphName : typeGraphsToDelete) {
            grammar.deleteGraphs(ResourceKind.TYPE, Collections.singleton(graphName));
        }
        grammar.putGraphs(ResourceKind.TYPE, Arrays.asList(atg, ecoreatg), false);
        GrammarProperties sp = new GrammarProperties();
        Vector<String> typeNames = new Vector<String>();
        typeNames.add(modelName);
        typeNames.add("EcoreTypes");
        sp.setActiveNames(ResourceKind.TYPE, typeNames);
        if (mh.isBigAlgebra()) {
            sp.setAlgebraFamily(AlgebraFamily.BIG);
        }
        grammar.putProperties(sp);
        HashSet<String> rulesToDelete = new HashSet<String>();
        for (String ruleName : grammar.getGraphs(ResourceKind.RULE).keySet()) {
            if (!ruleName.startsWith("constraint")) continue;
            rulesToDelete.add(ruleName);
        }
        grammar.deleteGraphs(ResourceKind.RULE, rulesToDelete);
        start = new Date().getTime();
        int number = 0;
        ConstraintRules constraints = new ConstraintRules(mh);
        System.out.println("Created constraint rules (" + (new Date().getTime() - start) + " ms)");
        start = new Date().getTime();
        HashSet<AspectGraph> rules = new HashSet<AspectGraph>();
        for (PlainGraph constraintRule : constraints.getConstraints()) {
            AspectGraph arg;
            try {
                arg = AspectGraph.newInstance(constraintRule);
            }
            catch (Exception e) {
                System.out.println("Error with: " + constraintRule.getName());
                e.printStackTrace();
                continue;
            }
            GraphInfo.setPriority(arg, 50);
            rules.add(arg);
            ++number;
        }
        grammar.putGraphs(ResourceKind.RULE, rules, true);
        System.out.println("Stored constraint rules: " + number + " (" + (new Date().getTime() - start) + " ms)");
        HashSet<AspectGraph> graphs = new HashSet<AspectGraph>();
        int i = 1;
        while (i < args.length - 1) {
            start = new Date().getTime();
            String instanceLoc = args[i];
            String instanceName = instanceLoc.substring(instanceLoc.lastIndexOf(File.separatorChar) + 1);
            mh.loadInstance(instanceLoc);
            System.out.println("Loaded instance model: " + instanceName + " (" + (new Date().getTime() - start) + " ms)");
            start = new Date().getTime();
            InstanceGraphRep igr = new InstanceGraphRep(instanceName, mh);
            System.out.println("Created instance graph: " + instanceName + " (" + (new Date().getTime() - start) + " ms)");
            AspectGraph aig = AspectGraph.newInstance(igr.getInstanceGraph());
            graphs.add(aig);
            ++i;
        }
        grammar.putGraphs(ResourceKind.HOST, graphs, true);
        System.out.println("\nTotal: " + (new Date().getTime() - total) + " ms");
    }
}

