/*
 * Decompiled with CFR 0.152.
 */
package groove.io.external;

import groove.grammar.QualName;
import groove.grammar.aspect.AspectGraph;
import groove.grammar.model.FormatException;
import groove.grammar.model.GrammarModel;
import groove.grammar.model.ResourceKind;
import groove.grammar.model.ResourceModel;
import groove.graph.GraphRole;
import groove.gui.SimulatorModel;
import groove.io.conceptual.InstanceModel;
import groove.io.conceptual.TypeModel;
import groove.io.conceptual.configuration.Config;
import groove.io.conceptual.configuration.JaxFrontDialog;
import groove.io.conceptual.graph.AbsGraph;
import groove.io.conceptual.lang.ExportException;
import groove.io.conceptual.lang.ExportableResource;
import groove.io.conceptual.lang.ImportException;
import groove.io.conceptual.lang.groove.ConstraintToGroove;
import groove.io.conceptual.lang.groove.GrammarGraph;
import groove.io.conceptual.lang.groove.GrammarVisitor;
import groove.io.conceptual.lang.groove.GrooveResource;
import groove.io.conceptual.lang.groove.GrooveUtil;
import groove.io.conceptual.lang.groove.InstanceToGroove;
import groove.io.conceptual.lang.groove.MetaToGroove;
import groove.io.conceptual.lang.groove.TypeToGroove;
import groove.io.external.AbstractFormatExporter;
import groove.io.external.Exporter;
import groove.io.external.Format;
import groove.io.external.FormatImporter;
import groove.io.external.FormatPorter;
import groove.io.external.PortException;
import groove.util.Pair;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ConceptualPorter
extends AbstractFormatExporter
implements FormatImporter {
    private final Format instanceFormat;
    private final Format typeFormat;
    private final List<Format> formats;

    protected ConceptualPorter(String formatName, String extension) {
        this(formatName, extension, extension);
    }

    protected ConceptualPorter(String formatName, String typeExtension, String instanceExtension) {
        this.instanceFormat = new Format((FormatPorter)this, String.valueOf(formatName) + " instance model", instanceExtension);
        this.typeFormat = new Format((FormatPorter)this, String.valueOf(formatName) + " type model", typeExtension);
        this.formats = Arrays.asList(this.instanceFormat, this.typeFormat);
    }

    protected Format getInstanceFormat() {
        return this.instanceFormat;
    }

    protected Format getTypeFormat() {
        return this.typeFormat;
    }

    public List<Format> getSupportedFormats() {
        return this.formats;
    }

    @Override
    public Set<FormatImporter.Resource> doImport(File file, Format format, GrammarModel grammar) throws PortException {
        Config cfg;
        Set<FormatImporter.Resource> result = null;
        Pair<TypeModel, InstanceModel> models = null;
        try {
            if (format == this.getInstanceFormat()) {
                models = this.importInstanceModel(file, grammar);
            } else if (format == this.getTypeFormat()) {
                models = this.importTypeModel(file, grammar);
            }
        }
        catch (ImportException e) {
            throw new PortException(e);
        }
        if (models != null && (cfg = this.loadConfig(grammar)) != null) {
            result = this.loadModel(cfg, models.one(), models.two());
        }
        return result;
    }

    protected abstract Pair<TypeModel, InstanceModel> importInstanceModel(File var1, GrammarModel var2) throws ImportException;

    protected abstract Pair<TypeModel, InstanceModel> importTypeModel(File var1, GrammarModel var2) throws ImportException;

    @Override
    public Set<FormatImporter.Resource> doImport(String name, InputStream stream, Format format, GrammarModel grammar) throws PortException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void doExport(File file, Format format, Exporter.Exportable exportable) throws PortException {
        boolean isHost;
        String name;
        String namespace = name = exportable.getName();
        try {
            QualName qName = new QualName(name);
            if (qName.hasParent()) {
                namespace = qName.parent();
            }
        }
        catch (FormatException e) {
            throw new PortException(e);
        }
        ResourceModel<?> model = exportable.getModel();
        GrammarModel grammar = model.getGrammar();
        Config cfg = this.loadConfig(grammar);
        if (cfg == null) {
            return;
        }
        ResourceKind kind = model.getKind();
        Pair<TypeModel, InstanceModel> outcome = null;
        switch (kind) {
            case HOST: {
                assert (format == this.getInstanceFormat());
                outcome = this.constructModels(cfg, grammar, namespace, null, name);
                break;
            }
            case RULE: {
                throw new PortException("Rules cannot be exported in this format");
            }
            case TYPE: {
                assert (format == this.getTypeFormat());
                outcome = this.constructModels(cfg, grammar, namespace, name, null);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (outcome == null) {
            return;
        }
        TypeModel tm = (TypeModel)outcome.one();
        InstanceModel im = outcome.two();
        if (tm == null) {
            throw new PortException("Unable to load type model");
        }
        boolean bl = isHost = kind == ResourceKind.HOST;
        if (isHost && im == null) {
            throw new PortException("Unable to load instance model");
        }
        try {
            this.getResource(file, isHost, tm, im).export();
        }
        catch (ExportException e) {
            throw new PortException(e);
        }
    }

    protected abstract ExportableResource getResource(File var1, boolean var2, TypeModel var3, InstanceModel var4) throws PortException;

    private Config loadConfig(GrammarModel grammar) {
        JaxFrontDialog dlg = new JaxFrontDialog(this.getSimulator());
        String cfg = dlg.getConfig();
        if (cfg != null) {
            return new Config(grammar, cfg);
        }
        return null;
    }

    private Pair<TypeModel, InstanceModel> constructModels(Config cfg, GrammarModel grammar, String namespace, String typeModel, String instanceModel) throws PortException {
        boolean success;
        GrammarVisitor visitor = new GrammarVisitor(cfg, namespace);
        visitor.setFixedType(typeModel);
        visitor.setFixedInstance(instanceModel);
        try {
            success = visitor.doVisit(this.getParent(), grammar);
        }
        catch (ImportException e) {
            throw new PortException(e);
        }
        return success ? Pair.newPair(visitor.getTypeModel(), visitor.getInstanceModel()) : null;
    }

    private Set<FormatImporter.Resource> loadModel(Config cfg, TypeModel tm, InstanceModel im) throws PortException {
        HashSet<FormatImporter.Resource> result = new HashSet<FormatImporter.Resource>();
        SimulatorModel simulatorModel = this.getSimulator() == null ? null : this.getSimulator().getModel();
        GrooveResource grooveResource = new GrooveResource(cfg, simulatorModel, "");
        if (tm != null) {
            TypeToGroove ttg = new TypeToGroove(grooveResource);
            ttg.addTypeModel(tm);
            ConstraintToGroove ctg = new ConstraintToGroove(grooveResource);
            ctg.addTypeModel(tm);
            MetaToGroove mtg = new MetaToGroove(grooveResource);
            mtg.addTypeModel(tm);
        }
        if (im != null) {
            InstanceToGroove itg = new InstanceToGroove(grooveResource);
            itg.addInstanceModel(im);
        }
        for (Map.Entry<GraphRole, HashMap<String, GrammarGraph>> entry : grooveResource.getGraphs().entrySet()) {
            GraphRole role = entry.getKey();
            ResourceKind kind = ResourceKind.toResource(role);
            for (GrammarGraph graph : entry.getValue().values()) {
                AbsGraph absGraph = graph.getGraph();
                String name = GrooveUtil.getSafeResource(graph.getGraphName());
                AspectGraph aspectGraph = absGraph.toAspectGraph(name, role);
                FormatImporter.Resource resource = new FormatImporter.Resource(kind, name, aspectGraph);
                result.add(resource);
            }
        }
        return result;
    }
}

