/*
 * Decompiled with CFR 0.152.
 */
package groove.io.external.util;

import com.itextpdf.awt.DefaultFontMapper;
import com.itextpdf.awt.FontMapper;
import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import groove.gui.jgraph.JGraph;
import groove.io.external.PortException;
import groove.io.external.util.GraphToVector;
import groove.util.Version;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class GraphToPDF
extends GraphToVector {
    @Override
    public void renderGraph(JGraph<?> graph, File file) throws PortException {
        Rectangle2D bounds = graph.getGraphBounds();
        if (bounds == null) {
            return;
        }
        Rectangle bound = new Rectangle((float)bounds.getWidth(), (float)bounds.getHeight());
        FileOutputStream fos = null;
        Document document = new Document(bound);
        PdfWriter writer = null;
        try {
            fos = new FileOutputStream(file);
            writer = PdfWriter.getInstance((Document)document, (OutputStream)fos);
        }
        catch (DocumentException e) {
            throw new PortException(e);
        }
        catch (FileNotFoundException e) {
            throw new PortException(e);
        }
        document.addCreator(Version.getAbout());
        document.open();
        PdfContentByte cb = writer.getDirectContent();
        boolean onlyShapes = true;
        PdfGraphics2D pdf2d = new PdfGraphics2D(cb, (float)bounds.getWidth(), (float)bounds.getHeight(), (FontMapper)new DefaultFontMapper(), onlyShapes, false, 100.0f);
        this.toGraphics(graph, (Graphics2D)pdf2d);
        pdf2d.dispose();
        document.close();
        try {
            fos.close();
        }
        catch (IOException e) {
            throw new PortException(e);
        }
    }
}

