/*
 * Decompiled with CFR 0.152.
 */
package groove.io.external.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class PdfDialog
extends JDialog {
    private JCheckBox m_outlineFont;
    private boolean m_dialogResult;

    public PdfDialog(JFrame owner) {
        super(owner, "Select graphs to export", true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                PdfDialog.this.close();
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PdfDialog.this.setVisible(false);
            }
        };
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().registerKeyboardAction(actionListener, stroke, 2);
        this.buildGUI();
    }

    public boolean doDialog() {
        this.m_dialogResult = false;
        this.setVisible(true);
        return this.m_dialogResult;
    }

    private void buildGUI() {
        this.m_outlineFont = new JCheckBox("Use font outlines (larger PDF, more accurate)");
        JPanel form = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(4, 4, 4, 4);
        c.fill = 2;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        form.add((Component)this.m_outlineFont, c);
        JPanel contents = new JPanel(new BorderLayout());
        contents.add((Component)form, "North");
        JButton okBtn = new JButton("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PdfDialog.this.m_dialogResult = true;
                PdfDialog.this.dispose();
            }
        });
        this.getRootPane().setDefaultButton(okBtn);
        JButton cancelBtn = new JButton("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PdfDialog.this.dispose();
            }
        });
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(okBtn);
        buttonPane.add(Box.createRigidArea(new Dimension(5, 0)));
        buttonPane.add(cancelBtn);
        contents.add((Component)buttonPane, "South");
        this.setContentPane(contents);
        this.setSize(350, 150);
    }

    public boolean useFontOutline() {
        return this.m_outlineFont.isSelected();
    }

    private void close() {
        super.dispose();
    }
}

