/*
 * Decompiled with CFR 0.152.
 */
package groove.io.store;

import groove.grammar.GrammarProperties;
import groove.grammar.QualName;
import groove.grammar.aspect.AspectGraph;
import groove.grammar.model.FormatErrorSet;
import groove.grammar.model.FormatException;
import groove.grammar.model.ResourceKind;
import groove.grammar.type.TypeLabel;
import groove.graph.Graph;
import groove.gui.Options;
import groove.io.ExtensionFilter;
import groove.io.FileType;
import groove.io.Util;
import groove.io.graph.AttrGraph;
import groove.io.graph.GxlIO;
import groove.io.store.EditType;
import groove.io.store.SystemStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

public class DefaultFileSystemStore
extends SystemStore {
    private GrammarProperties properties;
    private URL url;
    private final File file;
    private final String name;
    private final GxlIO marshaller;
    private boolean initialised;
    private boolean hasSystemPropertiesFile = false;
    private static final String LOAD_ERROR = "Can't load graph grammar";

    public DefaultFileSystemStore(File file, boolean create) throws IllegalArgumentException {
        if (!file.exists()) {
            if (create) {
                if (!file.mkdirs()) {
                    throw new IllegalArgumentException(String.format("Could not create directory '%s'", file));
                }
            } else {
                throw new IllegalArgumentException(String.format("File '%s' does not exist", file));
            }
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(String.format("File '%s' is not a directory", file));
        }
        if (!FileType.GRAMMAR_FILTER.acceptExtension(file)) {
            throw new IllegalArgumentException(String.format("File '%s' does not refer to a production system", file));
        }
        this.file = file;
        this.name = FileType.GRAMMAR_FILTER.stripExtension(this.file.getName());
        this.marshaller = GxlIO.getInstance();
        if (create) {
            this.createVersionProperties();
        }
    }

    public DefaultFileSystemStore(URL location) throws IllegalArgumentException {
        this(DefaultFileSystemStore.toFile(location), false);
        this.url = location;
    }

    private void createVersionProperties() {
        GrammarProperties prop = new GrammarProperties();
        prop.setCurrentVersionProperties();
        try {
            this.saveProperties(prop);
            this.hasSystemPropertiesFile = true;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Could not create properties file.");
        }
        prop.setShowLoopsAsLabels(false);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, String> getTexts(ResourceKind kind) {
        this.testInit();
        return Collections.unmodifiableMap(this.getTextMap(kind));
    }

    @Override
    public Map<String, String> putTexts(ResourceKind kind, Map<String, String> texts) throws IOException {
        Map<String, String> result = null;
        TextBasedEdit edit = this.doPutTexts(kind, texts);
        if (edit != null) {
            edit.checkAndSetVersion();
            this.postEdit(edit);
            result = edit.getOldTexts();
        }
        return result;
    }

    private TextBasedEdit doPutTexts(ResourceKind kind, Map<String, String> newTexts) throws IOException {
        this.testInit();
        HashMap<String, String> oldTexts = new HashMap<String, String>();
        HashSet<String> newNames = new HashSet<String>();
        for (Map.Entry<String, String> entry : newTexts.entrySet()) {
            String name = entry.getKey();
            String newText = entry.getValue();
            this.saveText(kind, name, newText);
            String oldText = this.getTextMap(kind).put(name, newText);
            if (oldText == null) {
                newNames.add(name);
                continue;
            }
            oldTexts.put(name, oldText);
        }
        GrammarProperties oldProps = this.getProperties();
        GrammarProperties newProps = this.doEnableDefaultName(kind, newNames);
        return new TextBasedEdit(kind, oldTexts.isEmpty() ? EditType.CREATE : EditType.MODIFY, oldTexts, newTexts, oldProps, newProps);
    }

    private GrammarProperties doEnableDefaultName(ResourceKind kind, Set<String> newNames) throws IOException {
        GrammarProperties result = null;
        String defaultName = kind.getDefaultName();
        if (defaultName != null && this.getProperties().getActiveNames(kind).isEmpty() && newNames.contains(defaultName)) {
            result = this.getProperties().clone();
            result.setActiveNames(kind, Collections.singleton(defaultName));
            this.doPutProperties(result);
        }
        return result;
    }

    @Override
    public Map<String, String> deleteTexts(ResourceKind kind, Collection<String> names) throws IOException {
        Map<String, String> result = null;
        TextBasedEdit deleteEdit = this.doDeleteTexts(kind, names);
        if (deleteEdit != null) {
            deleteEdit.checkAndSetVersion();
            this.postEdit(deleteEdit);
            result = deleteEdit.getOldTexts();
        }
        return result;
    }

    private TextBasedEdit doDeleteTexts(ResourceKind kind, Collection<String> names) throws IOException {
        this.testInit();
        HashMap<String, String> oldTexts = new HashMap<String, String>();
        boolean activeChanged = false;
        TreeSet<String> activeNames = new TreeSet<String>(this.getProperties().getActiveNames(kind));
        for (String name : names) {
            assert (name != null);
            String text = this.getTextMap(kind).remove(name);
            if (text == null) continue;
            oldTexts.put(name, text);
            this.createFile(kind, name).delete();
            activeChanged |= activeNames.remove(name);
        }
        GrammarProperties oldProps = null;
        GrammarProperties newProps = null;
        if (activeChanged) {
            oldProps = this.getProperties();
            newProps = this.getProperties().clone();
            newProps.setActiveNames(kind, activeNames);
            this.doPutProperties(newProps);
        }
        return new TextBasedEdit(kind, EditType.DELETE, oldTexts, Collections.<String, String>emptyMap(), oldProps, newProps);
    }

    @Override
    public void rename(ResourceKind kind, String oldName, String newName) throws IOException {
        MyEdit edit;
        MyEdit myEdit = edit = kind.isGraphBased() ? this.doRenameGraph(kind, oldName, newName) : this.doRenameText(kind, oldName, newName);
        if (edit != null) {
            edit.checkAndSetVersion();
            this.postEdit(edit);
        }
    }

    private TextBasedEdit doRenameText(ResourceKind kind, String oldName, String newName) throws IOException {
        this.testInit();
        HashMap<String, String> oldTexts = new HashMap<String, String>();
        HashMap<String, String> newTexts = new HashMap<String, String>();
        String text = this.getTextMap(kind).remove(oldName);
        assert (text != null);
        oldTexts.put(oldName, text);
        this.createFile(kind, oldName).renameTo(this.createFile(kind, newName));
        String previous = this.getTextMap(kind).put(newName, text);
        assert (previous == null);
        newTexts.put(newName, text);
        GrammarProperties oldProps = null;
        GrammarProperties newProps = null;
        TreeSet<String> activeNames = new TreeSet<String>(this.getProperties().getActiveNames(kind));
        if (activeNames.remove(oldName)) {
            oldProps = this.getProperties();
            newProps = this.getProperties().clone();
            activeNames.add(newName);
            newProps.setActiveNames(kind, activeNames);
            this.doPutProperties(newProps);
        }
        return new TextBasedEdit(kind, EditType.RENAME, oldTexts, newTexts, oldProps, newProps);
    }

    private GraphBasedEdit doRenameGraph(ResourceKind kind, String oldName, String newName) throws IOException {
        TreeSet<String> activeNames;
        this.testInit();
        AspectGraph oldGraph = this.getGraphMap(kind).remove(oldName);
        assert (oldGraph != null);
        File oldFile = this.createFile(kind, oldName);
        this.marshaller.deleteGraph(oldFile);
        AspectGraph newGraph = oldGraph.rename(newName);
        AspectGraph previous = this.getGraphMap(kind).put(newName, newGraph);
        assert (previous == null);
        this.marshaller.saveGraph((Graph)newGraph.toPlainGraph(), this.createFile(kind, newName));
        DefaultFileSystemStore.deleteEmptyDirectories(oldFile.getParentFile());
        GrammarProperties oldProps = null;
        GrammarProperties newProps = null;
        if (kind != ResourceKind.RULE && (activeNames = new TreeSet<String>(this.getProperties().getActiveNames(kind))).remove(oldName)) {
            oldProps = this.getProperties();
            newProps = oldProps.clone();
            activeNames.add(newName);
            newProps.setActiveNames(kind, activeNames);
            this.doPutProperties(newProps);
        }
        return new GraphBasedEdit(kind, EditType.RENAME, Collections.singleton(oldGraph), Collections.singleton(newGraph), oldProps, newProps);
    }

    private static void deleteEmptyDirectories(File directory) {
        if (directory == null || !directory.isDirectory()) {
            return;
        }
        if (directory.listFiles().length > 0) {
            return;
        }
        File parent = directory.getParentFile();
        directory.delete();
        DefaultFileSystemStore.deleteEmptyDirectories(parent);
    }

    @Override
    public Map<String, AspectGraph> getGraphs(ResourceKind kind) {
        this.testInit();
        return Collections.unmodifiableMap(this.getGraphMap(kind));
    }

    @Override
    public Collection<AspectGraph> putGraphs(ResourceKind kind, Collection<AspectGraph> graphs, boolean layout) throws IOException {
        Collection<AspectGraph> result = Collections.emptySet();
        GraphBasedEdit edit = this.doPutGraphs(kind, graphs, layout);
        if (edit != null) {
            edit.checkAndSetVersion();
            this.postEdit(edit);
            result = edit.getOldGraphs();
        }
        return result;
    }

    private GraphBasedEdit doPutGraphs(ResourceKind kind, Collection<AspectGraph> newGraphs, boolean layout) throws IOException {
        this.testInit();
        HashSet<String> newNames = new HashSet<String>();
        HashSet<AspectGraph> oldGraphs = new HashSet<AspectGraph>();
        for (AspectGraph newGraph : newGraphs) {
            String name = newGraph.getName();
            this.marshaller.saveGraph((Graph)newGraph.toPlainGraph(), this.createFile(kind, name));
            AspectGraph oldGraph = this.getGraphMap(kind).put(name, newGraph);
            if (oldGraph == null) {
                newNames.add(name);
                continue;
            }
            oldGraphs.add(oldGraph);
        }
        GrammarProperties oldProps = this.getProperties();
        GrammarProperties newProps = this.doEnableDefaultName(kind, newNames);
        EditType type = oldGraphs.isEmpty() ? EditType.CREATE : (layout ? EditType.LAYOUT : EditType.MODIFY);
        return new GraphBasedEdit(kind, type, oldGraphs, newGraphs, oldProps, newProps);
    }

    @Override
    public Collection<AspectGraph> deleteGraphs(ResourceKind kind, Collection<String> name) throws IOException {
        Collection<AspectGraph> result = Collections.emptySet();
        GraphBasedEdit edit = this.doDeleteGraphs(kind, name);
        if (edit != null) {
            edit.checkAndSetVersion();
            this.postEdit(edit);
            result = edit.getOldGraphs();
        }
        return result;
    }

    private GraphBasedEdit doDeleteGraphs(ResourceKind kind, Collection<String> names) throws IOException {
        this.testInit();
        ArrayList<AspectGraph> deletedGraphs = new ArrayList<AspectGraph>(names.size());
        TreeSet<String> activeNames = kind == ResourceKind.RULE ? null : new TreeSet<String>(this.getProperties().getActiveNames(kind));
        boolean activeChanged = false;
        for (String name : names) {
            AspectGraph graph = this.getGraphMap(kind).remove(name);
            assert (graph != null);
            File oldFile = this.createFile(kind, name);
            this.marshaller.deleteGraph(oldFile);
            DefaultFileSystemStore.deleteEmptyDirectories(oldFile.getParentFile());
            deletedGraphs.add(graph);
            activeChanged |= activeNames != null && activeNames.remove(name);
        }
        GrammarProperties oldProps = null;
        GrammarProperties newProps = null;
        if (activeChanged) {
            oldProps = this.getProperties();
            newProps = this.getProperties().clone();
            newProps.setActiveNames(kind, activeNames);
            this.doPutProperties(newProps);
        }
        return new GraphBasedEdit(kind, EditType.DELETE, deletedGraphs, Collections.<AspectGraph>emptySet(), oldProps, newProps);
    }

    @Override
    public GrammarProperties getProperties() {
        GrammarProperties properties = null;
        if (!this.initialised) {
            try {
                properties = this.loadGrammarProperties();
            }
            catch (IOException iOException) {}
        } else {
            properties = this.properties;
        }
        return properties;
    }

    @Override
    public void putProperties(GrammarProperties properties) throws IOException {
        PutPropertiesEdit edit = this.doPutProperties(properties);
        if (edit != null) {
            edit.checkAndSetVersion();
            this.postEdit(edit);
        }
    }

    private PutPropertiesEdit doPutProperties(GrammarProperties properties) throws IOException {
        this.testInit();
        GrammarProperties oldProperties = this.properties;
        this.properties = properties;
        this.saveProperties();
        return new PutPropertiesEdit(oldProperties, properties);
    }

    @Override
    public void relabel(TypeLabel oldLabel, TypeLabel newLabel) throws IOException {
        MyCompoundEdit edit = this.doRelabel(oldLabel, newLabel);
        if (edit != null) {
            this.postEdit(edit);
        }
    }

    private MyCompoundEdit doRelabel(TypeLabel oldLabel, TypeLabel newLabel) throws IOException {
        MyCompoundEdit result = new MyCompoundEdit("Replace Label");
        ResourceKind[] resourceKindArray = ResourceKind.values();
        int n = resourceKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceKind kind = resourceKindArray[n2];
            if (kind.isGraphBased()) {
                ArrayList<AspectGraph> newGraphs = new ArrayList<AspectGraph>(this.getGraphs(kind).size());
                for (AspectGraph graph : this.getGraphs(kind).values()) {
                    AspectGraph newGraph = graph.relabel(oldLabel, newLabel);
                    if (newGraph == graph) continue;
                    newGraphs.add(newGraph);
                }
                result.addEdit(this.doPutGraphs(kind, newGraphs, false));
            }
            ++n2;
        }
        GrammarProperties newProperties = this.properties.relabel(oldLabel, newLabel);
        if (newProperties != this.properties) {
            PutPropertiesEdit edit = this.doPutProperties(newProperties);
            result.addEdit(edit);
        }
        result.end();
        return result.getChange().isEmpty() ? null : result;
    }

    public void renumber() throws IOException {
        MyCompoundEdit edit = this.doRenumber();
        if (edit != null) {
            this.postEdit(edit);
        }
    }

    private MyCompoundEdit doRenumber() throws IOException {
        MyCompoundEdit result = new MyCompoundEdit("Renumber Nodes");
        ResourceKind[] resourceKindArray = ResourceKind.values();
        int n = resourceKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceKind kind = resourceKindArray[n2];
            if (kind.isGraphBased()) {
                ArrayList<AspectGraph> newGraphs = new ArrayList<AspectGraph>(this.getGraphs(kind).size());
                for (AspectGraph graph : this.getGraphs(kind).values()) {
                    AspectGraph newGraph = graph.renumber();
                    if (newGraph == graph) continue;
                    newGraphs.add(newGraph);
                }
                result.addEdit(this.doPutGraphs(kind, newGraphs, false));
            }
            ++n2;
        }
        result.end();
        return result.getChange().isEmpty() ? null : result;
    }

    @Override
    public void reload() throws IOException {
        ResourceKind[] resourceKindArray = ResourceKind.values();
        int n = resourceKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceKind kind = resourceKindArray[n2];
            if (kind == ResourceKind.PROPERTIES) {
                this.loadProperties();
            } else if (kind.isTextBased()) {
                this.loadTexts(kind, kind.getFilter());
            } else {
                this.loadGraphs(kind, kind.getFilter());
            }
            ++n2;
        }
        this.notifyObservers(new MyEdit(EditType.CREATE, EnumSet.allOf(ResourceKind.class)));
        this.initialised = true;
    }

    @Override
    public Object getLocation() {
        if (this.file == null) {
            return this.url;
        }
        return this.file;
    }

    @Override
    public SystemStore save(File file, boolean clearDir) throws IOException {
        return SystemStore.save(file, this, clearDir);
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    public boolean equals(Object obj) {
        return obj instanceof DefaultFileSystemStore && ((DefaultFileSystemStore)obj).getLocation().equals(this.getLocation());
    }

    public int hashCode() {
        return this.getLocation().hashCode();
    }

    @Override
    public String toString() {
        String location = this.file == null ? this.getLocation().toString() : this.file.getParent();
        return String.valueOf(this.getName()) + " - " + location;
    }

    private void loadGraphs(ResourceKind kind, ExtensionFilter filter) throws IOException {
        Map<QualName, File> files;
        this.getGraphMap(kind).clear();
        try {
            files = this.collectResources(kind, this.file, null);
        }
        catch (FormatException e) {
            throw new IOException(e.getMessage(), e);
        }
        for (Map.Entry<QualName, File> fileEntry : files.entrySet()) {
            AttrGraph xmlGraph = this.marshaller.loadGraph(fileEntry.getValue());
            xmlGraph.setRole(kind.getGraphRole());
            xmlGraph.setName(fileEntry.getKey().toString());
            AspectGraph graph = xmlGraph.toAspectGraph();
            AspectGraph oldEntry = this.getGraphMap(kind).put(fileEntry.getKey().toString(), graph);
            assert (oldEntry == null) : String.format("Duplicate %s name '%s'", new Object[]{kind.getGraphRole(), fileEntry.getKey()});
        }
    }

    private void loadTexts(ResourceKind kind, ExtensionFilter filter) throws IOException {
        Map<QualName, File> files;
        this.getTextMap(kind).clear();
        try {
            files = this.collectResources(kind, this.file, null);
        }
        catch (FormatException e) {
            throw new IOException(e.getMessage(), e);
        }
        for (Map.Entry<QualName, File> fileEntry : files.entrySet()) {
            String program = Util.readFileToString(fileEntry.getValue());
            this.getTextMap(kind).put(fileEntry.getKey().toString(), program);
        }
    }

    private Map<QualName, File> collectResources(ResourceKind kind, File path, QualName pathName) throws IOException, FormatException {
        HashMap<QualName, File> result = new HashMap<QualName, File>();
        kind.getFilter();
        File[] curfiles = path.listFiles(kind.getFilter());
        if (curfiles == null) {
            throw new IOException("Can't load graph grammar: unable to get list of files in path " + path);
        }
        FormatErrorSet errors = new FormatErrorSet();
        File[] fileArray = curfiles;
        int n = curfiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String fileName = kind.getFilter().stripExtension(file.getName());
            int separatorPos = fileName.indexOf(".");
            if (separatorPos > 0) {
                errors.add("File name %s contains separator CHARACTER '%s'", file.getPath(), ".");
            } else if (separatorPos < 0) {
                QualName qualFileName = QualName.extend(pathName, fileName);
                if (file.isDirectory()) {
                    result.putAll(this.collectResources(kind, file, qualFileName));
                } else {
                    result.put(qualFileName, file);
                }
            }
            ++n2;
        }
        errors.throwException();
        return result;
    }

    private void loadProperties() throws IOException {
        this.properties = this.loadGrammarProperties();
    }

    private GrammarProperties loadGrammarProperties() throws IOException {
        GrammarProperties properties = new GrammarProperties();
        File propertiesFile = this.getDefaultPropertiesFile();
        if (!propertiesFile.exists()) {
            propertiesFile = this.getOldDefaultPropertiesFile();
        }
        if (propertiesFile.exists()) {
            Properties grammarProperties = new Properties();
            FileInputStream s = new FileInputStream(propertiesFile);
            try {
                grammarProperties.load(s);
            }
            finally {
                ((InputStream)s).close();
            }
            properties.putAll((Map<?, ?>)grammarProperties);
            this.hasSystemPropertiesFile = true;
        } else {
            this.hasSystemPropertiesFile = false;
        }
        return properties;
    }

    private File getDefaultPropertiesFile() {
        return new File(this.file, FileType.PROPERTIES_FILTER.addExtension("system"));
    }

    private File getOldDefaultPropertiesFile() {
        return new File(this.file, FileType.PROPERTIES_FILTER.addExtension(this.name));
    }

    private void saveText(ResourceKind kind, String name, String program) throws IOException {
        File file = this.createFile(kind, name);
        FileWriter writer = new FileWriter(file);
        try {
            writer.write(program);
        }
        finally {
            ((Writer)writer).close();
        }
    }

    private void saveProperties() throws IOException {
        this.saveProperties(this.properties);
    }

    private void saveProperties(GrammarProperties properties) throws IOException {
        File propertiesFile = this.getDefaultPropertiesFile();
        FileWriter propertiesWriter = new FileWriter(propertiesFile);
        try {
            properties.store(propertiesWriter, null);
        }
        finally {
            ((Writer)propertiesWriter).close();
        }
        File oldPropertiesFile = this.getOldDefaultPropertiesFile();
        if (oldPropertiesFile.exists()) {
            oldPropertiesFile.delete();
        }
    }

    private void testInit() throws IllegalStateException {
        if (!this.initialised) {
            throw new IllegalStateException("Operation should only be called after initialisation");
        }
    }

    private File createFile(ResourceKind kind, String name) throws IOException {
        try {
            File basis = this.file;
            QualName qualName = new QualName(name);
            int i = 0;
            while (i < qualName.size() - 1) {
                basis = new File(basis, qualName.get(i));
                basis.mkdir();
                ++i;
            }
            String shortName = qualName.child();
            return new File(basis, kind.getFilter().addExtension(shortName));
        }
        catch (FormatException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public synchronized void postEdit(UndoableEdit e) {
        if (!this.isUndoSuspended()) {
            super.postEdit(e);
            this.notifyObservers((SystemStore.Edit)e);
        }
    }

    @Override
    protected boolean hasSystemProperties() {
        return this.hasSystemPropertiesFile;
    }

    private static File toFile(URL url) throws IllegalArgumentException {
        try {
            return new File(new URI(url.getProtocol(), url.getAuthority(), url.toURI().getPath(), null, null));
        }
        catch (URISyntaxException exc) {
            throw new IllegalArgumentException(String.format("URL '%s' is not formatted correctly: %s", url, exc.getMessage()));
        }
        catch (IllegalArgumentException exc) {
            throw new IllegalArgumentException(String.format("URL '%s' is not a valid file: %s", url, exc.getMessage()));
        }
    }

    private class GraphBasedEdit
    extends MyEdit {
        private final Collection<AspectGraph> oldGraphs;
        private final Collection<AspectGraph> newGraphs;
        private final GrammarProperties oldProps;
        private final GrammarProperties newProps;

        public GraphBasedEdit(ResourceKind kind, EditType type, Collection<AspectGraph> oldGraphs, Collection<AspectGraph> newGraphs, GrammarProperties oldProps, GrammarProperties newProps) {
            super(type, kind, new ResourceKind[0]);
            this.oldGraphs = oldGraphs;
            this.newGraphs = newGraphs;
            this.newProps = newProps;
            if (newProps == null) {
                this.oldProps = null;
            } else {
                this.oldProps = oldProps;
                this.addChange(ResourceKind.PROPERTIES);
            }
        }

        @Override
        public String getPresentationName() {
            String result = Options.getEditActionName(this.getType(), this.getResourceKind(), false);
            if (this.newGraphs.size() > 1 || this.oldGraphs.size() > 1) {
                result = String.valueOf(result) + "s";
            }
            return result;
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            try {
                boolean layout;
                boolean bl = layout = this.getType() == EditType.LAYOUT;
                if (!layout) {
                    DefaultFileSystemStore.this.doDeleteGraphs(this.getResourceKind(), this.getNames(this.oldGraphs));
                    if (this.newProps != null) {
                        DefaultFileSystemStore.this.doPutProperties(this.newProps);
                    }
                }
                DefaultFileSystemStore.this.doPutGraphs(this.getResourceKind(), this.newGraphs, layout);
            }
            catch (IOException iOException) {
                throw new CannotRedoException();
            }
            DefaultFileSystemStore.this.notifyObservers(this);
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            try {
                boolean layout;
                boolean bl = layout = this.getType() == EditType.LAYOUT;
                if (!layout) {
                    DefaultFileSystemStore.this.doDeleteGraphs(this.getResourceKind(), this.getNames(this.newGraphs));
                    if (this.oldProps != null) {
                        DefaultFileSystemStore.this.doPutProperties(this.oldProps);
                    }
                }
                DefaultFileSystemStore.this.doPutGraphs(this.getResourceKind(), this.oldGraphs, layout);
            }
            catch (IOException iOException) {
                throw new CannotUndoException();
            }
            DefaultFileSystemStore.this.notifyObservers(this);
        }

        public final Collection<AspectGraph> getOldGraphs() {
            return this.oldGraphs;
        }
    }

    private static class MyCompoundEdit
    extends CompoundEdit
    implements SystemStore.Edit {
        private final Set<ResourceKind> change = EnumSet.noneOf(ResourceKind.class);
        private final String presentationName;

        public MyCompoundEdit(String presentationName) {
            this.presentationName = presentationName;
        }

        @Override
        public EditType getType() {
            return EditType.MODIFY;
        }

        @Override
        public String getPresentationName() {
            return this.presentationName;
        }

        @Override
        public String getRedoPresentationName() {
            return "Redo " + this.getPresentationName();
        }

        @Override
        public String getUndoPresentationName() {
            return "Undo " + this.getPresentationName();
        }

        @Override
        public boolean addEdit(UndoableEdit anEdit) {
            boolean result = super.addEdit(anEdit);
            if (result) {
                assert (anEdit instanceof SystemStore.Edit);
                this.change.addAll(((SystemStore.Edit)anEdit).getChange());
            }
            return result;
        }

        @Override
        public Set<ResourceKind> getChange() {
            return this.change;
        }
    }

    private class MyEdit
    extends AbstractUndoableEdit
    implements SystemStore.Edit {
        private final ResourceKind kind;
        private final EditType type;
        private final Set<ResourceKind> change;
        private GrammarProperties origProp = null;

        public MyEdit(EditType type, ResourceKind first, ResourceKind ... rest) {
            this.type = type;
            this.change = EnumSet.of(first, rest);
            this.kind = first;
        }

        public MyEdit(EditType type, Set<ResourceKind> change) {
            this.type = type;
            this.change = change;
            this.kind = null;
        }

        protected void addChange(ResourceKind kind) {
            this.change.add(kind);
        }

        @Override
        public Set<ResourceKind> getChange() {
            return this.change;
        }

        public ResourceKind getResourceKind() {
            return this.kind;
        }

        @Override
        public EditType getType() {
            return this.type;
        }

        public void checkAndSetVersion() {
            if (!DefaultFileSystemStore.this.getProperties().isCurrentVersionProperties()) {
                this.origProp = DefaultFileSystemStore.this.getProperties().clone();
                DefaultFileSystemStore.this.getProperties().setCurrentVersionProperties();
                try {
                    DefaultFileSystemStore.this.saveProperties();
                }
                catch (IOException iOException) {}
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.checkAndSetVersion();
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            try {
                if (this.origProp != null) {
                    DefaultFileSystemStore.this.properties = this.origProp;
                    DefaultFileSystemStore.this.saveProperties();
                    this.origProp = null;
                }
            }
            catch (IOException iOException) {
                throw new CannotUndoException();
            }
        }

        protected final Set<String> getNames(Collection<AspectGraph> graphs) {
            HashSet<String> result = new HashSet<String>();
            for (AspectGraph graph : graphs) {
                result.add(graph.getName());
            }
            return result;
        }
    }

    private class PutPropertiesEdit
    extends MyEdit {
        private final GrammarProperties oldProperties;
        private final GrammarProperties newProperties;

        public PutPropertiesEdit(GrammarProperties oldProperties, GrammarProperties newProperties) {
            super(EditType.MODIFY, ResourceKind.PROPERTIES, new ResourceKind[0]);
            for (ResourceKind kind : EnumSet.of(ResourceKind.PROLOG, ResourceKind.TYPE, ResourceKind.HOST, ResourceKind.CONTROL)) {
                Set<String> newNames;
                Set<String> oldNames = oldProperties.getActiveNames(kind);
                if (oldNames.equals(newNames = newProperties.getActiveNames(kind))) continue;
                this.addChange(kind);
            }
            this.oldProperties = oldProperties;
            this.newProperties = newProperties;
        }

        @Override
        public String getPresentationName() {
            return "Grammar Properties ...";
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            try {
                DefaultFileSystemStore.this.doPutProperties(this.newProperties);
            }
            catch (IOException iOException) {
                throw new CannotRedoException();
            }
            DefaultFileSystemStore.this.notifyObservers(this);
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            try {
                DefaultFileSystemStore.this.doPutProperties(this.oldProperties);
            }
            catch (IOException iOException) {
                throw new CannotUndoException();
            }
            DefaultFileSystemStore.this.notifyObservers(this);
        }
    }

    private class TextBasedEdit
    extends MyEdit {
        private final Map<String, String> oldTexts;
        private final Map<String, String> newTexts;
        private final GrammarProperties oldProps;
        private final GrammarProperties newProps;

        public TextBasedEdit(ResourceKind kind, EditType type, Map<String, String> oldTexts, Map<String, String> newTexts, GrammarProperties oldProps, GrammarProperties newProps) {
            super(type, kind, new ResourceKind[0]);
            this.oldTexts = oldTexts;
            this.newTexts = newTexts;
            this.newProps = newProps;
            if (newProps == null) {
                this.oldProps = null;
            } else {
                this.oldProps = oldProps;
                this.addChange(ResourceKind.PROPERTIES);
            }
        }

        @Override
        public String getPresentationName() {
            String result = Options.getEditActionName(this.getType(), this.getResourceKind(), false);
            if (this.newTexts.size() > 1 || this.oldTexts.size() > 1) {
                result = String.valueOf(result) + "s";
            }
            return result;
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            try {
                DefaultFileSystemStore.this.doDeleteTexts(this.getResourceKind(), this.oldTexts.keySet());
                if (this.newProps != null) {
                    DefaultFileSystemStore.this.doPutProperties(this.newProps);
                }
                DefaultFileSystemStore.this.doPutTexts(this.getResourceKind(), this.newTexts);
            }
            catch (IOException iOException) {
                throw new CannotRedoException();
            }
            DefaultFileSystemStore.this.notifyObservers(this);
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            try {
                DefaultFileSystemStore.this.doDeleteTexts(this.getResourceKind(), this.newTexts.keySet());
                if (this.oldProps != null) {
                    DefaultFileSystemStore.this.doPutProperties(this.oldProps);
                }
                DefaultFileSystemStore.this.doPutTexts(this.getResourceKind(), this.oldTexts);
            }
            catch (IOException iOException) {
                throw new CannotUndoException();
            }
            DefaultFileSystemStore.this.notifyObservers(this);
        }

        public final Map<String, String> getOldTexts() {
            return this.oldTexts;
        }
    }
}

