/*
 * Decompiled with CFR 0.152.
 */
package groove.io.store;

import groove.io.store.DefaultArchiveSystemStore;
import groove.io.store.DefaultFileSystemStore;
import groove.io.store.SystemStore;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public final class SystemStoreFactory {
    public static SystemStore newStore(File file, boolean create) throws IOException {
        SystemStore store = null;
        try {
            store = new DefaultFileSystemStore(file, create);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                store = new DefaultArchiveSystemStore(file);
            }
            catch (IllegalArgumentException exc1) {
                throw new IOException(exc1.getMessage());
            }
        }
        return store;
    }

    public static SystemStore newStore(URL url) throws IOException {
        SystemStore store = null;
        try {
            store = new DefaultArchiveSystemStore(url);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                store = new DefaultFileSystemStore(url);
            }
            catch (IllegalArgumentException exc1) {
                throw new IOException(exc1.getMessage());
            }
        }
        return store;
    }

    public static SystemStore newStore(String location) throws IOException {
        try {
            return SystemStoreFactory.newStore(new URL(location));
        }
        catch (IOException iOException) {
            return SystemStoreFactory.newStore(new File(location), false);
        }
    }
}

