/*
 * Decompiled with CFR 0.152.
 */
package groove.lts;

import groove.algebra.AlgebraFamily;
import groove.control.CtrlState;
import groove.explore.result.Result;
import groove.grammar.Grammar;
import groove.grammar.host.HostEdgeSet;
import groove.grammar.host.HostFactory;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.grammar.host.HostNodeSet;
import groove.grammar.host.ValueNode;
import groove.grammar.model.FormatException;
import groove.grammar.model.PostApplicationError;
import groove.grammar.type.EdgeMultiplicityVerifier;
import groove.graph.AGraph;
import groove.graph.ElementFactory;
import groove.graph.GraphRole;
import groove.graph.Node;
import groove.graph.iso.CertificateStrategy;
import groove.graph.iso.IsoChecker;
import groove.graph.plain.PlainGraph;
import groove.graph.plain.PlainNode;
import groove.gui.jgraph.LTSJModel;
import groove.lts.GTSListener;
import groove.lts.GraphState;
import groove.lts.GraphTransition;
import groove.lts.LTSFactory;
import groove.lts.MatchApplier;
import groove.lts.RuleTransition;
import groove.lts.StartGraphState;
import groove.transform.Record;
import groove.util.collect.NestedIterator;
import groove.util.collect.TransformIterator;
import groove.util.collect.TreeHashSet;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class GTS
extends AGraph<GraphState, GraphTransition>
implements Cloneable {
    protected static final boolean CHECK_CONTROL_LOCATION = true;
    private static int spuriousTransitionCount;
    private final Map<GraphState, Set<PostApplicationError>> postErrors;
    private final EdgeMultiplicityVerifier verifier;
    protected GraphState startState;
    private final Grammar grammar;
    private HostFactory hostFactory;
    private Set<? extends GraphState> nodeSet;
    private StateSet stateSet;
    private TransitionSet transitionSet;
    private final Set<GraphState> finalStates = new HashSet<GraphState>();
    private final Set<GraphState> resultStates = new HashSet<GraphState>();
    private Record record;
    private MatchApplier matchApplier;
    private int closedStateCount = 0;
    private int transitionCount = 0;
    private Set<GTSListener> listeners = new HashSet<GTSListener>();
    public static final int STATE_SET_RESOLUTION = 2;
    public static final int STATE_SET_ROOT_RESOLUTION = 10;
    public static final int INITIAL_STATE_SET_SIZE = 10000;
    public static final String START_LABEL_TEXT = "start";
    public static final String OPEN_LABEL_TEXT = "open";
    public static final String FINAL_LABEL_TEXT = "final";

    public static int getSpuriousTransitionCount() {
        return spuriousTransitionCount;
    }

    public double getBytesPerState() {
        return this.getStateSet().getBytesPerElement();
    }

    public GTS(Grammar grammar) {
        super(String.valueOf(grammar.getName()) + "-gts");
        grammar.testFixed(true);
        this.grammar = grammar;
        this.postErrors = new HashMap<GraphState, Set<PostApplicationError>>();
        this.verifier = new EdgeMultiplicityVerifier(grammar.getTypeGraph());
    }

    public GraphState startState() {
        if (this.startState == null) {
            HostGraph startGraph = this.createStartGraph(this.grammar.getStartGraph());
            this.startState = this.createStartState(startGraph);
            this.addState(this.startState);
        }
        return this.startState;
    }

    protected HostGraph createStartGraph(HostGraph startGraph) {
        HostGraph result = startGraph.clone(this.getAlgebraFamily());
        result.setFixed();
        return result;
    }

    protected GraphState createStartState(HostGraph startGraph) {
        return new StartGraphState(this, startGraph);
    }

    public Grammar getGrammar() {
        return this.grammar;
    }

    public HostFactory getHostFactory() {
        if (this.hostFactory == null) {
            this.hostFactory = this.grammar.getStartGraph().getFactory();
        }
        return this.hostFactory;
    }

    public AlgebraFamily getAlgebraFamily() {
        return this.getGrammar().getProperties().getAlgebraFamily();
    }

    public Collection<GraphState> getFinalStates() {
        return this.finalStates;
    }

    public Collection<GraphState> getResultStates() {
        return this.resultStates;
    }

    public boolean hasFinalStates() {
        return !this.getFinalStates().isEmpty();
    }

    public boolean isFinal(GraphState state) {
        return this.getFinalStates().contains(state);
    }

    public boolean isResult(GraphState state) {
        return this.getResultStates().contains(state);
    }

    protected void setFinal(GraphState state) {
        this.finalStates.add(state);
    }

    public void setResult(Result result) {
        this.resultStates.addAll(result.getValue());
        LTSJModel ltsJModel = this.getJModelListener();
        if (ltsJModel != null) {
            for (GraphState resultState : this.resultStates) {
                ltsJModel.statusUpdate(this, resultState, GraphState.Flag.DONE);
            }
        }
    }

    public boolean isOpen(GraphState state) {
        return !state.isClosed();
    }

    public boolean hasOpenStates() {
        return this.openStateCount() > 0;
    }

    public int openStateCount() {
        return this.nodeCount() - this.closedStateCount;
    }

    @Override
    public int nodeCount() {
        return this.getStateSet().size();
    }

    @Override
    public int edgeCount() {
        return this.transitionCount;
    }

    @Override
    public Set<? extends GraphTransition> outEdgeSet(Node node) {
        GraphState state = (GraphState)node;
        return state.getTransitions(GraphTransition.Class.ANY);
    }

    public boolean hasPostError() {
        return !this.postErrors.isEmpty();
    }

    public void addPostError(GraphState state, PostApplicationError error) {
        Set<PostApplicationError> errors = this.postErrors.get(state);
        if (errors == null) {
            errors = new HashSet<PostApplicationError>();
        }
        errors.add(error);
        this.postErrors.put(state, errors);
    }

    public void addPostErrors(GraphState state, Set<PostApplicationError> errors) {
        Set<PostApplicationError> old = this.postErrors.get(state);
        if (old == null) {
            this.postErrors.put(state, errors);
        } else {
            errors.addAll(old);
        }
    }

    public Set<? extends PostApplicationError> getPostErrors(GraphState state) {
        return this.postErrors.get(state);
    }

    @Override
    public ElementFactory<GraphState, GraphTransition> getFactory() {
        return new LTSFactory<GraphState, GraphTransition>(this);
    }

    @Override
    public Set<? extends GraphState> nodeSet() {
        if (this.nodeSet == null) {
            this.nodeSet = this.getStateSet();
        }
        return this.nodeSet;
    }

    @Override
    public Set<? extends GraphTransition> edgeSet() {
        if (this.transitionSet == null) {
            this.transitionSet = new TransitionSet();
        }
        return this.transitionSet;
    }

    protected TreeHashSet<GraphState> getStateSet() {
        if (this.stateSet == null) {
            this.stateSet = this.createStateSet();
        }
        return this.stateSet;
    }

    protected StateSet createStateSet() {
        return new StateSet(this.getCollapse(), null);
    }

    protected CollapseMode getCollapse() {
        CollapseMode result = !this.getRecord().isCollapse() ? CollapseMode.COLLAPSE_NONE : (!this.getRecord().isCheckIso() ? CollapseMode.COLLAPSE_EQUAL : CollapseMode.COLLAPSE_ISO_STRONG);
        return result;
    }

    public final Record getRecord() {
        if (this.record == null) {
            this.record = new Record(this.grammar, this.getHostFactory());
        }
        return this.record;
    }

    public void addTransition(GraphTransition trans) {
        if (trans.source().addTransition(trans)) {
            this.fireAddEdge(trans);
        } else {
            ++spuriousTransitionCount;
        }
        if (trans instanceof RuleTransition) {
            try {
                String outputString = ((RuleTransition)trans).getOutputString();
                if (outputString != null) {
                    System.out.print(outputString);
                }
            }
            catch (FormatException e) {
                System.err.println(e.getMessage());
            }
        }
    }

    public GraphState addState(GraphState newState) {
        GraphState result = this.getStateSet().put(newState);
        if (result == null) {
            this.fireAddNode(newState);
            this.verifier.reset();
            this.verifier.count(newState.getGraph());
            if (!this.verifier.check(newState)) {
                this.addPostErrors(newState, this.verifier.getErrors());
                newState.setError();
            }
        }
        return result;
    }

    public Set<GTSListener> getGraphListeners() {
        if (this.isFixed()) {
            return Collections.emptySet();
        }
        return this.listeners;
    }

    public void addLTSListener(GTSListener listener) {
        if (this.listeners != null) {
            this.listeners.add(listener);
        }
    }

    public void removeLTSListener(GTSListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    private LTSJModel getJModelListener() {
        for (GTSListener listener : this.getGraphListeners()) {
            if (!(listener instanceof LTSJModel)) continue;
            return (LTSJModel)listener;
        }
        return null;
    }

    @Override
    protected void fireAddNode(GraphState node) {
        super.fireAddNode(node);
        for (GTSListener listener : this.getGraphListeners()) {
            listener.addUpdate(this, node);
        }
    }

    @Override
    protected void fireAddEdge(GraphTransition edge) {
        ++this.transitionCount;
        super.fireAddEdge(edge);
        for (GTSListener listener : this.getGraphListeners()) {
            listener.addUpdate(this, edge);
        }
    }

    protected void fireUpdateState(GraphState state, GraphState.Flag flag) {
        switch (flag) {
            case CLOSED: {
                if (state.getSchedule().isSuccess() || this.hasFinalProperties(state)) {
                    this.setFinal(state);
                }
                ++this.closedStateCount;
            }
        }
        for (GTSListener listener : this.getGraphListeners()) {
            listener.statusUpdate(this, state, flag);
        }
    }

    private boolean hasFinalProperties(GraphState state) {
        boolean result = state.isPresent();
        if (result) {
            for (RuleTransition trans : state.getRuleTransitions()) {
                if (trans.target().isAbsent() || !trans.getCtrlTransition().getRule().isModifying() && trans.target().equals(state)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public final int getTransitionCount() {
        return this.transitionCount;
    }

    public boolean checkDiamonds() {
        return true;
    }

    public PlainGraph toPlainGraph(boolean showFinal, boolean showStart, boolean showOpen, boolean showNames) {
        PlainGraph result = new PlainGraph(this.getName());
        HashMap<GraphState, PlainNode> nodeMap = new HashMap<GraphState, PlainNode>();
        for (GraphState graphState : this.nodeSet()) {
            PlainNode image = (PlainNode)result.addNode(graphState.getNumber());
            nodeMap.put(graphState, image);
            if (showFinal && this.isFinal(graphState)) {
                result.addEdge(image, FINAL_LABEL_TEXT, image);
            }
            if (showStart && this.startState().equals(graphState)) {
                result.addEdge(image, START_LABEL_TEXT, image);
            }
            if (showOpen && !graphState.isClosed()) {
                result.addEdge(image, OPEN_LABEL_TEXT, image);
            }
            if (!showNames) continue;
            result.addEdge(image, graphState.toString(), image);
        }
        for (GraphTransition graphTransition : this.edgeSet()) {
            result.addEdge((PlainNode)nodeMap.get(graphTransition.source()), graphTransition.label().text(), (PlainNode)nodeMap.get(graphTransition.target()));
        }
        return result;
    }

    @Override
    public GTS newGraph(String name) {
        return new GTS(this.grammar);
    }

    @Override
    public boolean addNode(GraphState node) {
        return this.addState(node) == null;
    }

    @Override
    public boolean removeEdge(GraphTransition edge) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addEdge(GraphTransition edge) {
        if (edge instanceof RuleTransition) {
            this.addTransition(edge);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeNode(GraphState node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GTS clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public GraphRole getRole() {
        return GraphRole.LTS;
    }

    public final MatchApplier getMatchApplier() {
        if (this.matchApplier == null) {
            this.matchApplier = this.createMatchApplier();
        }
        return this.matchApplier;
    }

    protected MatchApplier createMatchApplier() {
        return new MatchApplier(this);
    }

    protected static enum CollapseMode {
        COLLAPSE_NONE,
        COLLAPSE_EQUAL,
        COLLAPSE_ISO_WEAK,
        COLLAPSE_ISO_STRONG;

    }

    public static class NormalisedStateSet
    extends TreeHashSet<GraphState> {
        @Override
        protected boolean areEqual(GraphState newKey, GraphState oldKey) {
            return true;
        }

        @Override
        protected int getCode(GraphState key) {
            return key.getNumber();
        }

        @Override
        protected boolean allEqual() {
            return true;
        }
    }

    public static class StateSet
    extends TreeHashSet<GraphState> {
        private final IsoChecker checker;
        protected final CollapseMode collapse;

        public StateSet(CollapseMode collapse, IsoChecker checker) {
            super(10000, 2, 10);
            this.collapse = collapse;
            this.checker = checker == null ? IsoChecker.getInstance(collapse == CollapseMode.COLLAPSE_ISO_STRONG) : checker;
        }

        @Override
        protected boolean areEqual(GraphState myState, GraphState otherState) {
            if (this.collapse == CollapseMode.COLLAPSE_NONE) {
                return myState == otherState;
            }
            if (myState.getCtrlState() != otherState.getCtrlState()) {
                return false;
            }
            Object[] myBoundNodes = myState.getBoundNodes();
            Object[] otherBoundNodes = otherState.getBoundNodes();
            HostGraph myGraph = myState.getGraph();
            HostGraph otherGraph = otherState.getGraph();
            if (this.collapse == CollapseMode.COLLAPSE_EQUAL) {
                if (!Arrays.equals(myBoundNodes, otherBoundNodes)) {
                    return false;
                }
                HostNodeSet myNodeSet = new HostNodeSet(myGraph.nodeSet());
                HostEdgeSet myEdgeSet = new HostEdgeSet(myGraph.edgeSet());
                return myNodeSet.equals(otherGraph.nodeSet()) && myEdgeSet.equals(otherGraph.edgeSet());
            }
            return this.checker.areIsomorphic(myGraph, otherGraph, (Node[])myBoundNodes, (Node[])otherBoundNodes);
        }

        @Override
        protected int getCode(GraphState stateKey) {
            block8: {
                int result;
                block9: {
                    block7: {
                        if (this.collapse != CollapseMode.COLLAPSE_NONE) break block7;
                        result = System.identityHashCode(stateKey);
                        break block8;
                    }
                    if (this.collapse != CollapseMode.COLLAPSE_EQUAL) break block9;
                    HostGraph graph = stateKey.getGraph();
                    result = graph.nodeSet().hashCode() + graph.edgeSet().hashCode();
                    CtrlState ctrlState = stateKey.getCtrlState();
                    if (ctrlState == null) break block8;
                    result += ctrlState.hashCode();
                    HostNode[] hostNodeArray = stateKey.getBoundNodes();
                    int n = hostNodeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        HostNode node = hostNodeArray[n2];
                        result = result << 1 | ((result += node == null ? 31 : node.hashCode()) < 0 ? 1 : 0);
                        ++n2;
                    }
                    break block8;
                }
                CertificateStrategy certifier = this.checker.getCertifier(stateKey.getGraph(), true);
                Object certificate = certifier.getGraphCertificate();
                result = certificate.hashCode();
                CtrlState ctrlState = stateKey.getCtrlState();
                if (ctrlState != null) {
                    result += ctrlState.hashCode();
                    HostNode[] hostNodeArray = stateKey.getBoundNodes();
                    int n = hostNodeArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        int hashCode;
                        HostNode node = hostNodeArray[n3];
                        if (node == null) {
                            hashCode = 31;
                        } else if (node instanceof ValueNode) {
                            hashCode = node.hashCode();
                        } else {
                            CertificateStrategy.Certificate parCert = certifier.getCertificateMap().get(node);
                            hashCode = parCert.hashCode();
                        }
                        result = result << 1 | ((result += hashCode) < 0 ? 1 : 0);
                        ++n3;
                    }
                }
            }
            return result += System.identityHashCode(stateKey.getCtrlState());
        }
    }

    private class TransitionSet
    extends AbstractSet<GraphTransition> {
        TransitionSet() {
        }

        @Override
        public boolean contains(Object o) {
            boolean result = false;
            if (o instanceof GraphTransition) {
                GraphTransition transition = (GraphTransition)o;
                GraphState source = transition.source();
                result = GTS.this.containsNode(source) && GTS.this.outEdgeSet(source).contains(transition);
            }
            return result;
        }

        @Override
        public Iterator<GraphTransition> iterator() {
            TransformIterator<GraphState, Iterator<? extends GraphTransition>> stateOutTransitionIter = new TransformIterator<GraphState, Iterator<? extends GraphTransition>>(GTS.this.nodeSet().iterator()){

                @Override
                public Iterator<? extends GraphTransition> toOuter(GraphState state) {
                    return GTS.this.outEdgeSet(state).iterator();
                }
            };
            return new NestedIterator<GraphTransition>(stateOutTransitionIter);
        }

        @Override
        public int size() {
            return GTS.this.getTransitionCount();
        }
    }
}

