/*
 * Decompiled with CFR 0.152.
 */
package groove.lts;

import groove.control.CtrlState;
import groove.control.CtrlTransition;
import groove.grammar.Rule;
import groove.grammar.host.HostNode;
import groove.grammar.host.HostNodeSet;
import groove.lts.AbstractGraphState;
import groove.lts.DefaultGraphNextState;
import groove.lts.DefaultRuleTransition;
import groove.lts.GTS;
import groove.lts.GraphNextState;
import groove.lts.GraphState;
import groove.lts.MatchResult;
import groove.lts.RuleTransition;
import groove.lts.RuleTransitionStub;
import groove.transform.CompositeEvent;
import groove.transform.MergeMap;
import groove.transform.RuleEffect;
import groove.transform.RuleEvent;
import groove.util.Reporter;

public class MatchApplier {
    private final GTS gts;
    private static int confluentDiamondCount;
    private static final HostNode[] EMPTY_NODE_ARRAY;
    private static final Reporter reporter;
    public static final Reporter addStateReporter;
    public static final Reporter addTransitionReporter;

    static {
        EMPTY_NODE_ARRAY = new HostNode[0];
        reporter = Reporter.register(MatchApplier.class);
        addStateReporter = reporter.register("addState");
        addTransitionReporter = reporter.register("addTransition");
    }

    public MatchApplier(GTS gts) {
        this.gts = gts;
    }

    public GTS getGTS() {
        return this.gts;
    }

    public RuleTransition apply(GraphState source, MatchResult match) {
        addTransitionReporter.start();
        RuleTransition transition = null;
        Rule rule = match.getRule();
        CtrlTransition ctrlTrans = match.getCtrlTransition();
        if (!ctrlTrans.isModifying()) {
            if (!rule.isModifying()) {
                transition = this.createTransition(source, match, source, false);
            } else if (match.hasRuleTransition()) {
                GraphState sibling;
                RuleTransitionStub siblingOut;
                assert (source instanceof GraphNextState);
                RuleTransition parentTrans = match.getRuleTransition();
                assert (source != parentTrans.source());
                boolean sourceModifiesCtrl = ((GraphNextState)source).getCtrlTransition().isModifying();
                MatchResult sourceKey = ((GraphNextState)source).getKey();
                if (!(sourceModifiesCtrl || parentTrans.isSymmetry() || match.getEvent().conflicts(sourceKey.getEvent()) || (siblingOut = (sibling = parentTrans.target()).getOutStub(sourceKey)) == null)) {
                    transition = this.createTransition(source, match, siblingOut.getTarget(sibling), siblingOut.isSymmetry());
                    ++confluentDiamondCount;
                }
            }
        }
        if (transition == null) {
            GraphNextState freshTarget = this.createState(source, match);
            addStateReporter.start();
            GraphState isoTarget = this.getGTS().addState(freshTarget);
            addStateReporter.stop();
            transition = isoTarget == null ? freshTarget : new DefaultRuleTransition(source, match, freshTarget.getAddedNodes(), isoTarget, true);
        }
        this.getGTS().addTransition(transition);
        addTransitionReporter.stop();
        return transition;
    }

    private GraphNextState createState(GraphState source, MatchResult match) {
        HostNode[] boundNodes;
        HostNode[] addedNodes;
        RuleEvent event = match.getEvent();
        if (this.reuseCreatedNodes(source, match)) {
            RuleTransition parentOut = match.getRuleTransition();
            addedNodes = parentOut.getAddedNodes();
        } else if (event.getRule().hasNodeCreators()) {
            RuleEffect record = new RuleEffect(source.getGraph(), RuleEffect.Fragment.NODE_CREATION);
            event.recordEffect(record);
            addedNodes = record.getCreatedNodeArray();
        } else {
            addedNodes = EMPTY_NODE_ARRAY;
        }
        CtrlTransition ctrlTrans = match.getCtrlTransition();
        if (((CtrlState)ctrlTrans.target()).getBoundVars().isEmpty()) {
            boundNodes = EMPTY_NODE_ARRAY;
        } else {
            RuleEffect record = new RuleEffect(addedNodes, RuleEffect.Fragment.NODE_ALL);
            event.recordEffect(record);
            boundNodes = this.computeBoundNodes(source, event, ctrlTrans, record);
        }
        assert (boundNodes.length == ctrlTrans.getTargetVarBinding().length);
        return new DefaultGraphNextState(this.gts.nodeCount(), (AbstractGraphState)source, match, addedNodes, boundNodes);
    }

    private RuleTransition createTransition(GraphState source, MatchResult match, GraphState target, boolean symmetry) {
        HostNode[] addedNodes;
        RuleEvent event = match.getEvent();
        if (this.reuseCreatedNodes(source, match)) {
            RuleTransition parentOut = match.getRuleTransition();
            addedNodes = parentOut.getAddedNodes();
        } else {
            RuleEffect record = new RuleEffect(source.getGraph(), RuleEffect.Fragment.NODE_CREATION);
            event.recordEffect(record);
            addedNodes = record.hasCreatedNodes() ? record.getCreatedNodeArray() : EMPTY_NODE_ARRAY;
        }
        return new DefaultRuleTransition(source, match, addedNodes, target, symmetry);
    }

    private boolean reuseCreatedNodes(GraphState source, MatchResult match) {
        if (!match.hasRuleTransition()) {
            return false;
        }
        if (!(source instanceof GraphNextState)) {
            return false;
        }
        HostNode[] addedNodes = match.getRuleTransition().getAddedNodes();
        if (addedNodes == null || addedNodes.length == 0) {
            return true;
        }
        RuleEvent sourceEvent = ((GraphNextState)source).getEvent();
        if (sourceEvent instanceof CompositeEvent) {
            return false;
        }
        RuleEvent matchEvent = match.getEvent();
        if (matchEvent instanceof CompositeEvent) {
            return false;
        }
        return sourceEvent != matchEvent;
    }

    private HostNode[] computeBoundNodes(GraphState source, RuleEvent event, CtrlTransition ctrlTrans, RuleEffect record) {
        int[] varBinding = ctrlTrans.getTargetVarBinding();
        int valueCount = varBinding.length;
        HostNode[] result = new HostNode[valueCount];
        HostNode[] parentValues = source.getBoundNodes();
        Rule rule = event.getRule();
        int anchorSize = rule.getAnchor().size();
        HostNode[] createdNodes = record.getCreatedNodeArray();
        HostNodeSet erasedNodes = record.getErasedNodes();
        MergeMap mergeMap = record.getMergeMap();
        int i = 0;
        while (i < valueCount) {
            HostNode value;
            int fromI = varBinding[i];
            if (fromI >= parentValues.length) {
                int binding = rule.getParBinding(fromI - parentValues.length);
                if (binding < anchorSize) {
                    HostNode sourceValue = (HostNode)event.getAnchorImage(binding);
                    value = this.getNodeImage(sourceValue, mergeMap, erasedNodes);
                } else {
                    value = createdNodes[binding - anchorSize];
                }
            } else {
                HostNode sourceValue = parentValues[fromI];
                value = this.getNodeImage(sourceValue, mergeMap, erasedNodes);
            }
            result[i] = value;
            ++i;
        }
        return result;
    }

    private HostNode getNodeImage(HostNode key, MergeMap mergeMap, HostNodeSet erasedNodes) {
        if (mergeMap == null) {
            if (erasedNodes == null || !erasedNodes.contains(key)) {
                return key;
            }
            return null;
        }
        return mergeMap.getNode(key);
    }

    public static int getConfluentDiamondCount() {
        return confluentDiamondCount;
    }

    public static long getGenerateTime() {
        return addTransitionReporter.getTotalTime();
    }
}

