/*
 * Decompiled with CFR 0.152.
 */
package groove.lts;

import groove.grammar.Recipe;
import groove.graph.ALabel;
import groove.graph.Label;
import groove.lts.ActionLabel;
import groove.lts.RuleTransition;
import groove.lts.RuleTransitionLabel;

public class RecipeTransitionLabel
extends ALabel
implements ActionLabel {
    private final String text;
    private final Recipe recipe;
    private final RuleTransition initial;

    public RecipeTransitionLabel(RuleTransition initial) {
        this.recipe = initial.getRecipe();
        this.initial = initial;
        this.text = this.getLabelText();
    }

    @Override
    public Recipe getAction() {
        return this.recipe;
    }

    public RuleTransition getInitial() {
        return this.initial;
    }

    private String getLabelText() {
        return this.recipe.getFullName();
    }

    @Override
    public String text() {
        return this.text;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RecipeTransitionLabel)) {
            return false;
        }
        RecipeTransitionLabel other = (RecipeTransitionLabel)obj;
        if (!this.recipe.equals(other.recipe)) {
            return false;
        }
        return this.initial.equals(other.initial);
    }

    @Override
    protected int computeHashCode() {
        int result = this.recipe.hashCode();
        result = 31 * result + this.initial.hashCode();
        return result;
    }

    @Override
    public int compareTo(Label obj) {
        if (!(obj instanceof ActionLabel)) {
            throw new IllegalArgumentException(String.format("Can't compare %s and %s", this.getClass(), obj.getClass()));
        }
        if (obj instanceof RuleTransitionLabel) {
            return -obj.compareTo(this);
        }
        int result = super.compareTo(obj);
        if (result != 0) {
            return result;
        }
        RecipeTransitionLabel other = (RecipeTransitionLabel)obj;
        result = this.recipe.compareTo(other.recipe);
        if (result != 0) {
            return result;
        }
        return this.getInitial().label().compareTo(other.getInitial().label());
    }
}

