/*
 * Decompiled with CFR 0.152.
 */
package groove.match;

import groove.grammar.Condition;
import groove.grammar.rule.Anchor;
import groove.match.DefaultValueOracle;
import groove.match.Matcher;
import groove.match.SearchEngine;
import groove.match.ValueOracle;
import groove.match.plan.PlanSearchEngine;

public class MatcherFactory {
    private SearchEngine engine = defaultEngine;
    private ValueOracle oracle = DefaultValueOracle.instance();
    private static MatcherFactory instance;
    private static SearchEngine defaultEngine;

    static {
        defaultEngine = PlanSearchEngine.getInstance();
    }

    private MatcherFactory() {
    }

    public void setEngine(SearchEngine engine) {
        this.engine = engine;
    }

    public void setEngine(SearchEngine.SearchMode mode) {
        this.engine = PlanSearchEngine.getInstance(mode);
    }

    public ValueOracle getOracle() {
        return this.oracle;
    }

    public void setOracle(ValueOracle oracle) {
        assert (oracle != null);
        this.oracle = oracle;
    }

    public void setDefaultEngine() {
        this.setEngine(defaultEngine);
    }

    public SearchEngine getEngine() {
        return this.engine;
    }

    public Matcher createMatcher(Condition condition) {
        return this.createMatcher(condition, null);
    }

    public Matcher createMatcher(Condition condition, Anchor seed) {
        return new Matcher(this, condition, seed);
    }

    public static MatcherFactory instance() {
        if (instance == null) {
            instance = new MatcherFactory();
        }
        return instance;
    }
}

