/*
 * Decompiled with CFR 0.152.
 */
package groove.match.plan;

import groove.grammar.host.HostGraph;
import groove.grammar.rule.LabelVar;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleNode;
import groove.match.plan.PlanSearchStrategy;
import groove.match.plan.SearchItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

abstract class AbstractSearchItem
implements SearchItem {
    private boolean relevant = true;
    private int hashCode;

    AbstractSearchItem() {
    }

    @Override
    public Collection<? extends RuleNode> bindsNodes() {
        return Collections.emptySet();
    }

    @Override
    public Collection<LabelVar> bindsVars() {
        return Collections.emptySet();
    }

    @Override
    public Collection<? extends RuleEdge> bindsEdges() {
        return Collections.emptySet();
    }

    @Override
    public Collection<RuleNode> needsNodes() {
        return Collections.emptySet();
    }

    @Override
    public Collection<LabelVar> needsVars() {
        return Collections.emptySet();
    }

    @Override
    public boolean isTestsNodes() {
        return false;
    }

    @Override
    public int compareTo(SearchItem other) {
        int result = this.getClass().getName().compareTo(other.getClass().getName());
        if (result == 0) {
            result = this.getRating() - this.getRating(other);
        }
        return result;
    }

    private int getRating(SearchItem other) {
        if (other instanceof AbstractSearchItem) {
            return ((AbstractSearchItem)other).getRating();
        }
        return 0;
    }

    abstract int getRating();

    final SearchItem.Record createDummyRecord() {
        return new DummyRecord();
    }

    void setRelevant(boolean relevant) {
        this.relevant = relevant;
    }

    @Override
    public final boolean isRelevant() {
        return this.relevant;
    }

    public final int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.computeHashCode();
            if (this.hashCode == 0) {
                ++this.hashCode;
            }
        }
        return this.hashCode;
    }

    int computeHashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    abstract class BasicRecord
    implements SearchItem.Record {
        HostGraph host;
        final PlanSearchStrategy.Search search;

        BasicRecord(PlanSearchStrategy.Search search) {
            this.search = search;
        }

        @Override
        public void initialise(HostGraph host) {
            this.reset();
            this.host = host;
        }

        @Override
        public final boolean isRelevant() {
            return AbstractSearchItem.this.isRelevant();
        }
    }

    final class DummyRecord
    implements SearchItem.Record {
        private boolean found;

        DummyRecord() {
        }

        @Override
        public void initialise(HostGraph host) {
            this.found = false;
        }

        @Override
        public boolean next() {
            this.found = !this.found;
            return this.found;
        }

        @Override
        public boolean isSingular() {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isRelevant() {
            return AbstractSearchItem.this.isRelevant();
        }

        @Override
        public void repeat() {
            this.reset();
        }

        @Override
        public void reset() {
            this.found = false;
        }

        public String toString() {
            return String.format("%s: %s", AbstractSearchItem.this.toString(), this.found);
        }
    }

    abstract class MultipleRecord<E>
    extends BasicRecord {
        Iterator<? extends E> imageIter;
        List<E> oldImages;
        int oldImageIndex;
        private SearchItem.State state;

        MultipleRecord(PlanSearchStrategy.Search search) {
            super(search);
            this.oldImages = new ArrayList();
            this.oldImageIndex = 0;
            this.state = SearchItem.State.START;
        }

        @Override
        public final boolean isSingular() {
            return false;
        }

        @Override
        public final boolean isEmpty() {
            return this.state == SearchItem.State.EMPTY;
        }

        @Override
        public final boolean next() {
            SearchItem.State nextState;
            switch (this.state) {
                case EMPTY: {
                    nextState = SearchItem.State.EMPTY;
                    break;
                }
                case FULL_REPEAT: {
                    int index = this.oldImageIndex;
                    if (index == this.oldImages.size()) {
                        this.erase();
                        nextState = SearchItem.State.FULL_START;
                        break;
                    }
                    this.write(this.oldImages.get(index));
                    this.oldImageIndex = index + 1;
                    nextState = SearchItem.State.FULL_REPEAT;
                    break;
                }
                case FULL_START: {
                    this.write(this.oldImages.get(0));
                    this.oldImageIndex = 1;
                    nextState = SearchItem.State.FULL_REPEAT;
                    break;
                }
                case PART: {
                    E image = this.find();
                    if (image == null) {
                        this.erase();
                        nextState = SearchItem.State.FULL_START;
                        break;
                    }
                    this.oldImages.add(image);
                    nextState = SearchItem.State.PART;
                    break;
                }
                case PART_REPEAT: {
                    int index = this.oldImageIndex;
                    this.write(this.oldImages.get(index));
                    if (index == this.oldImages.size() - 1) {
                        nextState = SearchItem.State.PART;
                        break;
                    }
                    this.oldImageIndex = index + 1;
                    nextState = SearchItem.State.PART_REPEAT;
                    break;
                }
                case PART_START: {
                    this.write(this.oldImages.get(0));
                    if (this.oldImages.size() == 1) {
                        nextState = SearchItem.State.PART;
                        break;
                    }
                    this.oldImageIndex = 1;
                    nextState = SearchItem.State.PART_REPEAT;
                    break;
                }
                case START: {
                    E image = this.find();
                    if (image == null) {
                        nextState = SearchItem.State.EMPTY;
                        break;
                    }
                    this.oldImages.clear();
                    this.oldImages.add(image);
                    nextState = SearchItem.State.PART;
                    break;
                }
                default: {
                    assert (false);
                    nextState = null;
                }
            }
            assert (this.state.getNext().contains((Object)nextState)) : String.format("Illegal transition %s -next-> %s", new Object[]{this.state, nextState});
            this.state = nextState;
            return nextState.isWritten();
        }

        @Override
        public final void repeat() {
            if (this.state.isWritten()) {
                this.erase();
            }
            this.state = this.state.getRepeat();
        }

        @Override
        public final void reset() {
            if (this.state.isWritten()) {
                this.erase();
            }
            this.imageIter = null;
            this.state = this.state.getReset();
        }

        abstract void init();

        final E find() {
            Object result = null;
            if (this.imageIter == null) {
                this.init();
            }
            while (result == null && this.imageIter.hasNext()) {
                result = this.imageIter.next();
                if (this.write(result)) continue;
                result = null;
            }
            return result;
        }

        abstract boolean write(E var1);

        abstract void erase();
    }

    abstract class SingularRecord
    extends BasicRecord {
        SearchItem.State state;

        SingularRecord(PlanSearchStrategy.Search search) {
            super(search);
            this.state = SearchItem.State.START;
        }

        @Override
        public final boolean isSingular() {
            return true;
        }

        @Override
        public final boolean isEmpty() {
            return this.state == SearchItem.State.EMPTY;
        }

        @Override
        public final boolean next() {
            SearchItem.State nextState = null;
            switch (this.state) {
                case START: {
                    nextState = this.find() ? SearchItem.State.FOUND : SearchItem.State.EMPTY;
                    break;
                }
                case FOUND: {
                    this.erase();
                    nextState = SearchItem.State.FULL;
                    break;
                }
                case EMPTY: {
                    nextState = SearchItem.State.EMPTY;
                    break;
                }
                case FULL: {
                    boolean result = this.write();
                    assert (result);
                    nextState = SearchItem.State.FOUND;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            assert (this.state.getNext().contains((Object)nextState)) : String.format("Illegal transition %s -next-> %s", new Object[]{this.state, nextState});
            this.state = nextState;
            return nextState.isWritten();
        }

        @Override
        public final void repeat() {
            if (this.state.isWritten()) {
                this.erase();
            }
            this.state = this.state.getRepeat();
        }

        @Override
        public final void reset() {
            if (this.state.isWritten()) {
                this.erase();
            }
            this.state = this.state.getReset();
        }

        abstract boolean find();

        abstract boolean write();

        abstract void erase();

        public String toString() {
            return String.format("%s: %b", AbstractSearchItem.this.toString(), this.state.isWritten());
        }
    }
}

