/*
 * Decompiled with CFR 0.152.
 */
package groove.match.plan;

import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleLabel;
import groove.grammar.rule.RuleNode;
import groove.graph.Node;
import groove.graph.NodeComparator;
import groove.match.plan.AbstractSearchItem;
import groove.match.plan.PlanSearchStrategy;
import groove.match.plan.SearchItem;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class EqualitySearchItem
extends AbstractSearchItem {
    final RuleNode node1;
    final RuleNode node2;
    final boolean equals;
    private final Collection<RuleEdge> boundEdges;
    private final Collection<RuleNode> neededNodes;
    int node1Ix;
    int node2Ix;
    private static NodeComparator nodeComparator = NodeComparator.instance();

    public EqualitySearchItem(RuleEdge edge, boolean equals) {
        assert (((RuleLabel)edge.label()).isEmpty() || ((RuleLabel)edge.label()).isNeg() && ((RuleLabel)edge.label()).getNegOperand().isEmpty());
        if (nodeComparator.compare((Node)edge.source(), (Node)edge.target()) < 0) {
            this.node1 = (RuleNode)edge.source();
            this.node2 = (RuleNode)edge.target();
        } else {
            this.node1 = (RuleNode)edge.target();
            this.node2 = (RuleNode)edge.source();
        }
        this.equals = equals;
        this.neededNodes = new HashSet<RuleNode>();
        this.neededNodes.add(this.node1);
        this.neededNodes.add(this.node2);
        this.boundEdges = Collections.singleton(edge);
    }

    @Override
    public EqualityRecord createRecord(PlanSearchStrategy.Search matcher) {
        return new EqualityRecord(matcher);
    }

    @Override
    public Collection<? extends RuleEdge> bindsEdges() {
        return this.boundEdges;
    }

    @Override
    public Collection<RuleNode> needsNodes() {
        return this.neededNodes;
    }

    public String toString() {
        return String.format("Test %s and %s for %s", this.node1, this.node2, this.equals ? "equality" : "inequality");
    }

    @Override
    int getRating() {
        return 0;
    }

    @Override
    public int compareTo(SearchItem item) {
        int result = super.compareTo(item);
        if (result != 0) {
            return result;
        }
        EqualitySearchItem other = (EqualitySearchItem)item;
        result = nodeComparator.compare(this.node1, other.node1);
        if (result != 0) {
            return result;
        }
        result = nodeComparator.compare(this.node2, other.node2);
        return result;
    }

    @Override
    int computeHashCode() {
        int result = super.computeHashCode();
        result = 31 * this.node1.hashCode();
        result = 31 * this.node2.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        EqualitySearchItem other = (EqualitySearchItem)obj;
        if (!this.node1.equals(other.node1)) {
            return false;
        }
        return this.node2.equals(other.node2);
    }

    @Override
    public void activate(PlanSearchStrategy strategy) {
        this.node1Ix = strategy.getNodeIx(this.node1);
        this.node2Ix = strategy.getNodeIx(this.node2);
    }

    private class EqualityRecord
    extends AbstractSearchItem.SingularRecord {
        EqualityRecord(PlanSearchStrategy.Search search) {
            super(search);
            assert (search.getNode(EqualitySearchItem.this.node1Ix) != null) : String.format("Merge embargo node %s not yet matched", equalitySearchItem.node1);
            assert (search.getNode(EqualitySearchItem.this.node2Ix) != null) : String.format("Merge embargo node %s not yet matched", equalitySearchItem.node2);
        }

        @Override
        boolean find() {
            return EqualitySearchItem.this.equals == (this.search.getNode(EqualitySearchItem.this.node1Ix) == this.search.getNode(EqualitySearchItem.this.node2Ix));
        }

        @Override
        void erase() {
        }

        @Override
        boolean write() {
            return true;
        }
    }
}

