/*
 * Decompiled with CFR 0.152.
 */
package groove.match.plan;

import groove.algebra.AlgebraFamily;
import groove.algebra.Operation;
import groove.grammar.host.HostFactory;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.grammar.host.ValueNode;
import groove.grammar.rule.OperatorNode;
import groove.grammar.rule.RuleNode;
import groove.grammar.rule.VariableNode;
import groove.match.plan.AbstractSearchItem;
import groove.match.plan.PlanSearchStrategy;
import groove.match.plan.SearchItem;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

class OperatorNodeSearchItem
extends AbstractSearchItem {
    final OperatorNode node;
    final Operation operation;
    final List<VariableNode> arguments;
    final VariableNode target;
    final Object value;
    final Collection<RuleNode> boundNodes;
    final Collection<RuleNode> neededNodes;
    int[] argumentIxs;
    boolean targetFound;
    int targetIx;

    public OperatorNodeSearchItem(OperatorNode node, AlgebraFamily family) {
        this.node = node;
        this.operation = family.getOperation(node.getOperator());
        assert (this.operation != null);
        this.arguments = node.getArguments();
        this.target = node.getTarget();
        this.boundNodes = new HashSet<RuleNode>();
        this.boundNodes.add(node);
        this.neededNodes = new HashSet<VariableNode>(this.arguments);
        if (this.target.hasConstant()) {
            this.neededNodes.add(this.target);
            this.value = family.getValue(node.getOperator().getResultType(), this.target.getConstant().getSymbol());
        } else {
            this.boundNodes.add(this.target);
            this.value = null;
        }
    }

    @Override
    public OperatorNodeRecord createRecord(PlanSearchStrategy.Search matcher) {
        return new OperatorNodeRecord(matcher);
    }

    @Override
    public Collection<? extends RuleNode> bindsNodes() {
        return this.boundNodes;
    }

    @Override
    public Collection<RuleNode> needsNodes() {
        return this.neededNodes;
    }

    public String toString() {
        return String.format("Compute %s%s-->%s", this.operation.toString(), this.arguments, this.target);
    }

    @Override
    public int compareTo(SearchItem item) {
        int result = super.compareTo(item);
        if (result != 0) {
            return result;
        }
        OperatorNode hisNode = ((OperatorNodeSearchItem)item).getNode();
        List<VariableNode> hisArguments = hisNode.getArguments();
        result = this.operation.getName().compareTo(hisNode.getOperator().getName());
        if (result != 0) {
            return result;
        }
        int i = 0;
        while (i < this.arguments.size()) {
            result = this.arguments.get(i).compareTo(hisArguments.get(i));
            if (result != 0) {
                return result;
            }
            ++i;
        }
        result = this.target.compareTo(hisNode.getTarget());
        if (result != 0) {
            return result;
        }
        result = this.getNode().compareTo(hisNode);
        return result;
    }

    @Override
    int getRating() {
        return this.node.hashCode();
    }

    @Override
    int computeHashCode() {
        return super.computeHashCode() + 31 * this.getNode().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        OperatorNodeSearchItem other = (OperatorNodeSearchItem)obj;
        return this.getNode().equals(other.getNode());
    }

    public OperatorNode getNode() {
        return this.node;
    }

    @Override
    public void activate(PlanSearchStrategy strategy) {
        this.targetFound = strategy.isNodeFound(this.target);
        this.targetIx = strategy.getNodeIx(this.target);
        this.argumentIxs = new int[this.arguments.size()];
        int i = 0;
        while (i < this.arguments.size()) {
            this.argumentIxs[i] = strategy.getNodeIx(this.arguments.get(i));
            ++i;
        }
    }

    private class OperatorNodeRecord
    extends AbstractSearchItem.SingularRecord {
        private HostNode targetPreMatch;
        private HostFactory factory;
        private ValueNode image;
        private static final boolean PRINT = false;

        OperatorNodeRecord(PlanSearchStrategy.Search search) {
            super(search);
        }

        @Override
        public String toString() {
            return String.format("%s = %s", OperatorNodeSearchItem.this.toString(), this.search.getNode(OperatorNodeSearchItem.this.targetIx));
        }

        @Override
        public void initialise(HostGraph host) {
            super.initialise(host);
            this.factory = host.getFactory();
            this.targetPreMatch = this.search.getNodeSeed(OperatorNodeSearchItem.this.targetIx);
        }

        @Override
        boolean find() {
            boolean result;
            Object outcome = this.calculateResult();
            if (outcome == null) {
                result = false;
            } else if (OperatorNodeSearchItem.this.value != null) {
                result = OperatorNodeSearchItem.this.value.equals(outcome);
            } else if (OperatorNodeSearchItem.this.targetFound || this.targetPreMatch != null) {
                HostNode targetFind = this.targetPreMatch;
                if (targetFind == null) {
                    targetFind = this.search.getNode(OperatorNodeSearchItem.this.targetIx);
                }
                result = ((ValueNode)targetFind).getValue().equals(outcome);
            } else {
                ValueNode targetImage;
                this.image = targetImage = this.factory.createValueNode(OperatorNodeSearchItem.this.operation.getResultAlgebra(), outcome);
                result = this.write();
            }
            return result;
        }

        @Override
        void erase() {
            if (this.image != null) {
                this.search.putNode(OperatorNodeSearchItem.this.targetIx, null);
            }
        }

        @Override
        boolean write() {
            return this.image == null || this.search.putNode(OperatorNodeSearchItem.this.targetIx, this.image);
        }

        private Object calculateResult() throws IllegalArgumentException {
            Object[] operands = new Object[OperatorNodeSearchItem.this.arguments.size()];
            int i = 0;
            while (i < OperatorNodeSearchItem.this.arguments.size()) {
                HostNode operandImage = this.search.getNode(OperatorNodeSearchItem.this.argumentIxs[i]);
                if (!(operandImage instanceof ValueNode)) {
                    return null;
                }
                operands[i] = ((ValueNode)operandImage).getValue();
                ++i;
            }
            try {
                Object result = OperatorNodeSearchItem.this.operation.apply(Arrays.asList(operands));
                return result;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
    }
}

