/*
 * Decompiled with CFR 0.152.
 */
package groove.match.rete;

import groove.grammar.rule.RuleElement;
import groove.match.rete.AbstractReteMatch;
import groove.match.rete.ReteNetwork;
import groove.match.rete.ReteNetworkNode;
import groove.match.rete.ReteSimpleMatch;
import groove.match.rete.ReteStateSubscriber;
import groove.util.collect.TreeHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class DisconnectedSubgraphChecker
extends ReteNetworkNode
implements ReteStateSubscriber {
    private RuleElement[] pattern;
    protected HashMap<ReteNetworkNode, TreeHashSet<AbstractReteMatch>> partialMatches = new HashMap();
    private int matchesProduced = 0;

    public DisconnectedSubgraphChecker(ReteNetwork network, List<ReteNetwork.ReteStaticMapping> antecedents) {
        super(network);
        assert (antecedents.size() > 1);
        this.getOwner().getState().subscribe(this);
        this.connectToAntecedents(antecedents);
    }

    private void connectToAntecedents(List<ReteNetwork.ReteStaticMapping> antecedents) {
        ArrayList<RuleElement> tempPatternList = new ArrayList<RuleElement>();
        Collections.sort(antecedents, new Comparator<ReteNetwork.ReteStaticMapping>(){

            @Override
            public int compare(ReteNetwork.ReteStaticMapping o1, ReteNetwork.ReteStaticMapping o2) {
                return o1.getNNode().hashCode() - o2.getNNode().hashCode();
            }
        });
        for (ReteNetwork.ReteStaticMapping ant : antecedents) {
            RuleElement[] pat = ant.getNNode().getPattern();
            int j = 0;
            while (j < pat.length) {
                tempPatternList.add(pat[j]);
                ++j;
            }
            this.addAntecedent(ant.getNNode());
            ant.getNNode().addSuccessor(this);
        }
        this.pattern = new RuleElement[tempPatternList.size()];
        tempPatternList.toArray(this.pattern);
    }

    @Override
    public void receive(ReteNetworkNode source, int repeatIndex, AbstractReteMatch match) {
        this.produceAndSendDownNewMatches(source, repeatIndex, match);
    }

    protected void produceAndSendDownNewMatches(ReteNetworkNode antecedent, int repeatIndex, AbstractReteMatch m) {
        TreeHashSet<AbstractReteMatch> c = this.getPartialMatchesFor(antecedent);
        if (c.isEmpty() || repeatIndex == 0) {
            c.add(m);
            m.addContainerCollection(c);
            List<AbstractReteMatch> completeMatches = this.makeWholeMatchesIfPossible(antecedent, repeatIndex, m);
            if (completeMatches != null) {
                this.matchesProduced += completeMatches.size();
                for (AbstractReteMatch completeMatch : completeMatches) {
                    this.passDownMatchToSuccessors(completeMatch);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected List<AbstractReteMatch> makeWholeMatchesIfPossible(ReteNetworkNode antecedent, int repeatIndex, AbstractReteMatch newMatch) {
        block9: {
            result = null;
            jumpIndex = this.getAntecedents().indexOf(antecedent) + repeatIndex;
            isPossible = true;
            for (ReteNetworkNode nnode : this.getAntecedents()) {
                if (antecedent == nnode) continue;
                v0 = isPossible = this.getPartialMatchesFor(nnode).size() > 0;
                if (!isPossible) break;
            }
            if (!isPossible) break block9;
            result = new ArrayList<ReteSimpleMatch>();
            partialMatchIterators = new Iterator[this.getAntecedents().size()];
            i = 0;
            while (i < partialMatchIterators.length) {
                if (i != jumpIndex) {
                    partialMatchIterators[i] = this.getPartialMatchesFor(this.getAntecedents().get(i)).iterator();
                }
                ++i;
            }
            subMatches = new AbstractReteMatch[partialMatchIterators.length];
            subMatches[jumpIndex] = newMatch;
            j = 0;
            injective = this.getOwner().isInjective();
            ** GOTO lbl45
            {
                block10: {
                    if (partialMatchIterators[j] == null) break block10;
                    if (!partialMatchIterators[j].hasNext()) ** GOTO lbl31
                    if (j != jumpIndex) {
                        subMatches[j] = (AbstractReteMatch)partialMatchIterators[j].next();
                    }
                }
                ++j;
                block3: do {
                    if (j < partialMatchIterators.length) continue block2;
lbl31:
                    // 2 sources

                    if (j != partialMatchIterators.length) continue;
                    m = ReteSimpleMatch.merge(this, subMatches, injective);
                    if (m != null) {
                        result.add(m);
                    }
                    --j;
                    while (j >= 0) {
                        if (partialMatchIterators[j] != null) {
                            if (partialMatchIterators[j].hasNext()) continue block3;
                            partialMatchIterators[j] = this.getPartialMatchesFor(this.getAntecedents().get(j)).iterator();
                            --j;
                            continue;
                        }
                        --j;
                    }
lbl45:
                    // 4 sources

                } while (j >= 0);
            }
        }
        return result;
    }

    protected TreeHashSet<AbstractReteMatch> getPartialMatchesFor(ReteNetworkNode antecedent) {
        TreeHashSet<AbstractReteMatch> result = this.partialMatches.get(antecedent);
        if (result == null) {
            result = new TreeHashSet();
            this.partialMatches.put(antecedent, result);
        }
        return result;
    }

    @Override
    public boolean equals(ReteNetworkNode node) {
        return node == this;
    }

    @Override
    public RuleElement[] getPattern() {
        return this.pattern;
    }

    @Override
    public int size() {
        return this.pattern.length;
    }

    @Override
    public void clear() {
        this.partialMatches.clear();
    }

    @Override
    public List<? extends Object> initialize() {
        return null;
    }

    @Override
    public boolean demandUpdate() {
        boolean result = false;
        if (!this.isUpToDate()) {
            for (ReteNetworkNode nnode : this.getAntecedents()) {
                boolean bl = result = result || nnode.demandUpdate();
            }
            this.setUpToDate(true);
        }
        return result;
    }

    @Override
    public int demandOneMatch() {
        this.matchesProduced = 0;
        this.demandUpdate();
        return this.matchesProduced;
    }

    @Override
    public void updateBegin() {
    }

    @Override
    public void updateEnd() {
    }
}

