/*
 * Decompiled with CFR 0.152.
 */
package groove.match.rete;

import groove.algebra.Constant;
import groove.automaton.RegExpr;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostEdgeSet;
import groove.grammar.host.HostNode;
import groove.grammar.host.ValueNode;
import groove.grammar.rule.LabelVar;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleElement;
import groove.grammar.rule.RuleLabel;
import groove.grammar.rule.RuleNode;
import groove.grammar.rule.VariableNode;
import groove.grammar.type.TypeEdge;
import groove.grammar.type.TypeElement;
import groove.grammar.type.TypeGuard;
import groove.grammar.type.TypeNode;
import groove.match.rete.AbstractReteMatch;
import groove.match.rete.ConditionChecker;
import groove.match.rete.DisconnectedSubgraphChecker;
import groove.match.rete.ReteNetwork;
import groove.match.rete.ReteNetworkNode;
import groove.match.rete.ReteSimpleMatch;
import groove.match.rete.ReteStateSubscriber;
import groove.match.rete.SubgraphCheckerNode;
import groove.util.Reporter;
import groove.util.collect.TreeHashSet;
import java.util.List;

public class EdgeCheckerNode
extends ReteNetworkNode
implements ReteStateSubscriber {
    private RuleElement[] pattern = new RuleElement[1];
    private HostEdgeSet ondemandBuffer = new HostEdgeSet();
    private TreeHashSet<ReteSimpleMatch> memory = new TreeHashSet();
    protected static final Reporter reporter = Reporter.register(EdgeCheckerNode.class);
    protected static final Reporter receiveEdgeReporter = reporter.register("receiveEdge(source, gEdge, action)");
    protected boolean selfEdge = false;
    protected TypeEdge type;
    protected TypeNode sourceType;
    protected TypeNode targetType;
    protected RuleEdge edge;
    protected RuleNode sourceNode;
    protected RuleNode targetNode;

    public EdgeCheckerNode(ReteNetwork network, RuleEdge e) {
        super(network);
        this.edge = e;
        this.pattern[0] = e;
        this.type = e.getType();
        this.sourceType = ((RuleNode)e.source()).isSharp() || this.type == null || this.sourceType != this.type.source() ? ((RuleNode)e.source()).getType() : null;
        this.targetType = ((RuleNode)e.target()).isSharp() || this.type == null || this.targetType != this.type.target() ? ((RuleNode)e.target()).getType() : null;
        this.selfEdge = ((RuleNode)e.source()).equals(e.target());
        this.sourceNode = (RuleNode)e.source();
        this.targetNode = (RuleNode)e.target();
        this.getPatternLookupTable();
        this.getOwner().getState().subscribe(this);
    }

    @Override
    public void addSuccessor(ReteNetworkNode nnode) {
        boolean isValid;
        boolean bl = isValid = nnode instanceof SubgraphCheckerNode || nnode instanceof ConditionChecker || nnode instanceof DisconnectedSubgraphChecker;
        assert (isValid);
        if (isValid) {
            super.addSuccessor(nnode);
        }
    }

    public boolean canBeMappedToEdge(HostEdge e) {
        assert (!(this.isWildcardEdge() ? !((RuleLabel)this.edge.label()).getMatchExpr().getWildcardGuard().isSatisfied(e.getType()) : !this.edge.getType().equals(e.getType())));
        return !(this.type != null && !this.type.subsumes(e.getType()) || !this.checkSourceType(e.source()) || !this.checkTargetType(e.target()) || !this.checkValues(this.sourceNode, e.source()) || !this.checkValues(this.targetNode, e.target()) || this.selfEdge && !e.source().equals(e.target()));
    }

    boolean checkSourceType(HostNode imageSource) {
        return this.sourceType == null || this.sourceType.subsumes(imageSource.getType(), this.sourceNode.isSharp());
    }

    boolean checkTargetType(HostNode imageTarget) {
        return this.targetType == null || this.targetType.subsumes(imageTarget.getType(), this.targetNode.isSharp());
    }

    private boolean checkValues(RuleNode n1, HostNode n2) {
        return !(n1 instanceof VariableNode) || n2 instanceof ValueNode && ((ValueNode)n2).getSignature().equals((Object)((VariableNode)n1).getSignature()) && this.valuesMatch((VariableNode)n1, (ValueNode)n2);
    }

    private boolean valuesMatch(VariableNode n1, ValueNode n2) {
        assert (n2.getSignature().equals((Object)n2.getSignature()));
        Constant c = n1.getConstant();
        return c == null || c.getSymbol().equals(n2.getSymbol());
    }

    public boolean isWildcardEdge() {
        return ((RuleLabel)this.edge.label()).isWildcard();
    }

    public boolean isPositiveWildcard() {
        TypeGuard lc = ((RegExpr.Wildcard)((RuleLabel)this.edge.label()).getMatchExpr()).getGuard();
        return this.isWildcardEdge() && (lc == null || !lc.isNegated());
    }

    public boolean isWildcardGuarded() {
        return this.isWildcardEdge() && ((RegExpr.Wildcard)((RuleLabel)this.edge.label()).getMatchExpr()).getGuard() != null && ((RegExpr.Wildcard)((RuleLabel)this.edge.label()).getMatchExpr()).getGuard().getLabels() != null;
    }

    public boolean isAcceptingLabel(TypeElement e) {
        RuleLabel rl = (RuleLabel)this.edge.label();
        return this.isWildcardEdge() ? rl.getWildcardGuard().isSatisfied(e) : this.edge.getType().equals(e);
    }

    public boolean canBeStaticallyMappedToEdge(RuleEdge e) {
        return ((RuleLabel)this.edge.label()).equals(e.label()) && (!this.selfEdge || e.source() == e.target()) && this.sourceNode.getType() == ((RuleNode)e.source()).getType() && this.targetNode.getType() == ((RuleNode)e.target()).getType() && this.endPointValuesStaticallyCompatible(e);
    }

    private boolean endPointValuesStaticallyCompatible(RuleEdge e) {
        return this.nodeValuesStaticallyCompatible(this.sourceNode, (RuleNode)e.source()) && this.nodeValuesStaticallyCompatible(this.targetNode, (RuleNode)e.target());
    }

    private boolean nodeValuesStaticallyCompatible(RuleNode n1, RuleNode n2) {
        boolean result;
        boolean bl = result = n1 instanceof VariableNode == n2 instanceof VariableNode;
        if (result && n1 instanceof VariableNode) {
            VariableNode vn1 = (VariableNode)n1;
            VariableNode vn2 = (VariableNode)n2;
            result = vn1.getSignature().equals((Object)vn2.getSignature());
            if (result) {
                boolean bl2 = result = vn1.getConstant() == null == (vn2.getConstant() == null);
                if (result && vn1.getConstant() != null) {
                    result = vn1.getConstant().equals(vn2.getConstant());
                }
            }
        }
        return result;
    }

    public void receiveEdge(ReteNetworkNode source, HostEdge gEdge, ReteNetworkNode.Action action) {
        receiveEdgeReporter.start();
        if (this.canBeMappedToEdge(gEdge)) {
            if (!this.getOwner().isInOnDemandMode()) {
                this.sendDownReceivedEdge(gEdge, action);
            } else if (action == ReteNetworkNode.Action.REMOVE && !this.ondemandBuffer.contains(gEdge)) {
                this.sendDownReceivedEdge(gEdge, action);
            } else {
                this.bufferReceivedEdge(gEdge, action);
            }
        }
        receiveEdgeReporter.stop();
    }

    private void bufferReceivedEdge(HostEdge edge, ReteNetworkNode.Action action) {
        if (action == ReteNetworkNode.Action.REMOVE) {
            this.ondemandBuffer.remove(edge);
        } else {
            this.ondemandBuffer.add(edge);
            this.invalidate();
        }
    }

    private void sendDownReceivedEdge(HostEdge gEdge, ReteNetworkNode.Action action) {
        LabelVar variable = this.isWildcardEdge() ? ((RuleLabel)this.edge.label()).getWildcardGuard().getVar() : null;
        ReteSimpleMatch m = variable != null ? new ReteSimpleMatch((ReteNetworkNode)this, gEdge, variable, this.getOwner().isInjective()) : new ReteSimpleMatch((ReteNetworkNode)this, gEdge, this.getOwner().isInjective());
        if (action == ReteNetworkNode.Action.ADD) {
            assert (!this.memory.contains(m));
            this.memory.add(m);
            this.passDownMatchToSuccessors(m);
        } else if (this.memory.contains(m)) {
            ReteSimpleMatch m1 = m;
            m = this.memory.put(m);
            this.memory.remove(m1);
            m.dominoDelete(null);
        }
    }

    public RuleEdge getEdge() {
        return this.edge;
    }

    @Override
    public int size() {
        return this.pattern.length;
    }

    @Override
    public boolean equals(ReteNetworkNode node) {
        return node != null && this == node;
    }

    public String toString() {
        return "Checking edge: " + this.edge.toString();
    }

    @Override
    public RuleElement[] getPattern() {
        return this.pattern;
    }

    @Override
    public boolean demandUpdate() {
        boolean result;
        boolean bl = result = this.ondemandBuffer.size() > 0;
        if (!this.isUpToDate()) {
            if (this.getOwner().isInOnDemandMode()) {
                for (HostEdge e : this.ondemandBuffer) {
                    this.sendDownReceivedEdge(e, ReteNetworkNode.Action.ADD);
                }
                this.ondemandBuffer.clear();
            }
            this.setUpToDate(true);
        }
        return result;
    }

    @Override
    public void clear() {
        this.ondemandBuffer.clear();
        this.memory.clear();
    }

    @Override
    public List<? extends Object> initialize() {
        return null;
    }

    @Override
    public int demandOneMatch() {
        int result = this.ondemandBuffer.size();
        if (this.getOwner().isInOnDemandMode() && !this.isUpToDate() && result > 0) {
            HostEdge e = (HostEdge)this.ondemandBuffer.iterator().next();
            this.ondemandBuffer.remove(e);
            this.sendDownReceivedEdge(e, ReteNetworkNode.Action.ADD);
            this.setUpToDate(this.ondemandBuffer.size() == 0);
            result = 1;
        }
        return result;
    }

    @Override
    public void receive(ReteNetworkNode source, int repeatIndex, AbstractReteMatch subgraph) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBegin() {
    }

    @Override
    public void updateEnd() {
    }
}

