/*
 * Decompiled with CFR 0.152.
 */
package groove.match.rete;

import groove.grammar.Condition;
import groove.grammar.Grammar;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.grammar.rule.Anchor;
import groove.match.SearchEngine;
import groove.match.ValueOracle;
import groove.match.rete.ReteNetwork;
import groove.match.rete.ReteNetworkNode;
import groove.match.rete.ReteSearchStrategy;
import groove.transform.DeltaStore;
import groove.util.Reporter;

public class ReteSearchEngine
extends SearchEngine {
    private final ReteNetwork network;
    public static final Reporter reporter = Reporter.register(ReteSearchEngine.class);
    public static final Reporter transitionOccurredReporter = reporter.register("transitionOccurred()");

    public ReteSearchEngine(Grammar grammar) {
        this.network = new ReteNetwork(this, grammar, grammar.getProperties().isInjective());
    }

    public ReteNetwork getNetwork() {
        return this.network;
    }

    public synchronized void transitionOccurred(HostGraph destGraph, DeltaStore deltaStore) {
        transitionOccurredReporter.start();
        if (deltaStore.size() > destGraph.size()) {
            this.network.processGraph(destGraph);
            transitionOccurredReporter.stop();
            return;
        }
        this.network.setUpdating(true);
        this.network.getState().setHostGraph(destGraph);
        for (HostNode n : deltaStore.getRemovedNodeSet()) {
            this.network.update(n, ReteNetworkNode.Action.REMOVE);
        }
        for (HostEdge e : deltaStore.getRemovedEdgeSet()) {
            this.network.update(e, ReteNetworkNode.Action.REMOVE);
        }
        for (HostNode n : deltaStore.getAddedNodeSet()) {
            this.network.update(n, ReteNetworkNode.Action.ADD);
        }
        for (HostEdge e : deltaStore.getAddedEdgeSet()) {
            this.network.update(e, ReteNetworkNode.Action.ADD);
        }
        this.network.setUpdating(false);
        transitionOccurredReporter.stop();
    }

    @Override
    public synchronized ReteSearchStrategy createMatcher(Condition condition, Anchor seed, ValueOracle oracle) {
        return new ReteSearchStrategy(this, condition, oracle);
    }
}

