/*
 * Decompiled with CFR 0.152.
 */
package groove.match.rete;

import groove.grammar.host.HostNode;
import groove.grammar.host.HostNodeSet;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleElement;
import groove.grammar.rule.RuleNode;
import groove.graph.Node;
import groove.match.rete.AbstractPathChecker;
import groove.match.rete.AbstractReteMatch;
import groove.match.rete.ConditionChecker;
import groove.match.rete.DataOperatorChecker;
import groove.match.rete.DisconnectedSubgraphChecker;
import groove.match.rete.JoinStrategy;
import groove.match.rete.LookupEntry;
import groove.match.rete.ReteNetwork;
import groove.match.rete.ReteNetworkNode;
import groove.match.rete.RetePathMatch;
import groove.match.rete.ReteSimpleMatch;
import groove.match.rete.ReteStateSubscriber;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SubgraphCheckerNode<LeftMatchType extends AbstractReteMatch, RightMatchType extends AbstractReteMatch>
extends ReteNetworkNode
implements ReteStateSubscriber {
    protected HashSet<LeftMatchType> leftOnDemandBuffer = new HashSet();
    protected HashSet<LeftMatchType> leftMemory = new HashSet();
    protected HashSet<RightMatchType> rightOnDemandBuffer = new HashSet();
    protected HashSet<RightMatchType> rightMemory = new HashSet();
    private LookupEntry[] leftLookupTable;
    private LookupEntry[] rightLookupTable;
    protected RuleElement[] pattern;
    protected boolean shouldPreservePrefix = false;
    protected JoinStrategy<LeftMatchType, RightMatchType> joinStrategy;

    protected SubgraphCheckerNode(ReteNetwork network, ReteNetwork.ReteStaticMapping left, ReteNetwork.ReteStaticMapping right, boolean keepPrefix) {
        super(network);
        this.shouldPreservePrefix = keepPrefix;
        this.getOwner().getState().subscribe(this);
        left.getNNode().addSuccessor(this);
        this.addAntecedent(left.getNNode());
        right.getNNode().addSuccessor(this);
        this.addAntecedent(right.getNNode());
        this.copyPatternsFromAntecedents();
        this.staticJoin(left, right);
        this.selectJoinStrategy(left, right);
    }

    protected void selectJoinStrategy(ReteNetwork.ReteStaticMapping left, ReteNetwork.ReteStaticMapping right) {
        if (!(left.getNNode() instanceof AbstractPathChecker) && !(right.getNNode() instanceof AbstractPathChecker)) {
            this.joinStrategy = new AbstractSimpleTestJoinStrategy<ReteSimpleMatch, ReteSimpleMatch>(this){

                @Override
                public AbstractReteMatch construct(ReteSimpleMatch left, ReteSimpleMatch right) {
                    return ReteSimpleMatch.merge((ReteNetworkNode)this.subgraphChecker, left, right, this.subgraphChecker.getOwner().isInjective(), this.subgraphChecker.shouldPreservePrefix);
                }
            };
        } else if (right.getNNode() instanceof AbstractPathChecker) {
            this.joinStrategy = new AbstractJoinWithPathStrategy<AbstractReteMatch>(this){

                @Override
                public AbstractReteMatch construct(AbstractReteMatch left, RetePathMatch right) {
                    return right.isEmpty() ? this.mergeWithEmptyPath(left, right) : ReteSimpleMatch.merge((ReteNetworkNode)this.subgraphChecker, left, right, this.subgraphChecker.getOwner().isInjective(), this.subgraphChecker.shouldPreservePrefix);
                }
            };
        } else if (left.getNNode() instanceof AbstractPathChecker) {
            this.joinStrategy = new AbstractSimpleTestJoinStrategy<RetePathMatch, AbstractReteMatch>(this){

                @Override
                public AbstractReteMatch construct(RetePathMatch left, AbstractReteMatch right) {
                    return ReteSimpleMatch.merge((ReteNetworkNode)this.subgraphChecker, left, right, this.subgraphChecker.getOwner().isInjective(), this.subgraphChecker.shouldPreservePrefix);
                }
            };
        } else {
            throw new UnsupportedOperationException(String.format("Left is of type %s and right is of type %s", left.getNNode().getClass().toString(), right.getNNode().getClass().toString()));
        }
    }

    public SubgraphCheckerNode(ReteNetwork network, ReteNetwork.ReteStaticMapping left, ReteNetwork.ReteStaticMapping right) {
        this(network, left, right, false);
    }

    protected void copyPatternsFromAntecedents() {
        assert (this.getAntecedents().size() == 2);
        RuleElement[] leftAntecedentPattern = this.getAntecedents().get(0).getPattern();
        RuleElement[] rightAntecedentPattern = this.getAntecedents().get(1).getPattern();
        this.pattern = new RuleElement[leftAntecedentPattern.length + rightAntecedentPattern.length];
        int i = 0;
        while (i < leftAntecedentPattern.length) {
            this.pattern[i] = leftAntecedentPattern[i];
            ++i;
        }
        while (i < this.pattern.length) {
            this.pattern[i] = rightAntecedentPattern[i - leftAntecedentPattern.length];
            ++i;
        }
    }

    private void staticJoin(ReteNetwork.ReteStaticMapping leftMap, ReteNetwork.ReteStaticMapping rightMap) {
        Set<RuleNode> s1 = leftMap.getLhsNodes();
        Set<RuleNode> s2 = rightMap.getLhsNodes();
        HashSet<RuleNode> intersection = new HashSet<RuleNode>();
        for (RuleNode n1 : s1) {
            if (!s2.contains(n1)) continue;
            intersection.add(n1);
        }
        this.leftLookupTable = new LookupEntry[intersection.size()];
        this.rightLookupTable = new LookupEntry[intersection.size()];
        int i = 0;
        for (RuleNode n : intersection) {
            this.leftLookupTable[i] = leftMap.locateNode(n);
            this.rightLookupTable[i] = rightMap.locateNode(n);
            ++i;
        }
    }

    @Override
    public void addSuccessor(ReteNetworkNode nnode) {
        boolean isValid;
        boolean bl = isValid = nnode instanceof SubgraphCheckerNode || nnode instanceof ConditionChecker || nnode instanceof DataOperatorChecker || nnode instanceof DisconnectedSubgraphChecker;
        assert (isValid);
        if (isValid) {
            super.addSuccessor(nnode);
        }
    }

    protected boolean isLeftAntecedent(ReteNetworkNode antecedent, boolean first) {
        if (this.getAntecedents().get(0) == this.getAntecedents().get(1)) {
            return first;
        }
        return this.getAntecedents().get(0) == antecedent;
    }

    protected boolean unbufferMatch(ReteNetworkNode source, boolean first, AbstractReteMatch subgraph) {
        assert (!subgraph.isDeleted());
        return this.isLeftAntecedent(source, first) ? this.unbufferMatch(source, this.leftOnDemandBuffer, subgraph) : this.unbufferMatch(source, this.rightOnDemandBuffer, subgraph);
    }

    private <E extends AbstractReteMatch> boolean unbufferMatch(ReteNetworkNode source, HashSet<E> memory, E match) {
        assert (!match.isDeleted());
        boolean result = memory.remove(match);
        if (result) {
            match.removeContainerCollection(memory);
        }
        return result;
    }

    protected void bufferMatch(ReteNetworkNode source, boolean first, AbstractReteMatch subgraph) {
        if (this.isLeftAntecedent(source, first)) {
            this.bufferMatch(source, this.leftOnDemandBuffer, subgraph);
        } else {
            this.bufferMatch(source, this.rightOnDemandBuffer, subgraph);
        }
    }

    protected <E extends AbstractReteMatch> void bufferMatch(ReteNetworkNode source, HashSet<E> memory, E match) {
        memory.add(match);
        match.addContainerCollection(memory);
        this.invalidate();
    }

    public LookupEntry[] getLeftLookupTable() {
        return this.leftLookupTable;
    }

    public LookupEntry[] getRightLookupTable() {
        return this.rightLookupTable;
    }

    @Override
    public void receive(ReteNetworkNode source, int repeatIndex, AbstractReteMatch subgraph) {
        if (this.getOwner().isInOnDemandMode()) {
            this.bufferMatch(source, repeatIndex == 0, subgraph);
        } else {
            this.receiveAndProcess(source, repeatIndex == 0, subgraph);
        }
    }

    protected int receiveAndProcess(ReteNetworkNode source, boolean first, AbstractReteMatch subgraph) {
        int result = 0;
        boolean sourceIsLeft = this.isLeftAntecedent(source, first);
        HashSet<Object> memory = sourceIsLeft ? this.leftMemory : this.rightMemory;
        HashSet<Object> otherMemory = memory == this.leftMemory ? this.rightMemory : this.leftMemory;
        memory.add(subgraph);
        subgraph.addContainerCollection(memory);
        for (AbstractReteMatch abstractReteMatch : otherMemory) {
            AbstractReteMatch right;
            AbstractReteMatch left = sourceIsLeft ? subgraph : abstractReteMatch;
            AbstractReteMatch abstractReteMatch2 = right = sourceIsLeft ? abstractReteMatch : subgraph;
            if (!this.joinStrategy.test(left, right)) continue;
            ++result;
            AbstractReteMatch combined = this.joinStrategy.construct(left, right);
            if (combined == null) continue;
            this.passDownMatchToSuccessors(combined);
        }
        return result;
    }

    @Override
    public boolean equals(ReteNetworkNode node) {
        return node == this;
    }

    public ReteNetworkNode getOtherAntecedent(ReteNetworkNode oneAntecedent) {
        ReteNetworkNode result = null;
        List<ReteNetworkNode> aSet = this.getAntecedents();
        assert (aSet.size() > 1);
        for (ReteNetworkNode n : aSet) {
            if (n == oneAntecedent) continue;
            result = n;
            break;
        }
        return result;
    }

    public boolean checksValidSubgraph(ReteNetwork.ReteStaticMapping oneMapping, ReteNetwork.ReteStaticMapping otherMapping) {
        RuleElement e;
        ReteNetwork.ReteStaticMapping[][] combinationChoices;
        assert (this.getAntecedents().contains(oneMapping.getNNode()) && this.getAntecedents().contains(otherMapping.getNNode()));
        if (oneMapping.getNNode() != otherMapping.getNNode()) {
            ReteNetwork.ReteStaticMapping lm = this.getAntecedents().get(0) == oneMapping.getNNode() ? oneMapping : otherMapping;
            ReteNetwork.ReteStaticMapping rm = lm == oneMapping ? otherMapping : oneMapping;
            combinationChoices = new ReteNetwork.ReteStaticMapping[][]{{lm, rm}};
        } else {
            combinationChoices = new ReteNetwork.ReteStaticMapping[][]{{oneMapping, otherMapping}, {otherMapping, oneMapping}};
        }
        boolean result = true;
        HashSet<RuleEdge> s1 = new HashSet<RuleEdge>();
        Object object = oneMapping.getElements();
        int n = ((RuleElement[])object).length;
        int n2 = 0;
        while (n2 < n) {
            e = object[n2];
            if (e instanceof RuleEdge) {
                s1.add((RuleEdge)e);
            }
            ++n2;
        }
        object = otherMapping.getElements();
        n = ((RuleElement[])object).length;
        n2 = 0;
        while (n2 < n) {
            e = object[n2];
            if (e instanceof RuleEdge && s1.contains(e)) {
                result = false;
                break;
            }
            ++n2;
        }
        Set<RuleNode> nodes1 = oneMapping.getLhsNodes();
        HashSet<RuleNode> sharedNodes = new HashSet<RuleNode>();
        for (RuleNode n3 : otherMapping.getLhsNodes()) {
            if (!nodes1.contains(n3)) continue;
            sharedNodes.add(n3);
        }
        int i = 0;
        while (result && i < combinationChoices.length) {
            ReteNetwork.ReteStaticMapping leftMapping = combinationChoices[i][0];
            ReteNetwork.ReteStaticMapping rightMapping = combinationChoices[i][1];
            HashSet<RuleNode> tempSharedNodes = sharedNodes;
            int j = 0;
            while (j < this.leftLookupTable.length) {
                Node rightMappedValue;
                LookupEntry leftEntry = this.leftLookupTable[j];
                LookupEntry rightEntry = this.rightLookupTable[j];
                Node leftMappedValue = leftEntry.lookup(leftMapping.getElements());
                result = leftMappedValue.equals(rightMappedValue = rightEntry.lookup(rightMapping.getElements()));
                if (!result) break;
                tempSharedNodes.remove(leftMappedValue);
                ++j;
            }
            result = result && tempSharedNodes.isEmpty();
            ++i;
        }
        return result;
    }

    @Override
    public int size() {
        return this.pattern.length;
    }

    public boolean isDisjointMerger() {
        return this.leftLookupTable.length == 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("- Subgraph Checker\n");
        sb.append("--  Edge Set-\n");
        int i = 0;
        while (i < this.pattern.length) {
            sb.append("-- " + i + " -" + this.pattern[i].toString().replace(':', '-') + "\n");
            ++i;
        }
        sb.append("--- Equalities-\n");
        i = 0;
        while (i < this.leftLookupTable.length) {
            sb.append(String.format("--- left[%d]%s = right[%d]%s \n", this.leftLookupTable[i].getPos(), this.leftLookupTable[i].getRole() == LookupEntry.Role.NODE ? "" : (this.leftLookupTable[i].getRole() == LookupEntry.Role.SOURCE ? ".source" : ".target"), this.rightLookupTable[i].getPos(), this.rightLookupTable[i].getRole() == LookupEntry.Role.NODE ? "" : (this.rightLookupTable[i].getRole() == LookupEntry.Role.SOURCE ? ".source" : ".target")));
            ++i;
        }
        return sb.toString();
    }

    @Override
    public void clear() {
        this.leftOnDemandBuffer.clear();
        this.leftMemory.clear();
        this.rightOnDemandBuffer.clear();
        this.rightMemory.clear();
    }

    @Override
    public List<? extends Object> initialize() {
        return null;
    }

    @Override
    public RuleElement[] getPattern() {
        return this.pattern;
    }

    @Override
    public boolean demandUpdate() {
        boolean result = false;
        if (!this.isUpToDate()) {
            if (this.getOwner().isInOnDemandMode()) {
                for (ReteNetworkNode nnode : this.getAntecedents()) {
                    nnode.demandUpdate();
                }
                boolean bl = result = this.leftOnDemandBuffer.size() + this.rightOnDemandBuffer.size() > 0;
                if (result) {
                    int newMatchCounter = 0;
                    result = false;
                    for (AbstractReteMatch m : this.leftOnDemandBuffer) {
                        assert (!m.isDeleted());
                        m.removeContainerCollection(this.leftOnDemandBuffer);
                        newMatchCounter += this.receiveAndProcess(m.getOrigin(), true, m);
                    }
                    this.leftOnDemandBuffer.clear();
                    boolean first = this.getAntecedents().get(0) != this.getAntecedents().get(1);
                    for (AbstractReteMatch m : this.rightOnDemandBuffer) {
                        assert (!m.isDeleted());
                        m.removeContainerCollection(this.rightOnDemandBuffer);
                        newMatchCounter += this.receiveAndProcess(m.getOrigin(), first, m);
                    }
                    this.rightOnDemandBuffer.clear();
                    result = newMatchCounter > 0;
                }
            }
            this.setUpToDate(true);
        }
        return result;
    }

    @Override
    public int demandOneMatch() {
        int result = 0;
        if (!this.isUpToDate() && this.getOwner().isInOnDemandMode()) {
            boolean first;
            HashSet<Object> theBuffer = this.rightOnDemandBuffer;
            ReteNetworkNode theAntecedent = this.getAntecedents().get(1);
            boolean bl = first = this.getAntecedents().get(0) != this.getAntecedents().get(1);
            while (true) {
                if (theBuffer.size() != 0 || theAntecedent.demandOneMatch() != 0) {
                    AbstractReteMatch m = (AbstractReteMatch)theBuffer.iterator().next();
                    theBuffer.remove(m);
                    m.removeContainerCollection(theBuffer);
                    if ((result += this.receiveAndProcess(m.getOrigin(), first, m)) == 0) continue;
                }
                if (result != 0 || theBuffer != this.rightOnDemandBuffer) break;
                theBuffer = this.leftOnDemandBuffer;
                theAntecedent = this.getAntecedents().get(0);
                first = true;
                if (result != 0) break;
            }
        }
        return result;
    }

    public static SubgraphCheckerNode<?, ?> create(ReteNetwork network, ReteNetwork.ReteStaticMapping left, ReteNetwork.ReteStaticMapping right, boolean keepPrefix) {
        if (left.getNNode() instanceof AbstractPathChecker && right.getNNode() instanceof AbstractPathChecker) {
            return new SubgraphCheckerNode(network, left, right, keepPrefix);
        }
        if (!(left.getNNode() instanceof AbstractPathChecker) && right.getNNode() instanceof AbstractPathChecker) {
            return new SubgraphCheckerNode(network, left, right, keepPrefix);
        }
        if (left.getNNode() instanceof AbstractPathChecker && !(right.getNNode() instanceof AbstractPathChecker)) {
            return new SubgraphCheckerNode(network, left, right, keepPrefix);
        }
        if (!(left.getNNode() instanceof AbstractPathChecker) && !(right.getNNode() instanceof AbstractPathChecker)) {
            return new SubgraphCheckerNode(network, left, right, keepPrefix);
        }
        throw new UnsupportedOperationException("Antecent types are not supported.");
    }

    @Override
    public void updateBegin() {
    }

    @Override
    public void updateEnd() {
    }

    protected static abstract class AbstractJoinWithPathStrategy<LT extends AbstractReteMatch>
    extends AbstractSimpleTestJoinStrategy<LT, RetePathMatch> {
        protected LookupEntry leftPathStartEntry = null;
        protected LookupEntry leftPathEndEntry = null;

        public AbstractJoinWithPathStrategy(SubgraphCheckerNode<?, ?> sgChecker) {
            super(sgChecker);
            int i = 0;
            while (i < ((SubgraphCheckerNode)sgChecker).leftLookupTable.length) {
                LookupEntry leftEquality = ((SubgraphCheckerNode)sgChecker).leftLookupTable[i];
                LookupEntry rightEquality = ((SubgraphCheckerNode)sgChecker).rightLookupTable[i];
                if (rightEquality.getRole() == LookupEntry.Role.SOURCE) {
                    this.leftPathStartEntry = leftEquality;
                    if (((SubgraphCheckerNode)sgChecker).leftLookupTable.length == 1) {
                        this.leftPathEndEntry = this.leftPathStartEntry;
                    }
                } else if (rightEquality.getRole() == LookupEntry.Role.TARGET) {
                    this.leftPathEndEntry = leftEquality;
                    if (((SubgraphCheckerNode)sgChecker).leftLookupTable.length == 1) {
                        this.leftPathStartEntry = this.leftPathEndEntry;
                    }
                }
                ++i;
            }
        }

        @Override
        public boolean test(LT left, RetePathMatch right) {
            if (right.isEmpty()) {
                return this.testJointPointNodesEquality(left);
            }
            return super.test(left, right);
        }

        private boolean testJointPointNodesEquality(LT left) {
            assert (this.subgraphChecker.leftLookupTable.length <= 2);
            if (this.subgraphChecker.leftLookupTable.length == 2) {
                Object[] leftUnits = ((AbstractReteMatch)left).getAllUnits();
                LookupEntry leftEntry = this.subgraphChecker.leftLookupTable[0];
                Node node1 = leftEntry.lookup(leftUnits);
                leftEntry = this.subgraphChecker.leftLookupTable[1];
                Node node2 = leftEntry.lookup(leftUnits);
                return node1.equals(node2);
            }
            return true;
        }

        public ReteSimpleMatch mergeWithEmptyPath(LT left, RetePathMatch emptyMatch) {
            assert (emptyMatch instanceof RetePathMatch.EmptyPathMatch);
            Object[] leftUnits = ((AbstractReteMatch)left).getAllUnits();
            HostNode node1 = (HostNode)this.leftPathStartEntry.lookup(leftUnits);
            assert (node1 == this.leftPathEndEntry.lookup(leftUnits));
            return new ReteSimpleMatch((ReteNetworkNode)this.subgraphChecker, this.subgraphChecker.getOwner().isInjective(), (AbstractReteMatch)left, new Object[]{new RetePathMatch.EmptyPathMatch(emptyMatch.getOrigin(), node1)});
        }
    }

    protected static abstract class AbstractSimpleTestJoinStrategy<LT extends AbstractReteMatch, RT extends AbstractReteMatch>
    implements JoinStrategy<LT, RT> {
        protected SubgraphCheckerNode<?, ?> subgraphChecker;

        public AbstractSimpleTestJoinStrategy(SubgraphCheckerNode<?, ?> sgChecker) {
            this.subgraphChecker = sgChecker;
        }

        @Override
        public boolean test(LT left, RT right) {
            boolean allEqualitiesSatisfied = true;
            boolean injective = this.subgraphChecker.getOwner().isInjective();
            Object[] leftUnits = ((AbstractReteMatch)left).getAllUnits();
            Object[] rightUnits = ((AbstractReteMatch)right).getAllUnits();
            HostNodeSet nodesLeft = injective ? ((AbstractReteMatch)left).getNodes() : null;
            HostNodeSet nodesRight = injective ? ((AbstractReteMatch)right).getNodes() : null;
            int i = 0;
            while (i < ((SubgraphCheckerNode)this.subgraphChecker).leftLookupTable.length) {
                Node n2;
                LookupEntry leftEquality = ((SubgraphCheckerNode)this.subgraphChecker).leftLookupTable[i];
                LookupEntry rightEquality = ((SubgraphCheckerNode)this.subgraphChecker).rightLookupTable[i];
                Node n1 = leftEquality.lookup(leftUnits);
                allEqualitiesSatisfied = n1.equals(n2 = rightEquality.lookup(rightUnits));
                if (!allEqualitiesSatisfied) break;
                if (injective) {
                    nodesLeft.remove(n1);
                    nodesRight.remove(n1);
                }
                ++i;
            }
            if (allEqualitiesSatisfied && injective) {
                allEqualitiesSatisfied = AbstractReteMatch.checkInjectiveOverlap(nodesLeft, nodesRight);
            }
            return allEqualitiesSatisfied;
        }
    }
}

