/*
 * Decompiled with CFR 0.152.
 */
package groove.prolog;

import gnu.prolog.database.PredicateListener;
import gnu.prolog.database.PredicateUpdatedEvent;
import gnu.prolog.database.PrologTextLoader;
import gnu.prolog.database.PrologTextLoaderError;
import gnu.prolog.database.PrologTextLoaderState;
import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.term.Term;
import gnu.prolog.vm.Environment;
import gnu.prolog.vm.PrologCode;
import gnu.prolog.vm.PrologException;
import groove.grammar.model.FormatErrorSet;
import groove.grammar.model.FormatException;
import groove.io.HTMLConverter;
import groove.prolog.GrooveState;
import groove.prolog.builtin.AlgebraPredicates;
import groove.prolog.builtin.GraphPredicates;
import groove.prolog.builtin.GroovePredicates;
import groove.prolog.builtin.LtsPredicates;
import groove.prolog.builtin.RulePredicates;
import groove.prolog.builtin.TransPredicates;
import groove.prolog.builtin.TypePredicates;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class GrooveEnvironment
extends Environment {
    private final Set<CompoundTermTag> prologTags = new TagSet();
    private final Set<CompoundTermTag> grooveTags = new TagSet();
    private final Set<CompoundTermTag> userTags = new TagSet();
    private final Map<CompoundTermTag, String> toolTipMap = new HashMap<CompoundTermTag, String>();
    private GrooveState grooveState;
    public static final AtomTerm NO_GROOVE_ENV = AtomTerm.get((String)"no_groove_environment");
    public static final Class<GroovePredicates>[] GROOVE_PREDS = new Class[]{AlgebraPredicates.class, GraphPredicates.class, LtsPredicates.class, RulePredicates.class, TransPredicates.class, TypePredicates.class};
    private static final boolean PRINT_PROLOG_FUNCTORS = false;
    private static final boolean PRINT_GROOVE_FUNCTORS = false;

    public GrooveEnvironment(InputStream stdin, OutputStream stdout) {
        super(stdin, stdout);
        this.initBuiltins();
    }

    private void initBuiltins() {
        this.prologTags.addAll(this.getModule().getPredicateTags());
        Class<GroovePredicates>[] classArray = GROOVE_PREDS;
        int n = GROOVE_PREDS.length;
        int n2 = 0;
        while (n2 < n) {
            Class<GroovePredicates> predicates = classArray[n2];
            this.toolTipMap.putAll(this.ensureLoaded(predicates));
            ++n2;
        }
        this.grooveTags.addAll(this.getModule().getPredicateTags());
        this.grooveTags.removeAll(this.prologTags);
    }

    private void printFunctors(Collection<CompoundTermTag> tags) {
        TreeSet<String> functors = new TreeSet<String>();
        HTMLConverter.HTMLTag functionTag = new HTMLConverter.HTMLTag("function");
        for (CompoundTermTag tag : tags) {
            String functor = tag.functor.value;
            if (!Character.isJavaIdentifierStart(functor.charAt(0))) continue;
            functors.add(functor);
        }
        for (String functor : functors) {
            System.out.println(functionTag.on(functor));
        }
    }

    private Map<CompoundTermTag, String> ensureLoaded(Class<? extends GroovePredicates> source) {
        Map<CompoundTermTag, String> result = null;
        try {
            GroovePredicates instance = source.newInstance();
            for (Map.Entry<CompoundTermTag, String> definition : instance.getDefinitions().entrySet()) {
                this.ensureLoaded(source, definition.getKey(), definition.getValue());
            }
            result = instance.getToolTipMap();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(String.format("Can't load predicate class %s: %s", source.getSimpleName(), e.getMessage()));
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(String.format("Can't load predicate class %s: %s", source.getSimpleName(), e.getMessage()));
        }
        return result;
    }

    private void ensureLoaded(Class<? extends GroovePredicates> source, CompoundTermTag tag, String definition) {
        DefinitionListener listener = new DefinitionListener();
        this.getModule().addPredicateListener((PredicateListener)listener);
        new PrologTextLoader(this.getPrologTextLoaderState(), (Reader)new StringReader(definition));
        this.getModule().removePredicateListener((PredicateListener)listener);
        Set<CompoundTermTag> predicates = listener.getPredicates();
        if (!predicates.contains(tag)) {
            throw new IllegalArgumentException(String.format("%s#%s_%d does not define predicate %s", source.getName(), tag.functor, tag.arity, tag));
        }
        predicates.remove(tag);
        if (!predicates.isEmpty()) {
            throw new IllegalArgumentException(String.format("%s#%s_%d defines additional predicates %s", source.getName(), tag.functor, tag.arity, predicates));
        }
        String className = this.getModule().getDefinedPredicate(tag).getJavaClassName();
        if (className != null) {
            try {
                Class<?> builtInClass = Class.forName(className);
                if (!PrologCode.class.isAssignableFrom(builtInClass)) {
                    throw new IllegalArgumentException(String.format("%s#%s_%d builds in class %s that does not subtype %s", source.getName(), tag.functor, tag.arity, className, PrologCode.class.getName()));
                }
                if (builtInClass.getAnnotation(Deprecated.class) != null) {
                    throw new IllegalArgumentException(String.format("%s#%s_%d builds in deprecated class %s", source.getName(), tag.functor, tag.arity, className, PrologCode.class.getName()));
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException(String.format("%s#%s_%d builds in non-existing class %s", source.getName(), tag.functor, tag.arity, className));
            }
        }
    }

    public void loadProgram(String program) throws FormatException {
        PrologTextLoaderState loaderState = new PrologTextLoaderState(this){
            {
                this.module = GrooveEnvironment.this.getModule();
            }
        };
        DefinitionListener listener = new DefinitionListener();
        this.getModule().addPredicateListener((PredicateListener)listener);
        try {
            new PrologTextLoader(loaderState, (Reader)new StringReader(program), null);
        }
        catch (Exception e) {
            throw new FormatException(e.getMessage(), new Object[0]);
        }
        this.getModule().removePredicateListener((PredicateListener)listener);
        this.userTags.addAll(listener.getPredicates());
        FormatErrorSet errors = new FormatErrorSet();
        for (PrologTextLoaderError error : loaderState.getErrors()) {
            errors.add("%s", error.getMessage(), error.getLine(), error.getColumn());
        }
        errors.throwException();
    }

    public GrooveState getGrooveState() {
        return this.grooveState;
    }

    public void setGrooveState(GrooveState grooveState) {
        this.grooveState = grooveState;
    }

    public Set<CompoundTermTag> getPrologTags() {
        return this.prologTags;
    }

    public Set<CompoundTermTag> getGrooveTags() {
        return this.grooveTags;
    }

    public Set<CompoundTermTag> getUserTags() {
        return this.userTags;
    }

    public void clearUserTags() {
        for (CompoundTermTag tag : this.userTags) {
            this.getModule().removeDefinedPredicate(tag);
        }
        this.userTags.clear();
    }

    public String getToolTipText(CompoundTermTag tag) {
        return this.toolTipMap.get(tag);
    }

    public static void invalidEnvironment() throws PrologException {
        throw new PrologException((Term)new CompoundTerm(PrologException.errorTag, (Term)new CompoundTerm(CompoundTermTag.get((String)"system_error", (int)1), (Term)NO_GROOVE_ENV, (Term)PrologException.errorAtom), (Term)PrologException.errorAtom), null);
    }

    private static class DefinitionListener
    implements PredicateListener {
        private Set<CompoundTermTag> predicates = new HashSet<CompoundTermTag>();

        private DefinitionListener() {
        }

        public void predicateUpdated(PredicateUpdatedEvent evt) {
            this.predicates.add(evt.getTag());
        }

        public Set<CompoundTermTag> getPredicates() {
            return this.predicates;
        }
    }

    private static class TagSet
    extends TreeSet<CompoundTermTag> {
        public TagSet() {
            super(new Comparator<CompoundTermTag>(){

                @Override
                public int compare(CompoundTermTag o1, CompoundTermTag o2) {
                    int rc = o1.functor.value.compareTo(o2.functor.value);
                    if (rc == 0) {
                        rc = o1.arity - o2.arity;
                    }
                    return rc;
                }
            });
        }
    }
}

