/*
 * Decompiled with CFR 0.152.
 */
package groove.prolog.builtin;

import groove.annotation.Signature;
import groove.annotation.ToolTipBody;
import groove.annotation.ToolTipPars;
import groove.prolog.builtin.GroovePredicates;

public class LtsPredicates
extends GroovePredicates {
    @ToolTipBody(value={"Tests if the argument is a JavaObjectTerm with a GraphState"})
    @Signature(value={"State", "@"})
    public void is_state_1() {
        this.s(":-build_in(is_state/1,'groove.prolog.builtin.lts.Predicate_is_state').");
    }

    @ToolTipBody(value={"Tests if the argument is a JavaObjectTerm with a Transition"})
    @Signature(value={"Trans", "@"})
    public void is_transition_1() {
        this.s(":-build_in(is_transition/1,'groove.prolog.builtin.lts.Predicate_is_transition').");
    }

    @ToolTipBody(value={"Retrieves one state from the current GTS"})
    @Signature(value={"State", "?"})
    @ToolTipPars(value={"A state from the GTS"})
    public void state_1() {
        this.s(":-build_in(state/1,'groove.prolog.builtin.lts.Predicate_state').");
    }

    @ToolTipBody(value={"Retrieves the currently selected state from the GTS"})
    @Signature(value={"State", "?"})
    @ToolTipPars(value={"The active state in the GTS"})
    public void active_state_1() {
        this.s(":-build_in(active_state/1,'groove.prolog.builtin.lts.Predicate_active_state').");
    }

    @ToolTipBody(value={"Retrieves the graph for a state"})
    @Signature(value={"State", "Graph", "+?"})
    @ToolTipPars(value={"A state", "The graph belonging to the state"})
    public void state_graph_2() {
        this.s(":-build_in(state_graph/2,'groove.prolog.builtin.lts.Predicate_state_graph').");
    }

    @ToolTipBody(value={"Cycles over the state graphs of the GTS"})
    @Signature(value={"Graph", "?"})
    public void state_graph_1() {
        this.s("state_graph(G):-state(GS),state_graph(GS,G).");
    }

    @ToolTipBody(value={"Tests if the graph state is closed (i.e. all transitions have been found)"})
    @Signature(value={"State", "+"})
    @ToolTipPars(value={"the graph state"})
    public void state_is_closed_1() {
        this.s(":-build_in(state_is_closed/1,'groove.prolog.builtin.lts.Predicate_state_is_closed').");
    }

    @ToolTipBody(value={"Cycles over the closed states of the GTS"})
    @Signature(value={"State", "?"})
    public void closed_state_1() {
        this.s("closed_state(GS):-state(GS),state_is_closed(GS).");
    }

    @ToolTipBody(value={"Cycles over the outgoing transitions of a state"})
    @Signature(value={"State", "Trans", "+?"})
    @ToolTipPars(value={"the state", "the transition"})
    public void state_transition_2() {
        this.s(":-build_in(state_transition/2,'groove.prolog.builtin.lts.Predicate_state_transition').");
    }

    @ToolTipBody(value={"Retireves all current outgoing transitions of a state"})
    @Signature(value={"State", "TransSet", "+?"})
    @ToolTipPars(value={"the state", "the transition set"})
    public void state_transition_set_2() {
        this.s(":-build_in(state_transition_set/2,'groove.prolog.builtin.lts.Predicate_state_transition_set').");
    }

    @ToolTipBody(value={"Cycles over the successor states of a state"})
    @Signature(value={"State", "NextState", "+?"})
    @ToolTipPars(value={"the state", "the next state"})
    public void state_next_2() {
        this.s(" :-build_in(state_next/2,'groove.prolog.builtin.lts.Predicate_state_next').");
    }

    @ToolTipBody(value={"Retrieves all successor states of a state"})
    @Signature(value={"State", "NextStateSet", "+?"})
    @ToolTipPars(value={"the state", "the next state set"})
    public void state_next_set_2() {
        this.s(":-build_in(state_next_set/2,'groove.prolog.builtin.lts.Predicate_state_next_set').");
    }

    @ToolTipBody(value={"Retrieves the source state of a transition"})
    @Signature(value={"Trans", "State", "+?"})
    @ToolTipPars(value={"the transition", "the source state"})
    public void transition_source_2() {
        this.s(":-build_in(transition_source/2,'groove.prolog.builtin.lts.Predicate_transition_source').");
    }

    @ToolTipBody(value={"Retrieves the target state of a transition"})
    @Signature(value={"Trans", "State", "+?"})
    @ToolTipPars(value={"the transition", "the target state"})
    public void transition_target_2() {
        this.s(":-build_in(transition_target/2,'groove.prolog.builtin.lts.Predicate_transition_target').");
    }

    @ToolTipBody(value={"Retrieves the rule event underlying a transition"})
    @Signature(value={"Trans", "RuleEvent", "+?"})
    @ToolTipPars(value={"the transition", "the rule event"})
    public void transition_event_2() {
        this.s(":-build_in(transition_event/2,'groove.prolog.builtin.lts.Predicate_transition_event').");
    }

    @ToolTipBody(value={"Retrieves the rule match underlying a transition"})
    @Signature(value={"Trans", "RuleMatch", "+?"})
    @ToolTipPars(value={"the transition", "the rule match"})
    public void transition_match_2() {
        this.s(" :-build_in(transition_match/2,'groove.prolog.builtin.lts.Predicate_transition_match').");
    }

    @ToolTipBody(value={"Tests if the object is a GTS"})
    @Signature(value={"GTS", "@"})
    public void is_gts_1() {
        this.s(":-build_in(is_gts/1,'groove.prolog.builtin.lts.Predicate_is_gts').");
    }

    @ToolTipBody(value={"Gets the current GTS. This can fail when not GTS is active."})
    @Signature(value={"GTS", "-"})
    public void gts_1() {
        this.s(":-build_in(gts/1,'groove.prolog.builtin.lts.Predicate_gts').");
    }

    @ToolTipBody(value={"Gets the start graph state of a GTS"})
    @Signature(value={"State", "?"})
    @ToolTipPars(value={"the start GraphState"})
    public void start_state_1() {
        this.s(":-build_in(start_state/1,'groove.prolog.builtin.lts.Predicate_start_state').");
    }

    @ToolTipBody(value={"Cycles over the final states of a GTS"})
    @Signature(value={"State", "?"})
    @ToolTipPars(value={"the start GraphState"})
    public void final_state_1() {
        this.s(" :-build_in(final_state/1,'groove.prolog.builtin.lts.Predicate_final_state').");
    }

    @ToolTipBody(value={"Retrieves the set of final states of a GTS"})
    @Signature(value={"StateSet", "?"})
    @ToolTipPars(value={"the start GraphState"})
    public void final_state_set_1() {
        this.s(":-build_in(final_state_set/1,'groove.prolog.builtin.lts.Predicate_final_state_set').");
    }

    @ToolTipBody(value={"Cycles over the rule events of the outgoing transitions of a graph state"})
    @Signature(value={"GraphState", "RuleEvent", "+?"})
    @ToolTipPars(value={"the graphstate", "the ruleevent"})
    public void state_ruleevent_2() {
        this.s(":-build_in(state_ruleevent/2,'groove.prolog.builtin.lts.Predicate_state_ruleevent').");
    }

    @ToolTipBody(value={"Cycles over all rule events in the current GTS"})
    @Signature(value={"RuleEvent", "?"})
    public void ruleevent_1() {
        this.s("ruleevent(RE):-state(GS),state_ruleevent(GS,RE).");
    }
}

