/*
 * Decompiled with CFR 0.152.
 */
package groove.prolog.util;

import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.Term;
import gnu.prolog.vm.BacktrackInfo;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import java.util.Iterator;

public class PrologStringCollectionIterator
extends BacktrackInfo {
    protected Iterator<String> iterator;
    protected Term destTerm;
    protected int startUndoPosition;

    public PrologStringCollectionIterator(Iterable<String> iterable, Term destination, int undoPosition) {
        this(iterable.iterator(), destination, undoPosition);
    }

    public PrologStringCollectionIterator(Iterator<String> iterable, Term destination, int undoPosition) {
        super(-1, -1);
        this.iterator = iterable;
        this.destTerm = destination;
        this.startUndoPosition = undoPosition;
    }

    public int getUndoPosition() {
        return this.startUndoPosition;
    }

    public int nextSolution(Interpreter interpreter) throws PrologException {
        while (this.iterator.hasNext()) {
            AtomTerm term = AtomTerm.get((String)this.iterator.next());
            int rc = interpreter.unify(this.destTerm, (Term)term);
            if (rc == -1) {
                interpreter.undo(this.startUndoPosition);
                continue;
            }
            interpreter.pushBacktrackInfo((BacktrackInfo)this);
            return 0;
        }
        return -1;
    }
}

