/*
 * Decompiled with CFR 0.152.
 */
package groove.transform;

import groove.grammar.host.HostEdge;
import groove.grammar.host.HostElement;
import groove.grammar.host.HostFactory;
import groove.grammar.host.HostNode;
import groove.grammar.host.HostNodeSet;
import groove.grammar.host.ValueNode;
import groove.graph.AElementMap;
import groove.graph.Morphism;
import groove.graph.Node;
import java.util.Map;

public class MergeMap
extends Morphism<HostNode, HostEdge> {
    private final HostNodeSet mergeTargets = new HostNodeSet();
    private static final HostNode UNDEFINED = ValueNode.DUMMY_NODE;

    public MergeMap(HostFactory factory) {
        super(factory);
    }

    @Override
    public HostNode getNode(Node key) {
        assert (key instanceof HostNode);
        return this.internalToExternal((HostNode)super.getNode(key), (HostNode)key);
    }

    @Override
    public HostNode putNode(HostNode key, HostNode value) {
        HostNode keyImage = this.getNode(key);
        HostNode valueImage = this.getNode(value);
        if (valueImage == UNDEFINED) {
            this.removeNode(key);
        } else if (keyImage != valueImage) {
            if (keyImage == null) {
                this.removeNode(valueImage);
            } else if (valueImage == null) {
                this.removeNode(keyImage);
            } else {
                this.merge(keyImage, valueImage);
            }
        }
        return keyImage;
    }

    @Override
    public void putAll(AElementMap<HostNode, HostEdge, HostNode, HostEdge> other) {
        for (Map.Entry<HostNode, HostNode> entry : other.nodeMap().entrySet()) {
            this.putNode(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<HostElement, HostElement> entry : other.edgeMap().entrySet()) {
            this.putEdge((HostEdge)entry.getKey(), (HostEdge)entry.getValue());
        }
    }

    @Override
    public HostEdge mapEdge(HostEdge key) {
        Map nodeMap = this.nodeMap();
        if (!nodeMap.containsKey(key.source()) && !nodeMap.containsKey(key.target())) {
            return key;
        }
        return (HostEdge)super.mapEdge(key);
    }

    private void merge(HostNode key, HostNode image) {
        assert (key != null && image != null) : "Merging " + key + " and " + image + " not correct: neither should be null";
        super.putNode(key, image);
        this.mergeTargets.add(image);
        if (this.mergeTargets.remove(key)) {
            for (Map.Entry<HostNode, HostNode> entry : this.nodeMap().entrySet()) {
                if (entry.getValue() != key) continue;
                this.setValue(entry, image);
            }
        }
    }

    @Override
    public HostNode removeNode(HostNode key) {
        HostNode keyImage = this.getNode(key);
        if (keyImage != null) {
            super.putNode(keyImage, UNDEFINED);
            if (this.mergeTargets.remove(keyImage)) {
                for (Map.Entry entry : this.nodeMap().entrySet()) {
                    if (entry.getValue() != keyImage) continue;
                    entry.setValue(UNDEFINED);
                }
            }
        }
        return keyImage;
    }

    private void setValue(Map.Entry<HostNode, HostNode> entry, HostNode value) {
        entry.setValue(this.externalToInternal(value, entry.getKey()));
    }

    private HostNode externalToInternal(HostNode value, HostNode key) {
        if (value == key) {
            return null;
        }
        if (value == null) {
            return UNDEFINED;
        }
        return value;
    }

    private HostNode internalToExternal(HostNode value, HostNode key) {
        if (value == null) {
            return key;
        }
        if (value == UNDEFINED) {
            return null;
        }
        return value;
    }

    protected MergeMap newMap() {
        return new MergeMap(this.getFactory());
    }

    public HostFactory getFactory() {
        return (HostFactory)super.getFactory();
    }
}

