/*
 * Decompiled with CFR 0.152.
 */
package groove.util;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class Property<S> {
    private final String comment;
    private final String description;

    public Property() {
        this(null, null);
    }

    public Property(String description) {
        this(description, null);
    }

    public Property(String description, String comment) {
        this.description = description;
        this.comment = comment;
    }

    public abstract boolean isSatisfied(S var1);

    public <C extends Collection<? extends S>> C filter(C collection) {
        Iterator<S> iter = collection.iterator();
        while (iter.hasNext()) {
            if (this.isSatisfied(iter.next())) continue;
            iter.remove();
        }
        return collection;
    }

    public boolean isEditable() {
        return true;
    }

    public String getDescription() {
        return this.description;
    }

    public String getComment() {
        return this.comment;
    }

    public static <T> Property<T> createTrue() {
        return new True();
    }

    public static class Choice<S>
    extends Property<S> {
        private final String comment;
        private final Set<S> values;

        public Choice(String comment, S ... values) {
            this.values = new HashSet<S>(Arrays.asList(values));
            this.comment = comment;
        }

        @Override
        public String getComment() {
            return this.comment;
        }

        @Override
        public String getDescription() {
            return String.format("one of %s", this.values);
        }

        @Override
        public boolean isSatisfied(S value) {
            return this.values.contains(value);
        }
    }

    public static class IsBoolean
    extends Property<String> {
        private final boolean emptyOk;
        private static final String trueString = Boolean.toString(true);
        private static final String falseString = Boolean.toString(false);
        private static final String description = String.format("%s or %s", trueString, falseString);

        protected IsBoolean(String description, String comment, boolean emptyOk) {
            super(description, comment);
            this.emptyOk = emptyOk;
        }

        public IsBoolean(String comment, boolean emptyOk) {
            this(description, comment, emptyOk);
        }

        @Override
        public boolean isSatisfied(String value) {
            return this.emptyOk && value.equals("") || value.equals(trueString) || value.equals(falseString);
        }
    }

    public static class IsEnumValue<T extends Enum<T>>
    extends Property<String> {
        private final boolean emptyOk;
        private final Class<T> enumType;

        public IsEnumValue(Class<T> enumType, boolean emptyOk) {
            super(IsEnumValue.getDescription(enumType), "Sould be " + IsEnumValue.getDescription(enumType));
            this.emptyOk = emptyOk;
            this.enumType = enumType;
        }

        @Override
        public boolean isSatisfied(String value) {
            if (value.length() == 0) {
                return this.emptyOk;
            }
            try {
                Enum.valueOf(this.enumType, value.toUpperCase());
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        private static String getDescription(Class<?> enumType) {
            StringBuilder result = new StringBuilder();
            Field[] fields = enumType.getFields();
            if (fields.length == 0) {
                return " Error : no value possible.";
            }
            int i = 1;
            while (i < fields.length) {
                if (i != 0) {
                    result.append(" or ");
                }
                result.append(fields[i].getName());
                ++i;
            }
            return result.toString();
        }
    }

    public static class True<S>
    extends Property<S> {
        public True() {
            this(null);
        }

        public True(String comment) {
            super(null, comment);
        }

        @Override
        public boolean isSatisfied(S state) {
            return true;
        }
    }

    public static class Unmodifiable<S>
    extends True<S> {
        public Unmodifiable(String comment) {
            super(comment);
        }

        @Override
        public boolean isEditable() {
            return false;
        }
    }
}

