/*
 * Decompiled with CFR 0.152.
 */
package groove.util;

import groove.util.Groove;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;

public class Reporter {
    private int topCount;
    private int nestedCount;
    private long duration;
    private int currentNesting;
    private long totalTime;
    private Reporter parent;
    private final Class<?> type;
    private final String name;
    private final Map<String, Reporter> subreporters;
    private int methodNameLength;
    private int topCountLength;
    private int nestedCountLength;
    private int totTimeLength;
    private int avgTimeLength;
    public static final int COUNT_LENGTH = 7;
    public static final int TIME_LENGTH = 6;
    public static final String INDENT = "  ";
    public static final String METHOD_FIELD = "m";
    public static final String TOP_COUNT_FIELD = "#top";
    public static final String NESTED_COUNT_FIELD = "#nest";
    public static final String TOT_TIME_FIELD = "tot(m)";
    public static final String AVG_TIME_FIELD = "avg(mu)";
    private static final boolean TIME_METHODS = true;
    private static final boolean TIME_TOP_ONLY = false;
    private static final boolean REPORT = true;
    private static Map<Class<?>, Reporter> reporters = new TreeMap(new Comparator<Class<?>>(){

        @Override
        public int compare(Class<?> o1, Class<?> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    });
    private static long reportTime;

    private Reporter(Reporter parent, String name) {
        this.parent = parent;
        this.type = parent.type;
        this.name = name;
        this.subreporters = null;
    }

    private Reporter(Class<?> type) {
        this.parent = null;
        this.type = type;
        this.name = null;
        this.subreporters = new TreeMap<String, Reporter>();
    }

    public Reporter register(String name) {
        Reporter result = this.subreporters.get(name);
        if (result == null) {
            result = new Reporter(this, name);
            this.subreporters.put(name, result);
        }
        return result;
    }

    public long getTotalTime() {
        return this.duration;
    }

    public long getAverageTime() {
        return this.duration / (long)this.getCallCount();
    }

    public int getCallCount() {
        return this.topCount + this.nestedCount;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public final synchronized void start() {
        long now = System.currentTimeMillis();
        ++this.nestedCount;
        if (this.currentNesting == 0) {
            ++this.topCount;
            this.duration -= now;
            this.parent.totalTime -= now;
        }
        ++this.currentNesting;
        reportTime += System.currentTimeMillis() - now;
    }

    public final synchronized void restart() {
        long now = System.currentTimeMillis();
        if (this.currentNesting == 0) {
            this.duration -= now;
            this.parent.totalTime -= now;
        }
        ++this.currentNesting;
        reportTime += System.currentTimeMillis() - now;
    }

    public final synchronized void stop() {
        --this.currentNesting;
        long now = System.currentTimeMillis();
        if (this.currentNesting == 0) {
            this.duration += now;
            this.parent.totalTime += now;
        }
        reportTime += System.currentTimeMillis() - now;
    }

    private void calculateFieldWidths() {
        int maxTopCount = 1;
        int maxNestedCount = 1;
        long maxTotTime = 1L;
        long maxAvgTime = 1L;
        for (Reporter subreporter : this.subreporters.values()) {
            this.methodNameLength = Math.max(subreporter.getName().length(), this.methodNameLength);
            maxTopCount = Math.max(subreporter.topCount, maxTopCount);
            maxNestedCount = Math.max(subreporter.nestedCount - subreporter.topCount, maxNestedCount);
            maxTotTime = Math.max(subreporter.duration, maxTotTime);
            long avgDuration = 0L;
            if (subreporter.nestedCount > 0) {
                avgDuration = 1000L * subreporter.duration / (long)subreporter.nestedCount;
            }
            maxAvgTime = Math.max(avgDuration, maxAvgTime);
        }
        double log10 = Math.log(10.0);
        this.topCountLength = (int)(Math.log(maxTopCount) / log10) + 1;
        this.nestedCountLength = (int)(Math.log(maxNestedCount) / log10) + 1;
        this.totTimeLength = (int)(Math.log(maxTotTime) / log10) + 1;
        this.avgTimeLength = (int)(Math.log(maxAvgTime) / log10) + 1;
    }

    private void myReport(PrintWriter out, int methodNameLength, int topCountLength, int nestedCountLength, int totTimeLength, int avgTimeLength) {
        out.println("Reporting " + this.type);
        for (Reporter subreporter : this.subreporters.values()) {
            out.print(INDENT + Groove.pad(subreporter.getName(), methodNameLength, false) + " ");
            out.print("#top=" + Groove.pad("" + subreporter.topCount, topCountLength, false) + " ");
            out.print("#nest=" + Groove.pad("" + (subreporter.nestedCount - subreporter.topCount), nestedCountLength, false) + " ");
            out.print("tot(m)=" + Groove.pad("" + subreporter.duration, totTimeLength, false) + " ");
            long avgDuration = subreporter.duration > 0L ? 1000L * subreporter.duration / (long)subreporter.nestedCount : 0L;
            out.print("avg(mu)=" + Groove.pad("" + avgDuration, avgTimeLength, false) + " ");
            out.println();
        }
    }

    public static synchronized Reporter register(Class<?> type) {
        Reporter result = reporters.get(type);
        if (result == null) {
            result = new Reporter(type);
            reporters.put(type, result);
        }
        return result;
    }

    public static synchronized void report(PrintWriter out) {
        int methodNameLength = 0;
        int topCountLength = 0;
        int nestedCountLength = 0;
        int totTimeLength = 0;
        int avgTimeLength = 0;
        int classNameLength = 0;
        for (Reporter reporter : Reporter.getAllReporters()) {
            reporter.calculateFieldWidths();
            methodNameLength = Math.max(reporter.methodNameLength, methodNameLength);
            topCountLength = Math.max(reporter.topCountLength, topCountLength);
            nestedCountLength = Math.max(reporter.nestedCountLength, nestedCountLength);
            totTimeLength = Math.max(reporter.totTimeLength, totTimeLength);
            avgTimeLength = Math.max(reporter.avgTimeLength, avgTimeLength);
            classNameLength = Math.max(reporter.type.toString().length(), classNameLength);
        }
        String title = "Method call reporting: " + new Date();
        StringBuffer line = new StringBuffer();
        int i = 0;
        while (i < title.length()) {
            line.append("=");
            ++i;
        }
        out.println(title);
        out.println(line);
        out.println();
        for (Reporter reporter : Reporter.getAllReporters()) {
            reporter.myReport(out, methodNameLength, topCountLength, nestedCountLength, totTimeLength, avgTimeLength);
            out.println();
        }
        out.println("Total measured time spent in");
        for (Reporter reporter : Reporter.getAllReporters()) {
            out.println(INDENT + Groove.pad(reporter.type.toString(), classNameLength, false) + ": " + reporter.totalTime + " ms");
        }
        out.println();
        out.println("Time spent collection information: " + Reporter.getReportTime() + " ms");
        out.flush();
    }

    private static Iterable<Reporter> getAllReporters() {
        return reporters.values();
    }

    public static long getReportTime() {
        return reportTime;
    }

    public static void report() {
        Reporter.report(new PrintWriter(System.out));
    }
}

