/*
 * Decompiled with CFR 0.152.
 */
package groove.util;

import javax.swing.JOptionPane;

public class Version {
    public static final String BUILD = "20130429221352";
    public static final String DATE = "29.04.2013";
    public static final String NUMBER = "4.8.7";
    public static final String NUMBER_JAVAMIN = "1.6";
    public static final String TITLE = "GROOVE";
    public static final String GXL_VERSION = "curly";
    public static final String GRAMMAR_VERSION_1_0 = "1.0";
    public static final String GRAMMAR_VERSION_2_0 = "2.0";
    public static final String GRAMMAR_VERSION_3_0 = "3.0";
    public static final String GRAMMAR_VERSION_3_1 = "3.1";
    public static final String GRAMMAR_VERSION_3_2 = "3.2";

    public static void main(String[] args) {
        System.out.println(Version.getAbout());
        JOptionPane.showMessageDialog(null, Version.getAboutHTML(), "About", 1);
        System.exit(0);
    }

    public static String getAbout() {
        return "GROOVE 4.8.7 (Date: 29.04.2013, build 20130429221352) - (C) University of Twente";
    }

    public static String getAboutHTML() {
        StringBuffer sb = new StringBuffer("<html><center><font size=+2>");
        sb.append(TITLE);
        sb.append("</font></center><br>Version: ");
        sb.append(NUMBER);
        sb.append("<br><font size=-2>(Date: ");
        sb.append(DATE);
        sb.append(", build: ");
        sb.append(BUILD);
        sb.append(")</font><br>Java required: ");
        sb.append(NUMBER_JAVAMIN);
        sb.append("<hr size=1>\u00a9 ");
        sb.append("University of Twente");
        sb.append("</html>");
        return sb.toString();
    }

    public static boolean isKnownGxlVersion(String version) {
        return version == null || version.isEmpty() || GXL_VERSION.equals(version);
    }

    public static String getCurrentGrammarVersion() {
        return GRAMMAR_VERSION_3_2;
    }

    public static String getCurrentGrooveVersion() {
        return NUMBER;
    }

    public static boolean isDevelopmentVersion() {
        return NUMBER.charAt(NUMBER.length() - 1) == '+';
    }

    public static String getInitialGrammarVersion() {
        return GRAMMAR_VERSION_1_0;
    }

    public static String getInitialGrooveVersion() {
        return "0.0.0";
    }

    public static int compareGrammarVersion(String version) {
        String current = Version.getCurrentGrammarVersion();
        if (current.equals(version)) {
            return 0;
        }
        String[] as1 = current.split("\\.");
        String[] as2 = version.split("\\.");
        int n1 = 0;
        int n2 = 0;
        if (as1.length > 0) {
            n1 = Integer.parseInt(as1[0]);
        }
        if (as2.length > 0) {
            n2 = Integer.parseInt(as2[0]);
        }
        if (n1 < n2) {
            return -1;
        }
        if (n1 == n2) {
            return 0;
        }
        return 1;
    }

    public static int compareGrammarVersions(String version1, String version2) {
        String[] as1 = version1.split("\\.");
        String[] as2 = version2.split("\\.");
        int i = 0;
        while (i < Math.max(as1.length, as2.length)) {
            int n1 = 0;
            int n2 = 0;
            if (i < as1.length) {
                n1 = Integer.parseInt(as1[i]);
            }
            if (i < as2.length) {
                n2 = Integer.parseInt(as2[i]);
            }
            if (n1 < n2) {
                return -1;
            }
            if (n1 > n2) {
                return 1;
            }
            ++i;
        }
        return 0;
    }
}

