/*
 * Decompiled with CFR 0.152.
 */
package groove.util.collect;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class CollectionOfCollections<T>
extends AbstractCollection<T> {
    private final Collection<? extends Collection<? extends T>> collections;

    public CollectionOfCollections(Collection<? extends Collection<? extends T>> collections) {
        this.collections = collections;
    }

    public CollectionOfCollections(Collection<? extends T> ... collections) {
        this((Collection<Collection<? extends T>>)Arrays.asList(collections));
    }

    @Override
    public Iterator<T> iterator() {
        Iterator res = new Iterator<T>(){
            private Iterator<? extends Collection<? extends T>> collectionIter;
            private Iterator<? extends T> elemIter;
            private T latest;
            {
                this.collectionIter = CollectionOfCollections.this.getCollections().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.forwardCollectionIter();
            }

            @Override
            public T next() {
                this.forwardCollectionIter();
                Object latest = this.elemIter.next();
                return latest;
            }

            @Override
            public void remove() {
                this.elemIter.remove();
                CollectionOfCollections.this.updateRemove(this.latest);
            }

            private boolean forwardCollectionIter() {
                while (this.elemIter == null || !this.elemIter.hasNext()) {
                    if (this.collectionIter.hasNext()) {
                        this.elemIter = this.collectionIter.next().iterator();
                        continue;
                    }
                    return false;
                }
                return true;
            }
        };
        return res;
    }

    @Override
    public int size() {
        int size = 0;
        for (Collection<T> collection : this.collections) {
            size += collection.size();
        }
        return size;
    }

    protected void updateRemove(T elem) {
    }

    final Collection<? extends Collection<? extends T>> getCollections() {
        return this.collections;
    }
}

