/*
 * Decompiled with CFR 0.152.
 */
package groove.verify;

import groove.annotation.Help;
import groove.io.HTMLConverter;
import groove.util.Pair;
import groove.verify.Formula;
import groove.verify.ParseException;
import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class FormulaParser {
    private static Map<String, Token> nameToTokenMap = new HashMap<String, Token>();
    private static Map<String, Token> symbolToTokenMap = new HashMap<String, Token>();
    private static Map<String, String> nameToSymbolMap = new HashMap<String, String>();
    private static Map<Boolean, Map<String, String>> docMapMap = new HashMap<Boolean, Map<String, String>>();
    private static final boolean DEBUG = false;
    private static final Set<Token> CTLTokens;
    private static final Set<Token> LTLTokens;
    private static /* synthetic */ int[] $SWITCH_TABLE$groove$verify$FormulaParser$Token;

    static {
        Token[] tokenArray = Token.values();
        int n = tokenArray.length;
        int n2 = 0;
        while (n2 < n) {
            Token token = tokenArray[n2];
            symbolToTokenMap.put(token.getSymbol(), token);
            nameToTokenMap.put(token.name(), token);
            nameToSymbolMap.put(token.name(), Help.bf(HTMLConverter.toHtml(token.getSymbol())));
            ++n2;
        }
        CTLTokens = EnumSet.of(Token.ATOM, new Token[]{Token.TRUE, Token.FALSE, Token.NOT, Token.OR, Token.AND, Token.IMPLIES, Token.FOLLOWS, Token.EQUIV, Token.NEXT, Token.UNTIL, Token.ALWAYS, Token.EVENTUALLY, Token.FORALL, Token.EXISTS, Token.LPAR});
        LTLTokens = EnumSet.of(Token.ATOM, new Token[]{Token.TRUE, Token.FALSE, Token.NOT, Token.OR, Token.AND, Token.IMPLIES, Token.FOLLOWS, Token.EQUIV, Token.NEXT, Token.UNTIL, Token.W_UNTIL, Token.RELEASE, Token.S_RELEASE, Token.ALWAYS, Token.EVENTUALLY, Token.LPAR});
    }

    public static Formula parse(String str) throws ParseException {
        Input i = new Input(str);
        Formula result = FormulaParser.parse(i, 0);
        String suffix = i.rest();
        if (suffix.length() > 0) {
            throw new ParseException("unparsed formula suffix: " + i.rest(), new Object[0]);
        }
        return result;
    }

    public static Map<String, String> getDocMap(boolean ctl) {
        Map<String, String> result = docMapMap.get(ctl);
        if (result == null) {
            result = FormulaParser.computeDocMap(ctl);
            docMapMap.put(ctl, result);
        }
        return result;
    }

    private static Map<String, String> computeDocMap(boolean ctl) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        Field[] fieldArray = Token.class.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Help help;
            Token token;
            Field field = fieldArray[n2];
            if (field.isEnumConstant() && (ctl ? CTLTokens : LTLTokens).contains((Object)(token = nameToTokenMap.get(field.getName()))) && (help = Help.createHelp(field, nameToSymbolMap)) != null) {
                result.put(help.getItem(), help.getTip());
            }
            ++n2;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private static Formula parse(Input i, int precedence) throws ParseException {
        priority = i.get().getPriority();
        token = i.get();
        switch (FormulaParser.$SWITCH_TABLE$groove$verify$FormulaParser$Token()[token.ordinal()]) {
            case 2: 
            case 3: {
                formula = new Formula(token);
                i.skip();
                ** GOTO lbl39
            }
            case 1: {
                formula = Formula.Atom(i.text());
                i.skip();
                ** GOTO lbl39
            }
            case 4: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                i.skip();
                formula = new Formula(token, FormulaParser.parse(i, priority));
                ** GOTO lbl39
            }
            case 19: {
                i.skip();
                formula = FormulaParser.parse(i, priority);
                if (i.get() != Token.RPAR) {
                    throw new ParseException("Expected " + (Object)Token.RPAR, new Object[0]);
                }
                i.skip();
                if (true) ** GOTO lbl39
            }
            default: {
                throw new ParseException("Unexpected token: " + (Object)token, new Object[0]);
            }
        }
        do {
            priority = i.get().getPriority();
            token = i.get();
            switch (FormulaParser.$SWITCH_TABLE$groove$verify$FormulaParser$Token()[token.ordinal()]) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    if (precedence > priority) {
                        return formula;
                    }
                    i.skip();
                    formula = new Formula(token, formula, FormulaParser.parse(i, priority));
                    break;
                }
                case 20: {
                    return formula;
                }
                default: {
                    throw new ParseException("Unexpected token: " + (Object)token, new Object[0]);
                }
            }
lbl39:
            // 5 sources

        } while (!i.done());
        return formula;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$groove$verify$FormulaParser$Token() {
        if ($SWITCH_TABLE$groove$verify$FormulaParser$Token != null) {
            return $SWITCH_TABLE$groove$verify$FormulaParser$Token;
        }
        int[] nArray = new int[Token.values().length];
        try {
            nArray[Token.ALWAYS.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Token.AND.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Token.ATOM.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Token.EQUIV.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Token.EVENTUALLY.ordinal()] = 16;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Token.EXISTS.ordinal()] = 18;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Token.FALSE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Token.FOLLOWS.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Token.FORALL.ordinal()] = 17;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Token.IMPLIES.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Token.LPAR.ordinal()] = 19;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Token.NEXT.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Token.NOT.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Token.OR.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Token.RELEASE.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Token.RPAR.ordinal()] = 20;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Token.S_RELEASE.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Token.TRUE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Token.UNTIL.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Token.W_UNTIL.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$groove$verify$FormulaParser$Token = nArray;
        return nArray;
    }

    private static class Input {
        private final StringBuilder sb;
        private final Queue<Pair<Token, String>> q = new LinkedList<Pair<Token, String>>();
        private static final Set<Character> concChars = new HashSet<Character>();

        static {
            Token[] tokenArray = Token.values();
            int n = tokenArray.length;
            int n2 = 0;
            while (n2 < n) {
                Token token = tokenArray[n2];
                if (token != Token.ATOM && token != Token.LPAR && token != Token.RPAR && token != Token.NOT && !Character.isLetter(token.symbol.charAt(0))) {
                    char[] cArray = token.getSymbol().toCharArray();
                    int n3 = cArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        char c = cArray[n4];
                        concChars.add(Character.valueOf(c));
                        ++n4;
                    }
                }
                ++n2;
            }
        }

        public Input(String str) {
            this.sb = new StringBuilder(str);
        }

        public Token get() throws ParseException {
            if (this.readNext()) {
                Pair<Token, String> next = this.q.peek();
                return next.one();
            }
            throw new ParseException("Unexpected end of text", new Object[0]);
        }

        public String text() throws ParseException {
            if (this.readNext()) {
                Pair<Token, String> next = this.q.peek();
                return next.two();
            }
            throw new ParseException("Unexpected end of text", new Object[0]);
        }

        public void skip() throws ParseException {
            if (!this.readNext()) {
                throw new ParseException("Unexpected end of text", new Object[0]);
            }
            this.q.poll();
        }

        public String rest() {
            StringBuffer result = new StringBuffer();
            for (Pair pair : this.q) {
                if (pair.one() == Token.ATOM) {
                    result.append((String)pair.two());
                    continue;
                }
                result.append(pair.one());
            }
            if (result.length() > 0 && this.sb.length() > 0) {
                result.append(' ');
            }
            result.append((CharSequence)this.sb);
            return result.toString();
        }

        public boolean done() throws ParseException {
            return !this.readNext();
        }

        /*
         * Unable to fully structure code
         */
        private boolean readNext() throws ParseException {
            if (this.q.isEmpty()) ** GOTO lbl5
            return true;
lbl-1000:
            // 1 sources

            {
                this.sb.deleteCharAt(0);
lbl5:
                // 2 sources

                ** while (this.sb.length() > 0 && Character.isWhitespace((char)this.sb.charAt((int)0)))
            }
lbl6:
            // 1 sources

            if (this.sb.length() == 0) {
                return false;
            }
            c = this.sb.charAt(0);
            if (Character.isJavaIdentifierStart(c)) {
                this.readNextWord(c);
            } else if (c == '\'' || c == '\"') {
                this.readNextQuotedAtom(c);
            } else {
                this.readNextOther(c);
            }
            return true;
        }

        private void readNextOther(char c) throws ParseException {
            StringBuffer text = new StringBuffer();
            text.append(c);
            if (concChars.contains(Character.valueOf(c))) {
                int i = 1;
                while (i < this.sb.length() && concChars.contains(Character.valueOf(c = this.sb.charAt(i)))) {
                    text.append(c);
                    ++i;
                }
            }
            this.q.add(this.createToken(text.toString()));
            this.sb.delete(0, text.length());
        }

        private void readNextWord(char c) throws ParseException {
            StringBuffer text = new StringBuffer();
            text.append(c);
            boolean caps = Character.isUpperCase(c);
            boolean allCaps = Character.isUpperCase(c);
            int i = 1;
            while (i < this.sb.length() && Character.isJavaIdentifierPart(c = this.sb.charAt(i))) {
                text.append(c);
                allCaps &= Character.isUpperCase(c);
                ++i;
            }
            if (caps) {
                if (!allCaps) {
                    throw new ParseException("Uppercase atom '%s' not allowed", text);
                }
                i = 0;
                while (i < text.length()) {
                    this.q.add(this.createToken("" + text.charAt(i)));
                    ++i;
                }
            } else {
                this.q.add(this.createAtom(text.toString()));
            }
            this.sb.delete(0, text.length());
        }

        private void readNextQuotedAtom(char c) throws ParseException {
            StringBuffer text = new StringBuffer();
            char quote = c;
            int i = 1;
            while (i < this.sb.length() && (c = this.sb.charAt(i)) != quote) {
                if (c == '\\') {
                    if (++i == this.sb.length()) {
                        throw new ParseException("Unexpected end of text", new Object[0]);
                    }
                    c = this.sb.charAt(i);
                    if (c != '\\' && c != quote) {
                        throw new ParseException("Invalid escaped character: " + c, new Object[0]);
                    }
                }
                text.append(c);
                ++i;
            }
            if (i == this.sb.length()) {
                throw new ParseException("Unexpected end of text while scanning for closing " + quote, new Object[0]);
            }
            this.q.add(this.createAtom(text.toString()));
            this.sb.delete(0, text.length() + 2);
        }

        private Pair<Token, String> createToken(String symbol) throws ParseException {
            Token token = (Token)((Object)symbolToTokenMap.get(symbol));
            if (token == null) {
                throw new ParseException("Can't parse token '%s'", symbol);
            }
            return new Pair<Token, Object>(token, null);
        }

        private Pair<Token, String> createAtom(String text) {
            if (text.equals(Token.TRUE.getSymbol())) {
                return new Pair<Token, Object>(Token.TRUE, null);
            }
            if (text.equals(Token.FALSE.getSymbol())) {
                return new Pair<Token, Object>(Token.FALSE, null);
            }
            return new Pair<Token, String>(Token.ATOM, text);
        }
    }

    public static enum Token {
        ATOM("", 0, 7),
        TRUE("true", 0, 7),
        FALSE("false", 0, 7),
        NOT("!", 1, 6),
        OR("|", 2, 2),
        AND("&", 2, 3),
        IMPLIES("->", 2, 1),
        FOLLOWS("<-", 2, 1),
        EQUIV("<->", 2, 1),
        NEXT("X", 1, 6),
        UNTIL("U", 2, 4),
        W_UNTIL("W", 2, 4),
        RELEASE("R", 2, 4),
        S_RELEASE("M", 2, 4),
        ALWAYS("G", 1, 6),
        EVENTUALLY("F", 1, 6),
        FORALL("A", 1, 3),
        EXISTS("E", 1, 3),
        LPAR("("),
        RPAR(")");

        private final String symbol;
        private final int arity;
        private final int priority;

        private Token(String symbol) {
            this(symbol, -1, 0);
        }

        private Token(String symbol, int arity, int priority) {
            this.symbol = symbol;
            this.arity = arity;
            this.priority = priority;
        }

        public String toString() {
            return this.getSymbol();
        }

        String getSymbol() {
            return this.symbol;
        }

        int getArity() {
            return this.arity;
        }

        int getPriority() {
            return this.priority;
        }
    }
}

