/*
 * Decompiled with CFR 0.152.
 */
package groove.verify;

import groove.lts.GraphState;
import groove.lts.GraphTransition;
import groove.verify.BuchiLocation;
import groove.verify.ModelChecking;
import groove.verify.ProductTransition;
import java.util.ArrayList;
import java.util.List;

public class ProductState {
    private final GraphState state;
    private final BuchiLocation buchiLocation;
    private final GraphTransition origin;
    private final List<ProductTransition> outTransitions = new ArrayList<ProductTransition>();
    private int colour;
    private boolean pocket = false;
    private int iteration;
    private boolean closed = false;
    private boolean explored = false;

    public ProductState(GraphState state, BuchiLocation buchiLocation) {
        this.state = state;
        this.buchiLocation = buchiLocation;
        this.origin = null;
        this.colour = ModelChecking.NO_COLOUR;
    }

    public ProductState(GraphTransition origin, BuchiLocation buchiLocation) {
        this.state = origin.target();
        this.buchiLocation = buchiLocation;
        this.origin = origin;
        this.colour = ModelChecking.NO_COLOUR;
    }

    public GraphState getGraphState() {
        return this.state;
    }

    public BuchiLocation getBuchiLocation() {
        return this.buchiLocation;
    }

    public GraphTransition getOrigin() {
        return this.origin;
    }

    public int colour() {
        return this.colour;
    }

    public void setColour(int value) {
        this.colour = value;
    }

    public boolean isPocket() {
        return this.pocket;
    }

    public void setPocket() {
        assert (!this.pocket) : "state should not be set to pocket twice";
        this.pocket = true;
    }

    public int iteration() {
        return this.iteration;
    }

    public void setIteration(int value) {
        this.iteration = value;
    }

    public void addTransition(ProductTransition transition) {
        this.outTransitions.add(transition);
    }

    public List<ProductTransition> outTransitions() {
        return this.outTransitions;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean setClosed() {
        boolean result;
        boolean bl = result = !this.closed;
        if (result) {
            this.closed = true;
        }
        return result;
    }

    public boolean isExplored() {
        return this.explored;
    }

    public void setExplored() {
        this.explored = true;
    }

    public int hashCode() {
        return System.identityHashCode(this.state) + System.identityHashCode(this.buchiLocation);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ProductState)) {
            return false;
        }
        ProductState other = (ProductState)obj;
        return this.state == other.state && this.buchiLocation == other.buchiLocation;
    }

    public String toString() {
        if (this.state != null && this.buchiLocation != null) {
            return String.valueOf(this.state.toString()) + "-" + this.buchiLocation.toString();
        }
        return "??";
    }
}

