/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import org.stamppagetor.ImageStore;
import org.stamppagetor.image.ImageFilenameFilter;

public class ImageCache {
    private static final FilenameFilter imageFileFilter = new ImageFilenameFilter();
    private static final int thumbSize = 96;
    private File pathOfImages;
    private TreeMap<String, ImageStore> imageMap = new TreeMap();
    private static ImageCache theInstance = null;

    private ImageCache() {
    }

    public static ImageCache getInstance() {
        if (theInstance == null) {
            theInstance = new ImageCache();
        }
        return theInstance;
    }

    public void reloadImages(File file) {
        this.imageMap.clear();
        this.pathOfImages = file;
        File[] fileArray = this.pathOfImages.listFiles(imageFileFilter);
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            try {
                ImageIcon imageIcon;
                long l;
                File file2 = fileArray[i];
                if (!file2.isFile() || !file2.canRead() || (l = file2.length()) < 1024L || l >= 0x100000L || (imageIcon = new ImageIcon(fileArray[i].getAbsolutePath(), fileArray[i].getName())) == null) continue;
                ImageStore imageStore = new ImageStore();
                Image image = imageIcon.getImage();
                imageStore.originalIcon = imageIcon;
                imageStore.colorImage = this.createColorImageWithWhiteBackground(image);
                imageStore.grayScaleImage = this.createGrayscaleImageWithWhiteBackground(image);
                imageStore.thumbIcon = new ImageIcon(this.createThumbImage(image), fileArray[i].getName());
                this.imageMap.put(fileArray[i].getName(), imageStore);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Set<String> getImageIds() {
        return this.imageMap.keySet();
    }

    public ImageIcon getThumbIcon(String string) {
        return this.imageMap.get((Object)string).thumbIcon;
    }

    public BufferedImage getColorImage(String string) {
        ImageStore imageStore = this.imageMap.get(string);
        if (imageStore == null) {
            return null;
        }
        return imageStore.colorImage;
    }

    public BufferedImage getGrayscaleImage(String string) {
        ImageStore imageStore = this.imageMap.get(string);
        if (imageStore == null) {
            return null;
        }
        return imageStore.grayScaleImage;
    }

    private BufferedImage createThumbImage(Image image) {
        int n;
        int n2;
        BufferedImage bufferedImage = new BufferedImage(96, 96, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        int n3 = image.getWidth(null);
        int n4 = image.getHeight(null);
        if (n4 > n3) {
            n2 = 96 * n3 / n4;
            n = 96;
        } else {
            n2 = 96;
            n = 96 * n4 / n3;
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, 96, 96);
        graphics2D.drawImage(image, (96 - n2) / 2, (96 - n) / 2, n2, n, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage createImageWithWhiteBackground(Image image, int n) {
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(n2, n3, n);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, n2, n3);
        graphics2D.drawImage(image, 0, 0, null);
        return bufferedImage;
    }

    private BufferedImage createColorImageWithWhiteBackground(Image image) {
        return this.createImageWithWhiteBackground(image, 1);
    }

    private BufferedImage createGrayscaleImageWithWhiteBackground(Image image) {
        return this.createImageWithWhiteBackground(image, 10);
    }
}

