/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Set;
import java.util.TreeMap;
import org.stamppagetor.StampShapeDiamond;
import org.stamppagetor.StampShapeOval;
import org.stamppagetor.StampShapeRect;
import org.stamppagetor.StampShapeTriangle;

public abstract class StampShape {
    private static TreeMap<String, StampShape> shapes = null;
    private static String[] shapeNameArray = null;
    private static final float lineWeight = 0.5f;
    protected static final BasicStroke shapeLine = new BasicStroke(0.5f);

    public abstract void draw(Graphics2D var1, Rectangle var2);

    public static StampShape getShape(String string) {
        if (shapes == null) {
            StampShape.initShapes();
        }
        return shapes.get(string);
    }

    private static void initShapes() {
        shapes = new TreeMap();
        shapes.put("rect", new StampShapeRect());
        shapes.put("oval", new StampShapeOval());
        shapes.put("triangle", new StampShapeTriangle());
        shapes.put("diamond", new StampShapeDiamond());
    }

    public static Set<String> getShapeNames() {
        if (shapes == null) {
            StampShape.initShapes();
        }
        return shapes.keySet();
    }

    public static String[] getShapeNameArray() {
        if (shapeNameArray == null) {
            Set<String> set = StampShape.getShapeNames();
            shapeNameArray = new String[set.size()];
            set.toArray(shapeNameArray);
        }
        return shapeNameArray;
    }
}

