/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.PrintStream;
import org.stamppagetor.DocStyle;
import org.stamppagetor.Misc;
import org.stamppagetor.StampPrintable;
import org.w3c.dom.Node;

public abstract class StampText
extends StampPrintable {
    public static final String XML_NODE_NAME = "text";
    private String text;
    private final Font font;
    private final String fontName = "Helvetica";
    private final int fontStyle;
    private final int fontSize;
    private final int margin;

    public StampText(String string, int n, int n2, int n3) {
        this.fontStyle = n;
        this.fontSize = n2;
        this.text = string;
        this.margin = n3;
        this.font = new Font(this.fontName, n, n2);
    }

    public StampText(Node node, int n, int n2, int n3) {
        this(node.getTextContent(), n, n2, n3);
    }

    public StampText(StampText stampText) {
        this(stampText.text, stampText.fontStyle, stampText.fontSize, stampText.margin);
    }

    @Override
    public abstract StampPrintable deepCopy();

    @Override
    public void toXml(PrintStream printStream, String string) {
        printStream.println(string + "  <text>" + Misc.covertToXmlString(this.text) + "</text>");
    }

    @Override
    public void print(Graphics graphics, DocStyle docStyle, StampPrintable stampPrintable, Rectangle rectangle) {
        this.printRect(graphics, stampPrintable, rectangle);
        graphics.setFont(this.font);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
        int n = fontMetrics.stringWidth(this.text);
        int n2 = fontMetrics.getMaxDescent();
        graphics.drawString(this.text, rectangle.x + rectangle.width / 2 - n / 2, rectangle.y + rectangle.height - this.margin - n2 - 1);
    }

    @Override
    protected Rectangle[] getPartPlaces(Rectangle rectangle, DocStyle docStyle) {
        return null;
    }

    @Override
    protected int getHeight(DocStyle docStyle) {
        return (int)(1.5 * (double)this.fontSize + (double)(2 * this.margin));
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }
}

