/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor;

import java.util.LinkedList;
import java.util.List;
import org.stamppagetor.StampDocument;
import org.stamppagetor.UiPlatform;
import org.stamppagetor.UndoItem;

public class UndoStore {
    private final List<UndoItem> list = new LinkedList<UndoItem>();
    private int step = 0;
    private final int limit;

    public UndoStore(int n) {
        this.limit = n;
    }

    public void addState(UiPlatform uiPlatform, String string) {
        UndoItem undoItem = new UndoItem(string, (StampDocument)uiPlatform.getDoc().deepCopy(), uiPlatform.getSelectedPage());
        if (this.step >= this.list.size()) {
            this.list.add(undoItem);
        } else {
            this.list.set(this.step, undoItem);
        }
        ++this.step;
        if (this.list.size() > this.limit) {
            this.list.remove(0);
            --this.step;
        }
    }

    public void undo(UiPlatform uiPlatform) {
        if (this.canUndo()) {
            if (this.step >= this.list.size()) {
                this.addState(uiPlatform, "undo");
                --this.step;
            }
            UndoItem undoItem = this.list.get(this.step - 1);
            uiPlatform.setDoc(undoItem.getDocument());
            uiPlatform.setSelectedPage(undoItem.getPageIndex(), null);
            --this.step;
        }
    }

    public void redo(UiPlatform uiPlatform) {
        if (this.canRedo()) {
            UndoItem undoItem = this.list.get(this.step + 1);
            uiPlatform.setDoc(undoItem.getDocument());
            uiPlatform.setSelectedPage(undoItem.getPageIndex(), null);
            ++this.step;
        }
    }

    public boolean canUndo() {
        return this.step > 0;
    }

    public boolean canRedo() {
        return this.step < this.list.size() - 1;
    }

    public void clearRedoBuffer() {
        while (this.step < this.list.size() && this.list.size() > 0) {
            this.list.remove(this.list.size() - 1);
        }
    }

    public String undoStepName() {
        if (this.step <= 0) {
            return "none";
        }
        return this.list.get(this.step - 1).getName();
    }

    public Object[] getList() {
        int n = 0;
        for (UndoItem undoItem : this.list) {
            undoItem.setNextToUndo(this.step - 1 == n);
            undoItem.setNextToRedo(this.step == n);
            ++n;
        }
        return this.list.toArray();
    }
}

