/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor.image;

import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

class ImageEditList
implements ListModel {
    private final Vector<BufferedImage> originalImages = new Vector();
    private final Vector<BufferedImage> displayImages = new Vector();
    private final Vector<ImageIcon> imageIcons = new Vector();
    private final Vector<ListDataListener> listListeners = new Vector();

    ImageEditList() {
    }

    @Override
    public int getSize() {
        return this.imageIcons.size();
    }

    @Override
    public void addListDataListener(ListDataListener listDataListener) {
        this.listListeners.add(listDataListener);
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
        this.listListeners.remove(listDataListener);
    }

    public Object getElementAt(int n) {
        return this.imageIcons.elementAt(n);
    }

    public void setImages(Vector<BufferedImage> vector) {
        int n = vector.size();
        this.originalImages.clear();
        this.displayImages.clear();
        this.imageIcons.clear();
        this.originalImages.addAll(vector);
        for (int i = 0; i < n; ++i) {
            BufferedImage object = this.createDisplayImage(this.originalImages.elementAt(i));
            this.displayImages.add(object);
            this.imageIcons.add(new ImageIcon(object, Integer.toString(i)));
        }
        for (ListDataListener listDataListener : this.listListeners) {
            listDataListener.intervalAdded(new ListDataEvent(this, 1, 0, n - 1));
        }
    }

    public Vector<BufferedImage> getImages() {
        return this.originalImages;
    }

    public void deleteImage(int n) {
        this.originalImages.remove(n);
        this.displayImages.remove(n);
        this.imageIcons.remove(n);
        for (ListDataListener listDataListener : this.listListeners) {
            listDataListener.intervalRemoved(new ListDataEvent(this, 2, n, n));
        }
    }

    public void rotateImage90(int n, boolean bl) {
        BufferedImage bufferedImage = this.rotate90Image(this.displayImages.elementAt(n), bl);
        BufferedImage bufferedImage2 = this.rotate90Image(this.originalImages.elementAt(n), bl);
        this.imageIcons.elementAt(n).setImage(bufferedImage);
        this.displayImages.set(n, bufferedImage);
        this.originalImages.set(n, bufferedImage2);
        for (ListDataListener listDataListener : this.listListeners) {
            listDataListener.contentsChanged(new ListDataEvent(this, 0, n, n));
        }
    }

    private BufferedImage rotate90Image(BufferedImage bufferedImage, boolean bl) {
        int n = bufferedImage.getHeight();
        int n2 = bufferedImage.getWidth();
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, bufferedImage.getType());
        if (bl) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    bufferedImage2.setRGB(j, i, bufferedImage.getRGB(i, n - 1 - j));
                }
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    bufferedImage2.setRGB(j, i, bufferedImage.getRGB(n2 - 1 - i, j));
                }
            }
        }
        return bufferedImage2;
    }

    private BufferedImage createDisplayImage(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth(null);
        int n2 = bufferedImage.getHeight(null);
        int n3 = Math.min(524288 / n, 524288 / n2);
        int n4 = n * n3 / 4096;
        int n5 = n2 * n3 / 4096;
        int n6 = (128 - n4) / 2;
        int n7 = (128 - n5) / 2;
        int n8 = n6 + n4;
        int n9 = n7 + n5;
        BufferedImage bufferedImage2 = new BufferedImage(128, 128, bufferedImage.getType());
        bufferedImage2.getGraphics().drawImage(bufferedImage, n6, n7, n8, n9, 0, 0, n, n2, null);
        return bufferedImage2;
    }
}

