/*
 * Decompiled with CFR 0.152.
 */
package org.stamppagetor.image;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.imageio.ImageIO;
import org.stamppagetor.image.ColorCube;
import org.stamppagetor.image.ImageArea;
import org.stamppagetor.image.ImagePickerInterface;
import org.stamppagetor.image.ImagePickerProgressListener;

public class ImagePickerPolygonSimplify
implements ImagePickerInterface {
    private static final byte STA_TRANSPARENT = 0;
    private static final byte STA_IMAGE_PIXEL = 1;
    private static final byte STA_IMAGE_EDGE = 2;
    private static final byte STA_OUTSIDE_IMAGE = 3;
    private static final int PHASE_NOT_STARTED = 0;
    private static final int PHASE_LOADING = 1;
    private static final int PHASE_PREPARATIONS = 2;
    private static final int PHASE_FIND_ALPHA = 3;
    private static final int PHASE_MARK_ALPHA = 4;
    private static final int PHASE_FIND_STAMPS = 5;
    private static final int PHASE_CREATE_IMAGES = 6;
    private static final int PHASE_READY = 7;
    private static final int PHASE_FAILED = 8;
    private static final String[] PHASE_NAMES = new String[]{"Not started", "Loading image", "Preparations", "Findind background color", "Marking alpha color", "Find stamp areas", "Creating stamp images", "Ready", "Failed"};
    private static final int[] PHASE_TIMES = new int[]{0, 40, 60, 70, 80, 85, 100, 100, 100};
    private File sourceFileName = null;
    private int alphaColor = 0;
    private BufferedImage origImage = null;
    private BufferedImage dispImage = null;
    private int[][] rgbBuffer = null;
    private byte[][] staBuffer = null;
    private final Vector<ImageArea> areas = new Vector();
    private final Vector<BufferedImage> images = new Vector();
    private final ColorCube colorCube = new ColorCube(4);

    @Override
    public Vector<BufferedImage> getImages() {
        return this.images;
    }

    @Override
    public BufferedImage getOriginalImage() {
        return this.dispImage;
    }

    @Override
    public String getPhaseName(int n) {
        return PHASE_NAMES[n];
    }

    @Override
    public boolean isFinalPhase(int n) {
        return n == 7 || n == 8;
    }

    @Override
    public void process(ImagePickerProgressListener imagePickerProgressListener) {
        try {
            for (int i = 0; i != 7; ++i) {
                this.runPhase(i, imagePickerProgressListener);
                imagePickerProgressListener.imagePickerProgress(PHASE_TIMES[i]);
            }
            imagePickerProgressListener.imagePickerPhase(7);
        }
        catch (IOException iOException) {
            imagePickerProgressListener.imagePickerPhase(8);
        }
    }

    @Override
    public void setSourceFile(File file) {
        this.sourceFileName = file;
    }

    @Override
    public Vector<Polygon> getCropPolygons() {
        Vector<Polygon> vector = new Vector<Polygon>();
        for (ImageArea imageArea : this.areas) {
            vector.add(imageArea.createPolygon(1.0));
        }
        return vector;
    }

    private void runPhase(int n, ImagePickerProgressListener imagePickerProgressListener) throws IOException {
        imagePickerProgressListener.imagePickerPhase(n);
        switch (n) {
            case 1: {
                this.loadingSourceImage();
                break;
            }
            case 2: {
                this.prepareWorkingData();
                break;
            }
            case 3: {
                this.colorCube.reset();
                this.colorCube.countColors(this.rgbBuffer);
                this.alphaColor = this.colorCube.findMaxColor();
                this.colorCube.buildAlphaCube(this.alphaColor);
                break;
            }
            case 4: {
                this.markAlpha(this.rgbBuffer, this.staBuffer, this.alphaColor);
                break;
            }
            case 5: {
                this.findAreas(this.staBuffer);
                this.increaseAreas();
                this.removeUnwantedShapes();
                break;
            }
            case 6: {
                this.sampleImages(this.alphaColor);
                this.updateDisplayImage();
            }
        }
    }

    private void loadingSourceImage() throws IOException {
        this.origImage = ImageIO.read(this.sourceFileName);
        int n = this.origImage.getWidth();
        int n2 = this.origImage.getHeight();
        int n3 = 768 * n2 / n;
        this.dispImage = new BufferedImage(768, n3, 2);
        this.rgbBuffer = new int[768][n3];
        this.staBuffer = new byte[768][n3];
        Graphics graphics = this.dispImage.getGraphics();
        graphics.drawImage(this.origImage, 0, 0, 768, n3, 0, 0, n, n2, null);
    }

    private void prepareWorkingData() {
        int n;
        int n2;
        int n3 = this.dispImage.getHeight();
        int n4 = this.dispImage.getWidth();
        BufferedImage bufferedImage = this.dispImage;
        int[][] nArray = this.rgbBuffer;
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                nArray[n][n2] = bufferedImage.getRGB(n, n2) & 0xF8F8F8;
            }
        }
        this.blurArrayImage(nArray, n4, n3);
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                nArray[n][n2] = nArray[n][n2] & 0xFCFCFC;
            }
        }
    }

    private void blurArrayImage(int[][] nArray, int n, int n2) {
        for (int i = 1; i < n2 - 1; ++i) {
            for (int j = 1; j < n - 1; ++j) {
                int n3 = ((nArray[j - 1][i] & 0xFCFCFC) >> 2) + ((nArray[j + 1][i] & 0xFCFCFC) >> 2) + ((nArray[j][i - 1] & 0xFCFCFC) >> 2) + ((nArray[j][i + 1] & 0xFCFCFC) >> 2);
                nArray[j][i] = ((nArray[j][i] & 0xFEFEFE) >> 1) + ((n3 & 0xFEFEFE) >> 1);
            }
        }
    }

    private void updateDisplayImage() {
        int n = this.dispImage.getHeight();
        int n2 = this.dispImage.getWidth();
        BufferedImage bufferedImage = this.dispImage;
        int[][] nArray = this.rgbBuffer;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n3 = this.colorCube.getAlphaLevel(nArray[j][i]) * 32;
                if (n3 > 0) {
                    bufferedImage.setRGB(j, i, 0xFF000000 | n3 << 16 | n3 << 8 | n3 << 0);
                    continue;
                }
                bufferedImage.setRGB(j, i, -24416);
            }
        }
    }

    private void markAlpha(int[][] nArray, byte[][] byArray, int n) {
        int n2 = nArray[0].length;
        int n3 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                byArray[j][i] = this.colorCube.getAlphaLevel(nArray[j][i]) > 0 ? (byte)0 : 1;
            }
        }
    }

    private void bloodAlpha(byte[][] byArray, int n, int n2, int n3, int n4, byte by, byte by2) {
        if (byArray[n][n2] != by) {
            return;
        }
        int[] nArray = new int[n3 * n4];
        int[] nArray2 = new int[n3 * n4];
        int n5 = 0;
        nArray[n5] = n;
        nArray2[n5] = n2;
        ++n5;
        while (n5 > 0) {
            if (byArray[n = nArray[--n5]][n2 = nArray2[n5]] == by) {
                byArray[n][n2] = by2;
            }
            if (n > 0 && byArray[n - 1][n2] == by) {
                byArray[n - 1][n2] = by2;
                nArray[n5] = n - 1;
                nArray2[n5] = n2;
                ++n5;
            }
            if (n2 > 0 && byArray[n][n2 - 1] == by) {
                byArray[n][n2 - 1] = by2;
                nArray[n5] = n;
                nArray2[n5] = n2 - 1;
                ++n5;
            }
            if (n < n3 - 1 && byArray[n + 1][n2] == by) {
                byArray[n + 1][n2] = by2;
                nArray[n5] = n + 1;
                nArray2[n5] = n2;
                ++n5;
            }
            if (n2 >= n4 - 1 || byArray[n][n2 + 1] != by) continue;
            byArray[n][n2 + 1] = by2;
            nArray[n5] = n;
            nArray2[n5] = n2 + 1;
            ++n5;
        }
    }

    private static ImageArea vectorize(byte[][] byArray, int n, int n2) {
        int n3 = byArray[0].length;
        int n4 = byArray.length;
        int n5 = n;
        int n6 = n2;
        int n7 = 0;
        ImageArea imageArea = new ImageArea();
        imageArea.addPoint(new Point(n5, n6));
        do {
            boolean bl = n6 > 0 && byArray[n5][n6 - 1] != 0;
            boolean bl2 = n5 + 1 < n4 && byArray[n5 + 1][n6] != 0;
            boolean bl3 = n6 + 1 < n3 && byArray[n5][n6 + 1] != 0;
            boolean bl4 = n5 > 0 && byArray[n5 - 1][n6] != 0;
            switch (n7) {
                case 0: {
                    if (bl) {
                        --n6;
                        n7 = 3;
                        break;
                    }
                    if (bl2) {
                        ++n5;
                        n7 = 0;
                        break;
                    }
                    if (bl3) {
                        ++n6;
                        n7 = 1;
                        break;
                    }
                    if (!bl4) break;
                    --n5;
                    n7 = 2;
                    break;
                }
                case 1: {
                    if (bl2) {
                        ++n5;
                        n7 = 0;
                        break;
                    }
                    if (bl3) {
                        ++n6;
                        n7 = 1;
                        break;
                    }
                    if (bl4) {
                        --n5;
                        n7 = 2;
                        break;
                    }
                    if (!bl) break;
                    --n6;
                    n7 = 3;
                    break;
                }
                case 2: {
                    if (bl3) {
                        ++n6;
                        n7 = 1;
                        break;
                    }
                    if (bl4) {
                        --n5;
                        n7 = 2;
                        break;
                    }
                    if (bl) {
                        --n6;
                        n7 = 3;
                        break;
                    }
                    if (!bl2) break;
                    ++n5;
                    n7 = 0;
                    break;
                }
                case 3: {
                    if (bl4) {
                        --n5;
                        n7 = 2;
                        break;
                    }
                    if (bl) {
                        --n6;
                        n7 = 3;
                        break;
                    }
                    if (bl2) {
                        ++n5;
                        n7 = 0;
                        break;
                    }
                    if (!bl3) break;
                    ++n6;
                    n7 = 1;
                }
            }
            byArray[n5][n6] = 2;
            imageArea.addPoint(new Point(n5, n6));
        } while (n != n5 || n2 != n6);
        return imageArea;
    }

    private void findAreas(byte[][] byArray) {
        int n = 0;
        int n2 = 0;
        int n3 = byArray[0].length;
        int n4 = byArray.length;
        int n5 = (n3 + n4) / 6;
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                ImageArea imageArea;
                int n6;
                if (byArray[n][n2] != 1 || (n6 = (imageArea = ImagePickerPolygonSimplify.vectorize(byArray, n, n2)).getSize()) <= n5) continue;
                while (imageArea.removeInnerCorners() > 0) {
                }
                while (imageArea.joinPoints() > 0) {
                }
                while (imageArea.removeInnerCorners() > 0) {
                }
                imageArea.simplifyLines();
                imageArea.joinPoints();
                imageArea.simplifyLines();
                Point point = imageArea.getMiddlePoint();
                this.bloodAlpha(byArray, point.x, point.y, n4, n3, (byte)0, (byte)1);
                this.bloodAlpha(byArray, point.x, point.y, n4, n3, (byte)1, (byte)0);
                this.bloodAlpha(byArray, point.x, point.y, n4, n3, (byte)0, (byte)2);
                this.areas.add(imageArea);
            }
        }
    }

    private int[][] sampleImage(ImageArea imageArea, int n) {
        int n2 = imageArea.findIndexOfLongestLine();
        Point point = imageArea.getPoint((n2 + 0) % 4);
        Point point2 = imageArea.getPoint((n2 + 1) % 4);
        Point point3 = imageArea.getPoint((n2 + 2) % 4);
        Point point4 = imageArea.getPoint((n2 + 3) % 4);
        double d = point.distance(point2);
        double d2 = point2.distance(point3);
        double d3 = point4.distance(point);
        int n3 = (int)(256.0 * (d2 + d3) / 2.0 / d);
        double d4 = n3;
        double d5 = point.getX();
        double d6 = point2.getX();
        double d7 = point3.getX();
        double d8 = point4.getX();
        double d9 = point.getY();
        double d10 = point2.getY();
        double d11 = point3.getY();
        double d12 = point4.getY();
        int n4 = this.origImage.getWidth(null);
        int n5 = this.origImage.getHeight(null);
        int n6 = this.dispImage.getWidth();
        int n7 = this.dispImage.getHeight();
        int[][] nArray = new int[256][n3];
        for (int i = 0; i < 256; ++i) {
            double d13 = (double)i / 256.0;
            for (int j = 0; j < n3; ++j) {
                double d14 = (double)j / d4;
                int n8 = (int)((double)n4 * (((1.0 - d13) * d5 + d13 * d6) * (1.0 - d14) + ((1.0 - d13) * d8 + d13 * d7) * d14) / (double)n6);
                int n9 = (int)((double)n5 * (((1.0 - d14) * d9 + d14 * d12) * (1.0 - d13) + ((1.0 - d14) * d10 + d14 * d11) * d13) / (double)n7);
                nArray[i][j] = n8 >= 0 && n9 >= 0 && n8 < n4 && n9 < n5 ? this.origImage.getRGB(n8, n9) : n;
            }
        }
        return nArray;
    }

    private void sampleImages(int n) {
        this.images.clear();
        for (ImageArea imageArea : this.areas) {
            if (imageArea.getSize() != 4) continue;
            int[][] nArray = this.sampleImage(imageArea, n);
            int n2 = nArray.length;
            int n3 = nArray[0].length;
            byte[][] byArray = new byte[n2][n3];
            this.markAlpha(nArray, byArray, n);
            this.bloodAlpha(byArray, 1, 1, n2, n3, (byte)0, (byte)3);
            BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    if (byArray[i][j] == 3) {
                        bufferedImage.setRGB(i, j, 0xFFFFFF);
                        continue;
                    }
                    bufferedImage.setRGB(i, j, nArray[i][j] | 0xFF000000);
                }
            }
            this.images.add(bufferedImage);
        }
    }

    private void removeUnwantedShapes() {
        int n = 0;
        while (n < this.areas.size()) {
            ImageArea imageArea = this.areas.elementAt(n);
            if (imageArea.getSize() != 4) {
                this.areas.remove(n);
                continue;
            }
            ++n;
        }
    }

    private void increaseAreas() {
        for (ImageArea imageArea : this.areas) {
            imageArea.increaseArea(10);
        }
    }
}

